/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip;

import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip.NioZipEncoding;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncoding;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public abstract class ZipEncodingHelper {
    static final ZipEncoding UTF8_ZIP_ENCODING = ZipEncodingHelper.getZipEncoding("UTF8");

    public static ZipEncoding getZipEncoding(String string) {
        Charset charset = Charset.defaultCharset();
        if (string != null) {
            try {
                charset = Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        boolean bl2 = ZipEncodingHelper.isUTF8(charset.name());
        return new NioZipEncoding(charset, bl2);
    }

    static boolean isUTF8(String string) {
        if (string == null) {
            string = Charset.defaultCharset().name();
        }
        if (StandardCharsets.UTF_8.name().equalsIgnoreCase(string)) {
            return true;
        }
        for (String string2 : StandardCharsets.UTF_8.aliases()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    static ByteBuffer growBufferBy(ByteBuffer byteBuffer, int n2) {
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.rewind();
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.capacity() + n2);
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }
}

