/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.AtomicBiInteger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.IO;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.DumpableCollection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Locker;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class Pool<T>
implements AutoCloseable,
Dumpable {
    private static final Logger LOGGER = Log.getLogger(Pool.class);
    private final List<Entry> entries = new CopyOnWriteArrayList<Entry>();
    private final int maxEntries;
    private final StrategyType strategyType;
    private final Locker locker = new Locker();
    private final ThreadLocal<Entry> cache;
    private final AtomicInteger nextIndex;
    private volatile boolean closed;
    @Deprecated
    private volatile int maxUsage = -1;
    @Deprecated
    private volatile int maxMultiplex = -1;

    public Pool(StrategyType strategyType, int n2, boolean bl2) {
        this.maxEntries = n2;
        this.strategyType = strategyType;
        this.cache = bl2 ? new ThreadLocal() : null;
        this.nextIndex = strategyType == StrategyType.ROUND_ROBIN ? new AtomicInteger() : null;
    }

    public int getIdleCount() {
        return (int)this.entries.stream().filter(Entry::isIdle).count();
    }

    public int getInUseCount() {
        return (int)this.entries.stream().filter(Entry::isInUse).count();
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    @Deprecated
    public int getMaxMultiplex() {
        return this.maxMultiplex == -1 ? 1 : this.maxMultiplex;
    }

    @Deprecated
    protected int getMaxMultiplex(T t2) {
        return this.getMaxMultiplex();
    }

    @Deprecated
    public final void setMaxMultiplex(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Max multiplex must be >= 1");
        }
        try (Locker.Lock lock = this.locker.lock();){
            if (this.closed) {
                return;
            }
            if (this.entries.stream().anyMatch(MonoEntry.class::isInstance)) {
                throw new IllegalStateException("Pool entries do not support multiplexing");
            }
            this.maxMultiplex = n2;
        }
    }

    @Deprecated
    public int getMaxUsageCount() {
        return this.maxUsage;
    }

    @Deprecated
    protected int getMaxUsageCount(T t2) {
        return this.getMaxUsageCount();
    }

    public Entry reserve() {
        try (Locker.Lock lock = this.locker.lock();){
            if (this.closed) {
                Entry entry = null;
                return entry;
            }
            if (this.entries.size() >= this.maxEntries) {
                Entry entry = null;
                return entry;
            }
            Entry entry = this.newEntry();
            this.entries.add(entry);
            Entry entry2 = entry;
            return entry2;
        }
    }

    private Entry newEntry() {
        if (this.maxMultiplex >= 0 || this.maxUsage >= 0) {
            return new MultiEntry();
        }
        return new MonoEntry();
    }

    public Entry acquire() {
        Entry entry;
        if (this.closed) {
            return null;
        }
        int n2 = this.entries.size();
        if (n2 == 0) {
            return null;
        }
        if (this.cache != null && (entry = this.cache.get()) != null && entry.tryAcquire()) {
            return entry;
        }
        int n3 = this.startIndex(n2);
        int n4 = n2;
        while (n4-- > 0) {
            try {
                Entry entry2 = this.entries.get(n3);
                if (entry2 != null && entry2.tryAcquire()) {
                    return entry2;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                LOGGER.ignore(indexOutOfBoundsException);
                n2 = this.entries.size();
                if (n2 == 0) break;
            }
            n3 = (n3 + 1) % n2;
        }
        return null;
    }

    private int startIndex(int n3) {
        switch (this.strategyType) {
            case FIRST: {
                return 0;
            }
            case RANDOM: {
                return ThreadLocalRandom.current().nextInt(n3);
            }
            case ROUND_ROBIN: {
                return this.nextIndex.getAndUpdate(n2 -> Math.max(0, n2 + 1)) % n3;
            }
            case THREAD_ID: {
                return (int)(Thread.currentThread().getId() % (long)n3);
            }
        }
        throw new IllegalArgumentException("Unknown strategy type: " + (Object)((Object)this.strategyType));
    }

    public boolean release(Entry entry) {
        if (this.closed) {
            return false;
        }
        boolean bl2 = entry.tryRelease();
        if (bl2 && this.cache != null) {
            this.cache.set(entry);
        }
        return bl2;
    }

    public boolean remove(Entry entry) {
        if (this.closed) {
            return false;
        }
        if (!entry.tryRemove()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Attempt to remove an object from the pool that is still in use: {}", entry);
            }
            return false;
        }
        boolean bl2 = this.entries.remove(entry);
        if (!bl2 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Attempt to remove an object from the pool that does not exist: {}", entry);
        }
        return bl2;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        ArrayList<Entry> arrayList;
        try (Locker.Lock lock = this.locker.lock();){
            this.closed = true;
            arrayList = new ArrayList<Entry>(this.entries);
            this.entries.clear();
        }
        for (Entry entry : arrayList) {
            boolean bl2 = entry.tryRemove();
            if (bl2) {
                if (!(entry.pooled instanceof Closeable)) continue;
                IO.close((Closeable)entry.pooled);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Pooled object still in use: {}", entry);
        }
    }

    public int size() {
        return this.entries.size();
    }

    public Collection<Entry> values() {
        return Collections.unmodifiableCollection(this.entries);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, new DumpableCollection("entries", this.entries));
    }

    public String toString() {
        return String.format("%s@%x[inUse=%d,size=%d,capacity=%d,closed=%b]", this.getClass().getSimpleName(), this.hashCode(), this.getInUseCount(), this.size(), this.getMaxEntries(), this.isClosed());
    }

    class MultiEntry
    extends Entry {
        private final AtomicBiInteger state;

        MultiEntry() {
            this.state = new AtomicBiInteger(Integer.MIN_VALUE, 0);
        }

        @Override
        protected boolean tryEnable(boolean bl2) {
            int n2 = bl2 ? 1 : 0;
            return this.state.compareAndSet(Integer.MIN_VALUE, n2, 0, n2);
        }

        @Override
        boolean tryAcquire() {
            int n2;
            int n3;
            int n4;
            long l2;
            do {
                boolean bl2;
                l2 = this.state.get();
                n3 = AtomicBiInteger.getHi(l2);
                n2 = AtomicBiInteger.getLo(l2);
                boolean bl3 = bl2 = n3 < 0;
                if (bl2) {
                    return false;
                }
                Object t2 = this.getPooled();
                int n5 = Pool.this.getMaxUsageCount(t2);
                int n6 = Pool.this.getMaxMultiplex(t2);
                if (n6 > 0 && n2 >= n6) {
                    return false;
                }
                if (n5 <= 0 || n3 < n5) continue;
                return false;
            } while (!this.state.compareAndSet(l2, n4 = n3 == Integer.MAX_VALUE ? Integer.MAX_VALUE : n3 + 1, n2 + 1));
            return true;
        }

        @Override
        boolean tryRelease() {
            int n2;
            int n3;
            long l2;
            do {
                boolean bl2;
                boolean bl3 = bl2 = (n3 = AtomicBiInteger.getHi(l2 = this.state.get())) < 0;
                if (bl2) {
                    return false;
                }
                n2 = AtomicBiInteger.getLo(l2) - 1;
                if (n2 >= 0) continue;
                throw new IllegalStateException("Cannot release an already released entry");
            } while (!this.state.compareAndSet(l2, n3, n2));
            int n4 = Pool.this.maxUsage;
            boolean bl4 = n4 > 0 && n3 >= n4;
            return !bl4 || n2 != 0;
        }

        @Override
        boolean tryRemove() {
            int n2;
            int n3;
            long l2;
            int n4;
            boolean bl2;
            while (!(bl2 = this.state.compareAndSet(n4 = AtomicBiInteger.getHi(l2 = this.state.get()), -1, n3 = AtomicBiInteger.getLo(l2), n2 = Math.max(n3 - 1, 0)))) {
            }
            return n2 == 0;
        }

        @Override
        public boolean isClosed() {
            return this.state.getHi() < 0;
        }

        @Override
        public boolean isReserved() {
            return this.state.getHi() == Integer.MIN_VALUE;
        }

        @Override
        public boolean isIdle() {
            long l2 = this.state.get();
            return AtomicBiInteger.getHi(l2) >= 0 && AtomicBiInteger.getLo(l2) == 0;
        }

        @Override
        public boolean isInUse() {
            long l2 = this.state.get();
            return AtomicBiInteger.getHi(l2) >= 0 && AtomicBiInteger.getLo(l2) > 0;
        }

        public String toString() {
            long l2 = this.state.get();
            int n2 = AtomicBiInteger.getHi(l2);
            int n3 = AtomicBiInteger.getLo(l2);
            String string = n2 < 0 ? (n2 == Integer.MIN_VALUE ? "PENDING" : "CLOSED") : (n3 == 0 ? "IDLE" : "ACTIVE");
            return String.format("%s@%x{%s,usage=%d,multiplex=%d,pooled=%s}", this.getClass().getSimpleName(), this.hashCode(), string, Math.max(n2, 0), Math.max(n3, 0), this.getPooled());
        }
    }

    private class MonoEntry
    extends Entry {
        private final AtomicInteger state;

        private MonoEntry() {
            this.state = new AtomicInteger(Integer.MIN_VALUE);
        }

        @Override
        protected boolean tryEnable(boolean bl2) {
            return this.state.compareAndSet(Integer.MIN_VALUE, bl2 ? 1 : 0);
        }

        @Override
        boolean tryAcquire() {
            int n2;
            do {
                if ((n2 = this.state.get()) == 0) continue;
                return false;
            } while (!this.state.compareAndSet(n2, 1));
            return true;
        }

        @Override
        boolean tryRelease() {
            int n2;
            do {
                if ((n2 = this.state.get()) < 0) {
                    return false;
                }
                if (n2 != 0) continue;
                throw new IllegalStateException("Cannot release an already released entry");
            } while (!this.state.compareAndSet(n2, 0));
            return true;
        }

        @Override
        boolean tryRemove() {
            this.state.set(-1);
            return true;
        }

        @Override
        public boolean isClosed() {
            return this.state.get() < 0;
        }

        @Override
        public boolean isReserved() {
            return this.state.get() == Integer.MIN_VALUE;
        }

        @Override
        public boolean isIdle() {
            return this.state.get() == 0;
        }

        @Override
        public boolean isInUse() {
            return this.state.get() == 1;
        }

        public String toString() {
            String string;
            switch (this.state.get()) {
                case -2147483648: {
                    string = "PENDING";
                    break;
                }
                case -1: {
                    string = "CLOSED";
                    break;
                }
                case 0: {
                    string = "IDLE";
                    break;
                }
                default: {
                    string = "ACTIVE";
                }
            }
            return String.format("%s@%x{%s,pooled=%s}", this.getClass().getSimpleName(), this.hashCode(), string, this.getPooled());
        }
    }

    public abstract class Entry {
        private T pooled;

        public boolean enable(T t2, boolean bl2) {
            Objects.requireNonNull(t2);
            if (!this.isReserved()) {
                if (this.isClosed()) {
                    return false;
                }
                throw new IllegalStateException("Entry already enabled: " + this);
            }
            this.pooled = t2;
            if (this.tryEnable(bl2)) {
                return true;
            }
            this.pooled = null;
            if (this.isClosed()) {
                return false;
            }
            throw new IllegalStateException("Entry already enabled: " + this);
        }

        public T getPooled() {
            return this.pooled;
        }

        public boolean remove() {
            return Pool.this.remove(this);
        }

        abstract boolean tryEnable(boolean var1);

        abstract boolean tryAcquire();

        abstract boolean tryRelease();

        abstract boolean tryRemove();

        public abstract boolean isClosed();

        public abstract boolean isReserved();

        public abstract boolean isIdle();

        public abstract boolean isInUse();
    }

    public static enum StrategyType {
        FIRST,
        RANDOM,
        THREAD_ID,
        ROUND_ROBIN;

    }
}

