/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.Converter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConverterFactory;
import com.gradle.maven.extension.internal.dep.org.springframework.util.NumberUtils;

final class StringToNumberConverterFactory
implements ConverterFactory<String, Number> {
    StringToNumberConverterFactory() {
    }

    @Override
    public <T extends Number> Converter<String, T> getConverter(Class<T> clazz) {
        return new StringToNumber<T>(clazz);
    }

    private static final class StringToNumber<T extends Number>
    implements Converter<String, T> {
        private final Class<T> targetType;

        public StringToNumber(Class<T> clazz) {
            this.targetType = clazz;
        }

        @Override
        public T convert(String string) {
            if (string.isEmpty()) {
                return null;
            }
            return NumberUtils.parseNumber(string, this.targetType);
        }
    }
}

