/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.InternalParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.Token;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.TokenKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class Tokenizer {
    private static final String[] ALTERNATIVE_OPERATOR_NAMES = new String[]{"DIV", "EQ", "GE", "GT", "LE", "LT", "MOD", "NE", "NOT"};
    private static final byte[] FLAGS = new byte[256];
    private String expressionString;
    private char[] charsToProcess;
    private int pos;
    private int max;
    private List<Token> tokens = new ArrayList<Token>();

    public Tokenizer(String string) {
        this.expressionString = string;
        this.charsToProcess = (string + "\u0000").toCharArray();
        this.max = this.charsToProcess.length;
        this.pos = 0;
    }

    public List<Token> process() {
        block34: while (this.pos < this.max) {
            char c2 = this.charsToProcess[this.pos];
            if (this.isAlphabetic(c2)) {
                this.lexIdentifier();
                continue;
            }
            switch (c2) {
                case '+': {
                    if (this.isTwoCharToken(TokenKind.INC)) {
                        this.pushPairToken(TokenKind.INC);
                        continue block34;
                    }
                    this.pushCharToken(TokenKind.PLUS);
                    continue block34;
                }
                case '_': {
                    this.lexIdentifier();
                    continue block34;
                }
                case '-': {
                    if (this.isTwoCharToken(TokenKind.DEC)) {
                        this.pushPairToken(TokenKind.DEC);
                        continue block34;
                    }
                    this.pushCharToken(TokenKind.MINUS);
                    continue block34;
                }
                case ':': {
                    this.pushCharToken(TokenKind.COLON);
                    continue block34;
                }
                case '.': {
                    this.pushCharToken(TokenKind.DOT);
                    continue block34;
                }
                case ',': {
                    this.pushCharToken(TokenKind.COMMA);
                    continue block34;
                }
                case '*': {
                    this.pushCharToken(TokenKind.STAR);
                    continue block34;
                }
                case '/': {
                    this.pushCharToken(TokenKind.DIV);
                    continue block34;
                }
                case '%': {
                    this.pushCharToken(TokenKind.MOD);
                    continue block34;
                }
                case '(': {
                    this.pushCharToken(TokenKind.LPAREN);
                    continue block34;
                }
                case ')': {
                    this.pushCharToken(TokenKind.RPAREN);
                    continue block34;
                }
                case '[': {
                    this.pushCharToken(TokenKind.LSQUARE);
                    continue block34;
                }
                case '#': {
                    this.pushCharToken(TokenKind.HASH);
                    continue block34;
                }
                case ']': {
                    this.pushCharToken(TokenKind.RSQUARE);
                    continue block34;
                }
                case '{': {
                    this.pushCharToken(TokenKind.LCURLY);
                    continue block34;
                }
                case '}': {
                    this.pushCharToken(TokenKind.RCURLY);
                    continue block34;
                }
                case '@': {
                    this.pushCharToken(TokenKind.BEAN_REF);
                    continue block34;
                }
                case '^': {
                    if (this.isTwoCharToken(TokenKind.SELECT_FIRST)) {
                        this.pushPairToken(TokenKind.SELECT_FIRST);
                        continue block34;
                    }
                    this.pushCharToken(TokenKind.POWER);
                    continue block34;
                }
                case '!': {
                    if (this.isTwoCharToken(TokenKind.NE)) {
                        this.pushPairToken(TokenKind.NE);
                        continue block34;
                    }
                    if (this.isTwoCharToken(TokenKind.PROJECT)) {
                        this.pushPairToken(TokenKind.PROJECT);
                        continue block34;
                    }
                    this.pushCharToken(TokenKind.NOT);
                    continue block34;
                }
                case '=': {
                    if (this.isTwoCharToken(TokenKind.EQ)) {
                        this.pushPairToken(TokenKind.EQ);
                        continue block34;
                    }
                    this.pushCharToken(TokenKind.ASSIGN);
                    continue block34;
                }
                case '&': {
                    if (this.isTwoCharToken(TokenKind.SYMBOLIC_AND)) {
                        this.pushPairToken(TokenKind.SYMBOLIC_AND);
                        continue block34;
                    }
                    this.pushCharToken(TokenKind.FACTORY_BEAN_REF);
                    continue block34;
                }
                case '|': {
                    if (!this.isTwoCharToken(TokenKind.SYMBOLIC_OR)) {
                        this.raiseParseException(this.pos, SpelMessage.MISSING_CHARACTER, "|");
                    }
                    this.pushPairToken(TokenKind.SYMBOLIC_OR);
                    continue block34;
                }
                case '?': {
                    if (this.isTwoCharToken(TokenKind.SELECT)) {
                        this.pushPairToken(TokenKind.SELECT);
                        continue block34;
                    }
                    if (this.isTwoCharToken(TokenKind.ELVIS)) {
                        this.pushPairToken(TokenKind.ELVIS);
                        continue block34;
                    }
                    if (this.isTwoCharToken(TokenKind.SAFE_NAVI)) {
                        this.pushPairToken(TokenKind.SAFE_NAVI);
                        continue block34;
                    }
                    this.pushCharToken(TokenKind.QMARK);
                    continue block34;
                }
                case '$': {
                    if (this.isTwoCharToken(TokenKind.SELECT_LAST)) {
                        this.pushPairToken(TokenKind.SELECT_LAST);
                        continue block34;
                    }
                    this.lexIdentifier();
                    continue block34;
                }
                case '>': {
                    if (this.isTwoCharToken(TokenKind.GE)) {
                        this.pushPairToken(TokenKind.GE);
                        continue block34;
                    }
                    this.pushCharToken(TokenKind.GT);
                    continue block34;
                }
                case '<': {
                    if (this.isTwoCharToken(TokenKind.LE)) {
                        this.pushPairToken(TokenKind.LE);
                        continue block34;
                    }
                    this.pushCharToken(TokenKind.LT);
                    continue block34;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.lexNumericLiteral(c2 == '0');
                    continue block34;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block34;
                }
                case '\'': {
                    this.lexQuotedStringLiteral();
                    continue block34;
                }
                case '\"': {
                    this.lexDoubleQuotedStringLiteral();
                    continue block34;
                }
                case '\u0000': {
                    ++this.pos;
                    continue block34;
                }
                case '\\': {
                    this.raiseParseException(this.pos, SpelMessage.UNEXPECTED_ESCAPE_CHAR, new Object[0]);
                    continue block34;
                }
            }
            throw new IllegalStateException("Cannot handle (" + c2 + ") '" + c2 + "'");
        }
        return this.tokens;
    }

    private void lexQuotedStringLiteral() {
        int n2 = this.pos;
        boolean bl2 = false;
        while (!bl2) {
            ++this.pos;
            char c2 = this.charsToProcess[this.pos];
            if (c2 == '\'') {
                if (this.charsToProcess[this.pos + 1] == '\'') {
                    ++this.pos;
                } else {
                    bl2 = true;
                }
            }
            if (!this.isExhausted()) continue;
            this.raiseParseException(n2, SpelMessage.NON_TERMINATING_QUOTED_STRING, new Object[0]);
        }
        ++this.pos;
        this.tokens.add(new Token(TokenKind.LITERAL_STRING, this.subarray(n2, this.pos), n2, this.pos));
    }

    private void lexDoubleQuotedStringLiteral() {
        int n2 = this.pos;
        boolean bl2 = false;
        while (!bl2) {
            ++this.pos;
            char c2 = this.charsToProcess[this.pos];
            if (c2 == '\"') {
                if (this.charsToProcess[this.pos + 1] == '\"') {
                    ++this.pos;
                } else {
                    bl2 = true;
                }
            }
            if (!this.isExhausted()) continue;
            this.raiseParseException(n2, SpelMessage.NON_TERMINATING_DOUBLE_QUOTED_STRING, new Object[0]);
        }
        ++this.pos;
        this.tokens.add(new Token(TokenKind.LITERAL_STRING, this.subarray(n2, this.pos), n2, this.pos));
    }

    private void lexNumericLiteral(boolean bl2) {
        int n2;
        boolean bl3;
        boolean bl4 = false;
        int n3 = this.pos;
        char c2 = this.charsToProcess[this.pos + 1];
        boolean bl5 = bl3 = c2 == 'x' || c2 == 'X';
        if (bl2 && bl3) {
            ++this.pos;
            do {
                ++this.pos;
            } while (this.isHexadecimalDigit(this.charsToProcess[this.pos]));
            if (this.isChar('L', 'l')) {
                this.pushHexIntToken(this.subarray(n3 + 2, this.pos), true, n3, this.pos);
                ++this.pos;
            } else {
                this.pushHexIntToken(this.subarray(n3 + 2, this.pos), false, n3, this.pos);
            }
            return;
        }
        do {
            ++this.pos;
        } while (this.isDigit(this.charsToProcess[this.pos]));
        c2 = this.charsToProcess[this.pos];
        if (c2 == '.') {
            bl4 = true;
            n2 = this.pos;
            do {
                ++this.pos;
            } while (this.isDigit(this.charsToProcess[this.pos]));
            if (this.pos == n2 + 1) {
                this.pos = n2;
                this.pushIntToken(this.subarray(n3, this.pos), false, n3, this.pos);
                return;
            }
        }
        n2 = this.pos;
        if (this.isChar('L', 'l')) {
            if (bl4) {
                this.raiseParseException(n3, SpelMessage.REAL_CANNOT_BE_LONG, new Object[0]);
            }
            this.pushIntToken(this.subarray(n3, n2), true, n3, n2);
            ++this.pos;
        } else if (this.isExponentChar(this.charsToProcess[this.pos])) {
            bl4 = true;
            ++this.pos;
            char c3 = this.charsToProcess[this.pos];
            if (this.isSign(c3)) {
                ++this.pos;
            }
            do {
                ++this.pos;
            } while (this.isDigit(this.charsToProcess[this.pos]));
            boolean bl6 = false;
            if (this.isFloatSuffix(this.charsToProcess[this.pos])) {
                bl6 = true;
                n2 = ++this.pos;
            } else if (this.isDoubleSuffix(this.charsToProcess[this.pos])) {
                n2 = ++this.pos;
            }
            this.pushRealToken(this.subarray(n3, this.pos), bl6, n3, this.pos);
        } else {
            c2 = this.charsToProcess[this.pos];
            boolean bl7 = false;
            if (this.isFloatSuffix(c2)) {
                bl4 = true;
                bl7 = true;
                n2 = ++this.pos;
            } else if (this.isDoubleSuffix(c2)) {
                bl4 = true;
                n2 = ++this.pos;
            }
            if (bl4) {
                this.pushRealToken(this.subarray(n3, n2), bl7, n3, n2);
            } else {
                this.pushIntToken(this.subarray(n3, n2), false, n3, n2);
            }
        }
    }

    private void lexIdentifier() {
        String string;
        int n2;
        int n3 = this.pos;
        do {
            ++this.pos;
        } while (this.isIdentifier(this.charsToProcess[this.pos]));
        char[] cArray = this.subarray(n3, this.pos);
        if ((this.pos - n3 == 2 || this.pos - n3 == 3) && (n2 = Arrays.binarySearch(ALTERNATIVE_OPERATOR_NAMES, string = new String(cArray).toUpperCase())) >= 0) {
            this.pushOneCharOrTwoCharToken(TokenKind.valueOf(string), n3, cArray);
            return;
        }
        this.tokens.add(new Token(TokenKind.IDENTIFIER, cArray, n3, this.pos));
    }

    private void pushIntToken(char[] cArray, boolean bl2, int n2, int n3) {
        if (bl2) {
            this.tokens.add(new Token(TokenKind.LITERAL_LONG, cArray, n2, n3));
        } else {
            this.tokens.add(new Token(TokenKind.LITERAL_INT, cArray, n2, n3));
        }
    }

    private void pushHexIntToken(char[] cArray, boolean bl2, int n2, int n3) {
        if (cArray.length == 0) {
            if (bl2) {
                this.raiseParseException(n2, SpelMessage.NOT_A_LONG, this.expressionString.substring(n2, n3 + 1));
            } else {
                this.raiseParseException(n2, SpelMessage.NOT_AN_INTEGER, this.expressionString.substring(n2, n3));
            }
        }
        if (bl2) {
            this.tokens.add(new Token(TokenKind.LITERAL_HEXLONG, cArray, n2, n3));
        } else {
            this.tokens.add(new Token(TokenKind.LITERAL_HEXINT, cArray, n2, n3));
        }
    }

    private void pushRealToken(char[] cArray, boolean bl2, int n2, int n3) {
        if (bl2) {
            this.tokens.add(new Token(TokenKind.LITERAL_REAL_FLOAT, cArray, n2, n3));
        } else {
            this.tokens.add(new Token(TokenKind.LITERAL_REAL, cArray, n2, n3));
        }
    }

    private char[] subarray(int n2, int n3) {
        return Arrays.copyOfRange(this.charsToProcess, n2, n3);
    }

    private boolean isTwoCharToken(TokenKind tokenKind) {
        return tokenKind.tokenChars.length == 2 && this.charsToProcess[this.pos] == tokenKind.tokenChars[0] && this.charsToProcess[this.pos + 1] == tokenKind.tokenChars[1];
    }

    private void pushCharToken(TokenKind tokenKind) {
        this.tokens.add(new Token(tokenKind, this.pos, this.pos + 1));
        ++this.pos;
    }

    private void pushPairToken(TokenKind tokenKind) {
        this.tokens.add(new Token(tokenKind, this.pos, this.pos + 2));
        this.pos += 2;
    }

    private void pushOneCharOrTwoCharToken(TokenKind tokenKind, int n2, char[] cArray) {
        this.tokens.add(new Token(tokenKind, cArray, n2, n2 + tokenKind.getLength()));
    }

    private boolean isIdentifier(char c2) {
        return this.isAlphabetic(c2) || this.isDigit(c2) || c2 == '_' || c2 == '$';
    }

    private boolean isChar(char c2, char c3) {
        char c4 = this.charsToProcess[this.pos];
        return c4 == c2 || c4 == c3;
    }

    private boolean isExponentChar(char c2) {
        return c2 == 'e' || c2 == 'E';
    }

    private boolean isFloatSuffix(char c2) {
        return c2 == 'f' || c2 == 'F';
    }

    private boolean isDoubleSuffix(char c2) {
        return c2 == 'd' || c2 == 'D';
    }

    private boolean isSign(char c2) {
        return c2 == '+' || c2 == '-';
    }

    private boolean isDigit(char c2) {
        if (c2 > '\u00ff') {
            return false;
        }
        return (FLAGS[c2] & 1) != 0;
    }

    private boolean isAlphabetic(char c2) {
        if (c2 > '\u00ff') {
            return false;
        }
        return (FLAGS[c2] & 4) != 0;
    }

    private boolean isHexadecimalDigit(char c2) {
        if (c2 > '\u00ff') {
            return false;
        }
        return (FLAGS[c2] & 2) != 0;
    }

    private boolean isExhausted() {
        return this.pos == this.max - 1;
    }

    private void raiseParseException(int n2, SpelMessage spelMessage, Object ... objectArray) {
        throw new InternalParseException(new SpelParseException(this.expressionString, n2, spelMessage, objectArray));
    }

    static {
        int n2 = 48;
        while (n2 <= 57) {
            int n3 = n2++;
            FLAGS[n3] = (byte)(FLAGS[n3] | 3);
        }
        n2 = 65;
        while (n2 <= 70) {
            int n4 = n2++;
            FLAGS[n4] = (byte)(FLAGS[n4] | 2);
        }
        n2 = 97;
        while (n2 <= 102) {
            int n5 = n2++;
            FLAGS[n5] = (byte)(FLAGS[n5] | 2);
        }
        n2 = 65;
        while (n2 <= 90) {
            int n6 = n2++;
            FLAGS[n6] = (byte)(FLAGS[n6] | 4);
        }
        n2 = 97;
        while (n2 <= 122) {
            int n7 = n2++;
            FLAGS[n7] = (byte)(FLAGS[n7] | 4);
        }
    }
}

