/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.ClockImpl;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.JWTDecoder;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms.Algorithm;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.InvalidClaimException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTVerificationException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.TokenExpiredException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.JWTParser;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.NullClaim;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Claim;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Clock;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.DecodedJWT;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Verification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JWTVerifier {
    private final Algorithm algorithm;
    final Map<String, Object> claims;
    private final Clock clock;
    private final JWTParser parser;

    JWTVerifier(Algorithm algorithm, Map<String, Object> map, Clock clock) {
        this.algorithm = algorithm;
        this.claims = Collections.unmodifiableMap(map);
        this.clock = clock;
        this.parser = new JWTParser();
    }

    static Verification init(Algorithm algorithm) throws IllegalArgumentException {
        return new BaseVerification(algorithm);
    }

    public DecodedJWT verify(String string) throws JWTVerificationException {
        JWTDecoder jWTDecoder = new JWTDecoder(this.parser, string);
        return this.verify(jWTDecoder);
    }

    public DecodedJWT verify(DecodedJWT decodedJWT) throws JWTVerificationException {
        this.verifyAlgorithm(decodedJWT, this.algorithm);
        this.algorithm.verify(decodedJWT);
        this.verifyClaims(decodedJWT, this.claims);
        return decodedJWT;
    }

    private void verifyAlgorithm(DecodedJWT decodedJWT, Algorithm algorithm) throws AlgorithmMismatchException {
        if (!algorithm.getName().equals(decodedJWT.getAlgorithm())) {
            throw new AlgorithmMismatchException("The provided Algorithm doesn't match the one defined in the JWT's Header.");
        }
    }

    private void verifyClaims(DecodedJWT decodedJWT, Map<String, Object> map) throws TokenExpiredException, InvalidClaimException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof NonEmptyClaim) {
                this.assertClaimPresent(decodedJWT.getClaim(entry.getKey()), entry.getKey());
                continue;
            }
            this.verifyClaimValues(decodedJWT, entry);
        }
    }

    private void verifyClaimValues(DecodedJWT decodedJWT, Map.Entry<String, Object> entry) {
        switch (entry.getKey()) {
            case "AUDIENCE_EXACT": {
                this.assertValidAudienceClaim(decodedJWT.getAudience(), (List)entry.getValue(), true);
                break;
            }
            case "AUDIENCE_CONTAINS": {
                this.assertValidAudienceClaim(decodedJWT.getAudience(), (List)entry.getValue(), false);
                break;
            }
            case "exp": {
                this.assertValidDateClaim(decodedJWT.getExpiresAt(), (Long)entry.getValue(), true);
                break;
            }
            case "iat": {
                this.assertValidDateClaim(decodedJWT.getIssuedAt(), (Long)entry.getValue(), false);
                break;
            }
            case "nbf": {
                this.assertValidDateClaim(decodedJWT.getNotBefore(), (Long)entry.getValue(), false);
                break;
            }
            case "iss": {
                this.assertValidIssuerClaim(decodedJWT.getIssuer(), (List)entry.getValue());
                break;
            }
            case "jti": {
                this.assertValidStringClaim(entry.getKey(), decodedJWT.getId(), (String)entry.getValue());
                break;
            }
            case "sub": {
                this.assertValidStringClaim(entry.getKey(), decodedJWT.getSubject(), (String)entry.getValue());
                break;
            }
            default: {
                this.assertValidClaim(decodedJWT.getClaim(entry.getKey()), entry.getKey(), entry.getValue());
            }
        }
    }

    private void assertClaimPresent(Claim claim, String string) {
        if (claim instanceof NullClaim) {
            throw new InvalidClaimException(String.format("The Claim '%s' is not present in the JWT.", string));
        }
    }

    private void assertValidClaim(Claim claim, String string, Object object) {
        boolean bl2 = false;
        if (object instanceof String) {
            bl2 = object.equals(claim.asString());
        } else if (object instanceof Integer) {
            bl2 = object.equals(claim.asInt());
        } else if (object instanceof Long) {
            bl2 = object.equals(claim.asLong());
        } else if (object instanceof Boolean) {
            bl2 = object.equals(claim.asBoolean());
        } else if (object instanceof Double) {
            bl2 = object.equals(claim.asDouble());
        } else if (object instanceof Date) {
            bl2 = object.equals(claim.asDate());
        } else if (object instanceof Object[]) {
            List<Object> list;
            Object[] objectArray = claim.as(Object[].class);
            if (object instanceof Long[]) {
                list = new ArrayList(objectArray.length);
                for (Object object2 : objectArray) {
                    if (object2 instanceof Integer) {
                        list.add(((Integer)object2).longValue());
                        continue;
                    }
                    list.add(object2);
                }
            } else {
                list = claim.isNull() ? Collections.emptyList() : Arrays.asList(claim.as(Object[].class));
            }
            List<Object> list2 = Arrays.asList((Object[])object);
            bl2 = list.containsAll(list2);
        }
        if (!bl2) {
            throw new InvalidClaimException(String.format("The Claim '%s' value doesn't match the required one.", string));
        }
    }

    private void assertValidStringClaim(String string, String string2, String string3) {
        if (!string3.equals(string2)) {
            throw new InvalidClaimException(String.format("The Claim '%s' value doesn't match the required one.", string));
        }
    }

    private void assertValidDateClaim(Date date, long l2, boolean bl2) {
        Date date2 = new Date(this.clock.getToday().getTime());
        date2.setTime(date2.getTime() / 1000L * 1000L);
        if (bl2) {
            this.assertDateIsFuture(date, l2, date2);
        } else {
            this.assertDateIsPast(date, l2, date2);
        }
    }

    private void assertDateIsFuture(Date date, long l2, Date date2) {
        date2.setTime(date2.getTime() - l2 * 1000L);
        if (date != null && date2.after(date)) {
            throw new TokenExpiredException(String.format("The Token has expired on %s.", date));
        }
    }

    private void assertDateIsPast(Date date, long l2, Date date2) {
        date2.setTime(date2.getTime() + l2 * 1000L);
        if (date != null && date2.before(date)) {
            throw new InvalidClaimException(String.format("The Token can't be used before %s.", date));
        }
    }

    private void assertValidAudienceClaim(List<String> list, List<String> list2, boolean bl2) {
        if (list == null || bl2 && !list.containsAll(list2) || !bl2 && Collections.disjoint(list, list2)) {
            throw new InvalidClaimException("The Claim 'aud' value doesn't contain the required audience.");
        }
    }

    private void assertValidIssuerClaim(String string, List<String> list) {
        if (string == null || !list.contains(string)) {
            throw new InvalidClaimException("The Claim 'iss' value doesn't match the required issuer.");
        }
    }

    private static class NonEmptyClaim {
        private NonEmptyClaim() {
        }
    }

    public static class BaseVerification
    implements Verification {
        private final Algorithm algorithm;
        private final Map<String, Object> claims;
        private long defaultLeeway;
        private boolean ignoreIssuedAt;

        BaseVerification(Algorithm algorithm) throws IllegalArgumentException {
            if (algorithm == null) {
                throw new IllegalArgumentException("The Algorithm cannot be null.");
            }
            this.algorithm = algorithm;
            this.claims = new HashMap<String, Object>();
            this.defaultLeeway = 0L;
        }

        @Override
        public Verification withSubject(String string) {
            this.requireClaim("sub", string);
            return this;
        }

        @Override
        public Verification acceptLeeway(long l2) throws IllegalArgumentException {
            this.assertPositive(l2);
            this.defaultLeeway = l2;
            return this;
        }

        @Override
        public JWTVerifier build() {
            return this.build(new ClockImpl());
        }

        public JWTVerifier build(Clock clock) {
            this.addLeewayToDateClaims();
            return new JWTVerifier(this.algorithm, this.claims, clock);
        }

        private void assertPositive(long l2) {
            if (l2 < 0L) {
                throw new IllegalArgumentException("Leeway value can't be negative.");
            }
        }

        private void addLeewayToDateClaims() {
            if (!this.claims.containsKey("exp")) {
                this.claims.put("exp", this.defaultLeeway);
            }
            if (!this.claims.containsKey("nbf")) {
                this.claims.put("nbf", this.defaultLeeway);
            }
            if (this.ignoreIssuedAt) {
                this.claims.remove("iat");
                return;
            }
            if (!this.claims.containsKey("iat")) {
                this.claims.put("iat", this.defaultLeeway);
            }
        }

        private void requireClaim(String string, Object object) {
            if (object == null) {
                this.claims.remove(string);
                return;
            }
            this.claims.put(string, object);
        }
    }
}

