/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util;

import java.io.Serializable;

public class ViewMatcher
implements Serializable {
    protected static final ViewMatcher EMPTY = new ViewMatcher();

    public boolean isVisibleForView(Class<?> clazz) {
        return false;
    }

    public static ViewMatcher construct(Class<?>[] classArray) {
        if (classArray == null) {
            return EMPTY;
        }
        switch (classArray.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return new Single(classArray[0]);
            }
        }
        return new Multi(classArray);
    }

    private static final class Multi
    extends ViewMatcher
    implements Serializable {
        private final Class<?>[] _views;

        public Multi(Class<?>[] classArray) {
            this._views = classArray;
        }

        @Override
        public boolean isVisibleForView(Class<?> clazz) {
            for (Class<?> clazz2 : this._views) {
                if (clazz != clazz2 && !clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Single
    extends ViewMatcher {
        private final Class<?> _view;

        public Single(Class<?> clazz) {
            this._view = clazz;
        }

        @Override
        public boolean isVisibleForView(Class<?> clazz) {
            return clazz == this._view || this._view.isAssignableFrom(clazz);
        }
    }
}

