/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ManagedHttpClientConnection;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.routing.HttpRoute;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.CPoolEntry;
import com.gradle.maven.extension.internal.dep.org.apache.http.pool.AbstractConnPool;
import com.gradle.maven.extension.internal.dep.org.apache.http.pool.ConnFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.pool.PoolEntryCallback;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class CPool
extends AbstractConnPool<HttpRoute, ManagedHttpClientConnection, CPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit timeUnit;

    public CPool(ConnFactory<HttpRoute, ManagedHttpClientConnection> connFactory, int n2, int n3, long l2, TimeUnit timeUnit) {
        super(connFactory, n2, n3);
        this.timeToLive = l2;
        this.timeUnit = timeUnit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute httpRoute, ManagedHttpClientConnection managedHttpClientConnection) {
        String string = Long.toString(COUNTER.getAndIncrement());
        return new CPoolEntry(this.log, string, httpRoute, managedHttpClientConnection, this.timeToLive, this.timeUnit);
    }

    @Override
    protected boolean validate(CPoolEntry cPoolEntry) {
        return !((ManagedHttpClientConnection)cPoolEntry.getConnection()).isStale();
    }

    @Override
    protected void enumAvailable(PoolEntryCallback<HttpRoute, ManagedHttpClientConnection> poolEntryCallback) {
        super.enumAvailable(poolEntryCallback);
    }

    @Override
    protected void enumLeased(PoolEntryCallback<HttpRoute, ManagedHttpClientConnection> poolEntryCallback) {
        super.enumLeased(poolEntryCallback);
    }
}

