/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.NullClaim;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Claim;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

class JsonNodeClaim
implements Claim {
    private final ObjectReader objectReader;
    private final JsonNode data;

    private JsonNodeClaim(JsonNode jsonNode, ObjectReader objectReader) {
        this.data = jsonNode;
        this.objectReader = objectReader;
    }

    @Override
    public Boolean asBoolean() {
        return !this.data.isBoolean() ? null : Boolean.valueOf(this.data.asBoolean());
    }

    @Override
    public Integer asInt() {
        return !this.data.isNumber() ? null : Integer.valueOf(this.data.asInt());
    }

    @Override
    public Long asLong() {
        return !this.data.isNumber() ? null : Long.valueOf(this.data.asLong());
    }

    @Override
    public Double asDouble() {
        return !this.data.isNumber() ? null : Double.valueOf(this.data.asDouble());
    }

    @Override
    public String asString() {
        return !this.data.isTextual() ? null : this.data.asText();
    }

    @Override
    public Date asDate() {
        if (!this.data.canConvertToLong()) {
            return null;
        }
        long l2 = this.data.asLong();
        return new Date(l2 * 1000L);
    }

    @Override
    public <T> List<T> asList(Class<T> clazz) throws JWTDecodeException {
        if (!this.data.isArray()) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            try {
                arrayList.add(this.objectReader.treeToValue(this.data.get(i2), clazz));
                continue;
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to " + clazz.getSimpleName(), jsonProcessingException);
            }
        }
        return arrayList;
    }

    @Override
    public <T> T as(Class<T> clazz) throws JWTDecodeException {
        try {
            return this.objectReader.treeAsTokens(this.data).readValueAs(clazz);
        }
        catch (IOException iOException) {
            throw new JWTDecodeException("Couldn't map the Claim value to " + clazz.getSimpleName(), iOException);
        }
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public String toString() {
        return this.data.toString();
    }

    static Claim extractClaim(String string, Map<String, JsonNode> map, ObjectReader objectReader) {
        JsonNode jsonNode = map.get(string);
        return JsonNodeClaim.claimFromNode(jsonNode, objectReader);
    }

    static Claim claimFromNode(JsonNode jsonNode, ObjectReader objectReader) {
        if (jsonNode == null || jsonNode.isNull() || jsonNode.isMissingNode()) {
            return new NullClaim();
        }
        return new JsonNodeClaim(jsonNode, objectReader);
    }
}

