/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.io;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Ascii;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Objects;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.math.IntMath;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.Arrays;

public abstract class BaseEncoding {
    private static final BaseEncoding BASE64 = new Base64Encoding("base64()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", Character.valueOf('='));
    private static final BaseEncoding BASE64_URL = new Base64Encoding("base64Url()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_", Character.valueOf('='));
    private static final BaseEncoding BASE32 = new StandardBaseEncoding("base32()", "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", Character.valueOf('='));
    private static final BaseEncoding BASE32_HEX = new StandardBaseEncoding("base32Hex()", "0123456789ABCDEFGHIJKLMNOPQRSTUV", Character.valueOf('='));
    private static final BaseEncoding BASE16 = new Base16Encoding("base16()", "0123456789ABCDEF");

    BaseEncoding() {
    }

    public String encode(byte[] byArray) {
        return this.encode(byArray, 0, byArray.length);
    }

    public final String encode(byte[] byArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        StringBuilder stringBuilder = new StringBuilder(this.maxEncodedSize(n3));
        try {
            this.encodeTo(stringBuilder, byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }

    abstract int maxEncodedSize(int var1);

    abstract void encodeTo(Appendable var1, byte[] var2, int var3, int var4) throws IOException;

    public abstract BaseEncoding omitPadding();

    public abstract BaseEncoding lowerCase();

    public static BaseEncoding base32() {
        return BASE32;
    }

    static final class Base64Encoding
    extends StandardBaseEncoding {
        Base64Encoding(String string, String string2, Character c2) {
            this(new Alphabet(string, string2.toCharArray()), c2);
        }

        private Base64Encoding(Alphabet alphabet, Character c2) {
            super(alphabet, c2);
            Preconditions.checkArgument(alphabet.chars.length == 64);
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) throws IOException {
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            int n4 = n2;
            for (int i2 = n3; i2 >= 3; i2 -= 3) {
                int n5 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                appendable.append(this.alphabet.encode(n5 >>> 18));
                appendable.append(this.alphabet.encode(n5 >>> 12 & 0x3F));
                appendable.append(this.alphabet.encode(n5 >>> 6 & 0x3F));
                appendable.append(this.alphabet.encode(n5 & 0x3F));
            }
            if (n4 < n2 + n3) {
                this.encodeChunkTo(appendable, byArray, n4, n2 + n3 - n4);
            }
        }

        @Override
        BaseEncoding newInstance(Alphabet alphabet, Character c2) {
            return new Base64Encoding(alphabet, c2);
        }
    }

    static final class Base16Encoding
    extends StandardBaseEncoding {
        final char[] encoding = new char[512];

        Base16Encoding(String string, String string2) {
            this(new Alphabet(string, string2.toCharArray()));
        }

        private Base16Encoding(Alphabet alphabet) {
            super(alphabet, null);
            Preconditions.checkArgument(alphabet.chars.length == 16);
            for (int i2 = 0; i2 < 256; ++i2) {
                this.encoding[i2] = alphabet.encode(i2 >>> 4);
                this.encoding[i2 | 0x100] = alphabet.encode(i2 & 0xF);
            }
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) throws IOException {
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = byArray[n2 + i2] & 0xFF;
                appendable.append(this.encoding[n4]);
                appendable.append(this.encoding[n4 | 0x100]);
            }
        }

        @Override
        BaseEncoding newInstance(Alphabet alphabet, Character c2) {
            return new Base16Encoding(alphabet);
        }
    }

    static class StandardBaseEncoding
    extends BaseEncoding {
        final Alphabet alphabet;
        final Character paddingChar;
        private transient BaseEncoding lowerCase;

        StandardBaseEncoding(String string, String string2, Character c2) {
            this(new Alphabet(string, string2.toCharArray()), c2);
        }

        StandardBaseEncoding(Alphabet alphabet, Character c2) {
            this.alphabet = Preconditions.checkNotNull(alphabet);
            Preconditions.checkArgument(c2 == null || !alphabet.matches(c2.charValue()), "Padding character %s was already in alphabet", c2);
            this.paddingChar = c2;
        }

        @Override
        int maxEncodedSize(int n2) {
            return this.alphabet.charsPerChunk * IntMath.divide(n2, this.alphabet.bytesPerChunk, RoundingMode.CEILING);
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) throws IOException {
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            for (int i2 = 0; i2 < n3; i2 += this.alphabet.bytesPerChunk) {
                this.encodeChunkTo(appendable, byArray, n2 + i2, Math.min(this.alphabet.bytesPerChunk, n3 - i2));
            }
        }

        void encodeChunkTo(Appendable appendable, byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            int n5;
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            Preconditions.checkArgument(n3 <= this.alphabet.bytesPerChunk);
            long l2 = 0L;
            for (n5 = 0; n5 < n3; ++n5) {
                l2 |= (long)(byArray[n2 + n5] & 0xFF);
                l2 <<= 8;
            }
            n5 = (n3 + 1) * 8 - this.alphabet.bitsPerChar;
            for (n4 = 0; n4 < n3 * 8; n4 += this.alphabet.bitsPerChar) {
                int n6 = (int)(l2 >>> n5 - n4) & this.alphabet.mask;
                appendable.append(this.alphabet.encode(n6));
            }
            if (this.paddingChar != null) {
                while (n4 < this.alphabet.bytesPerChunk * 8) {
                    appendable.append(this.paddingChar.charValue());
                    n4 += this.alphabet.bitsPerChar;
                }
            }
        }

        @Override
        public BaseEncoding omitPadding() {
            return this.paddingChar == null ? this : this.newInstance(this.alphabet, null);
        }

        @Override
        public BaseEncoding lowerCase() {
            BaseEncoding baseEncoding = this.lowerCase;
            if (baseEncoding == null) {
                Alphabet alphabet = this.alphabet.lowerCase();
                this.lowerCase = alphabet == this.alphabet ? this : this.newInstance(alphabet, this.paddingChar);
                baseEncoding = this.lowerCase;
            }
            return baseEncoding;
        }

        BaseEncoding newInstance(Alphabet alphabet, Character c2) {
            return new StandardBaseEncoding(alphabet, c2);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("BaseEncoding.");
            stringBuilder.append(this.alphabet.toString());
            if (8 % this.alphabet.bitsPerChar != 0) {
                if (this.paddingChar == null) {
                    stringBuilder.append(".omitPadding()");
                } else {
                    stringBuilder.append(".withPadChar('").append(this.paddingChar).append("')");
                }
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object instanceof StandardBaseEncoding) {
                StandardBaseEncoding standardBaseEncoding = (StandardBaseEncoding)object;
                return this.alphabet.equals(standardBaseEncoding.alphabet) && Objects.equal(this.paddingChar, standardBaseEncoding.paddingChar);
            }
            return false;
        }

        public int hashCode() {
            return this.alphabet.hashCode() ^ Objects.hashCode(this.paddingChar);
        }
    }

    private static final class Alphabet {
        private final String name;
        private final char[] chars;
        final int mask;
        final int bitsPerChar;
        final int charsPerChunk;
        final int bytesPerChunk;
        private final byte[] decodabet;
        private final boolean[] validPadding;

        Alphabet(String string, char[] cArray) {
            int n2;
            this.name = Preconditions.checkNotNull(string);
            this.chars = Preconditions.checkNotNull(cArray);
            try {
                this.bitsPerChar = IntMath.log2(cArray.length, RoundingMode.UNNECESSARY);
            }
            catch (ArithmeticException arithmeticException) {
                int n3 = cArray.length;
                throw new IllegalArgumentException(new StringBuilder(35).append("Illegal alphabet length ").append(n3).toString(), arithmeticException);
            }
            int n4 = Math.min(8, Integer.lowestOneBit(this.bitsPerChar));
            try {
                this.charsPerChunk = 8 / n4;
                this.bytesPerChunk = this.bitsPerChar / n4;
            }
            catch (ArithmeticException arithmeticException) {
                String string2 = String.valueOf(new String(cArray));
                throw new IllegalArgumentException(string2.length() != 0 ? "Illegal alphabet ".concat(string2) : new String("Illegal alphabet "), arithmeticException);
            }
            this.mask = cArray.length - 1;
            byte[] byArray = new byte[128];
            Arrays.fill(byArray, (byte)-1);
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                n2 = cArray[i2];
                Preconditions.checkArgument(n2 < byArray.length, "Non-ASCII character: %s", (char)n2);
                Preconditions.checkArgument(byArray[n2] == -1, "Duplicate character: %s", (char)n2);
                byArray[n2] = (byte)i2;
            }
            this.decodabet = byArray;
            boolean[] blArray = new boolean[this.charsPerChunk];
            for (n2 = 0; n2 < this.bytesPerChunk; ++n2) {
                blArray[IntMath.divide((int)(n2 * 8), (int)this.bitsPerChar, (RoundingMode)RoundingMode.CEILING)] = true;
            }
            this.validPadding = blArray;
        }

        char encode(int n2) {
            return this.chars[n2];
        }

        private boolean hasLowerCase() {
            for (char c2 : this.chars) {
                if (!Ascii.isLowerCase(c2)) continue;
                return true;
            }
            return false;
        }

        private boolean hasUpperCase() {
            for (char c2 : this.chars) {
                if (!Ascii.isUpperCase(c2)) continue;
                return true;
            }
            return false;
        }

        Alphabet lowerCase() {
            if (!this.hasUpperCase()) {
                return this;
            }
            Preconditions.checkState(!this.hasLowerCase(), "Cannot call lowerCase() on a mixed-case alphabet");
            char[] cArray = new char[this.chars.length];
            for (int i2 = 0; i2 < this.chars.length; ++i2) {
                cArray[i2] = Ascii.toLowerCase(this.chars[i2]);
            }
            return new Alphabet(String.valueOf(this.name).concat(".lowerCase()"), cArray);
        }

        public boolean matches(char c2) {
            return c2 < this.decodabet.length && this.decodabet[c2] != -1;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object instanceof Alphabet) {
                Alphabet alphabet = (Alphabet)object;
                return Arrays.equals(this.chars, alphabet.chars);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.chars);
        }
    }
}

