/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel;

import com.gradle.maven.extension.internal.dep.org.springframework.core.SpringProperties;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelCompilerMode;

public class SpelParserConfiguration {
    private static final SpelCompilerMode defaultCompilerMode;
    private final SpelCompilerMode compilerMode;
    private final ClassLoader compilerClassLoader;
    private final boolean autoGrowNullReferences;
    private final boolean autoGrowCollections;
    private final int maximumAutoGrowSize;

    public SpelParserConfiguration() {
        this(null, null, false, false, Integer.MAX_VALUE);
    }

    public SpelParserConfiguration(SpelCompilerMode spelCompilerMode, ClassLoader classLoader, boolean bl2, boolean bl3, int n2) {
        this.compilerMode = spelCompilerMode != null ? spelCompilerMode : defaultCompilerMode;
        this.compilerClassLoader = classLoader;
        this.autoGrowNullReferences = bl2;
        this.autoGrowCollections = bl3;
        this.maximumAutoGrowSize = n2;
    }

    public SpelCompilerMode getCompilerMode() {
        return this.compilerMode;
    }

    public ClassLoader getCompilerClassLoader() {
        return this.compilerClassLoader;
    }

    public boolean isAutoGrowNullReferences() {
        return this.autoGrowNullReferences;
    }

    public boolean isAutoGrowCollections() {
        return this.autoGrowCollections;
    }

    public int getMaximumAutoGrowSize() {
        return this.maximumAutoGrowSize;
    }

    static {
        String string = SpringProperties.getProperty("spring.expression.compiler.mode");
        defaultCompilerMode = string != null ? SpelCompilerMode.valueOf(string.toUpperCase()) : SpelCompilerMode.OFF;
    }
}

