/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import java.util.StringJoiner;

public class CompoundExpression
extends SpelNodeImpl {
    public CompoundExpression(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super(n2, n3, spelNodeImplArray);
        if (spelNodeImplArray.length < 2) {
            throw new IllegalStateException("Do not build compound expressions with less than two entries: " + spelNodeImplArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState expressionState) throws EvaluationException {
        if (this.getChildCount() == 1) {
            return this.children[0].getValueRef(expressionState);
        }
        SpelNodeImpl spelNodeImpl = this.children[0];
        TypedValue typedValue = spelNodeImpl.getValueInternal(expressionState);
        int n2 = this.getChildCount();
        for (int i2 = 1; i2 < n2 - 1; ++i2) {
            try {
                expressionState.pushActiveContextObject(typedValue);
                spelNodeImpl = this.children[i2];
                typedValue = spelNodeImpl.getValueInternal(expressionState);
                continue;
            }
            finally {
                expressionState.popActiveContextObject();
            }
        }
        try {
            expressionState.pushActiveContextObject(typedValue);
            spelNodeImpl = this.children[n2 - 1];
            ValueRef valueRef = spelNodeImpl.getValueRef(expressionState);
            expressionState.popActiveContextObject();
            return valueRef;
        }
        catch (Throwable throwable) {
            try {
                expressionState.popActiveContextObject();
                throw throwable;
            }
            catch (SpelEvaluationException spelEvaluationException) {
                spelEvaluationException.setPosition(spelNodeImpl.getStartPosition());
                throw spelEvaluationException;
            }
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        ValueRef valueRef = this.getValueRef(expressionState);
        TypedValue typedValue = valueRef.getValue();
        this.exitTypeDescriptor = this.children[this.children.length - 1].exitTypeDescriptor;
        return typedValue;
    }

    @Override
    public void setValue(ExpressionState expressionState, Object object) throws EvaluationException {
        this.getValueRef(expressionState).setValue(object);
    }

    @Override
    public String toStringAST() {
        StringJoiner stringJoiner = new StringJoiner(".");
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            stringJoiner.add(this.getChild(i2).toStringAST());
        }
        return stringJoiner.toString();
    }

    @Override
    public boolean isCompilable() {
        for (SpelNodeImpl spelNodeImpl : this.children) {
            if (spelNodeImpl.isCompilable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        for (SpelNodeImpl spelNodeImpl : this.children) {
            spelNodeImpl.generateCode(methodVisitor, codeFlow);
        }
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

