/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gradle.api.internal.changedetection.state.DefaultZipEntryContext;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.api.internal.file.archive.impl.StreamZipInput;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.ConfigurableNormalizer;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContextHasher;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHasher
implements ConfigurableNormalizer,
RegularFileSnapshotContextHasher {
    private static final Set<String> KNOWN_ZIP_EXTENSIONS = ImmutableSet.of("zip", "jar", "war", "rar", "ear", "apk", new String[]{"aar", "klib"});
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipHasher.class);
    private static final HashCode EMPTY_HASH_MARKER = Hashing.signature(ZipHasher.class);
    private final ResourceHasher resourceHasher;
    private final HashingExceptionReporter hashingExceptionReporter;

    public static boolean isZipFile(String string) {
        return KNOWN_ZIP_EXTENSIONS.contains(FilenameUtils.getExtension(string).toLowerCase(Locale.ROOT));
    }

    public ZipHasher(ResourceHasher resourceHasher) {
        this(resourceHasher, (regularFileSnapshot, exception) -> LOGGER.debug("Malformed archive '{}'. Falling back to full content hash instead of entry hashing.", (Object)regularFileSnapshot.getName(), (Object)exception));
    }

    public ZipHasher(ResourceHasher resourceHasher, HashingExceptionReporter hashingExceptionReporter) {
        this.resourceHasher = resourceHasher;
        this.hashingExceptionReporter = hashingExceptionReporter;
    }

    @Override
    public HashCode hash(RegularFileSnapshotContext regularFileSnapshotContext) {
        return this.hashZipContents(regularFileSnapshotContext.getSnapshot());
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        this.resourceHasher.appendConfigurationToHasher(hasher);
    }

    private HashCode hashZipContents(RegularFileSnapshot regularFileSnapshot) {
        try {
            List<FileSystemLocationFingerprint> list = this.fingerprintZipEntries(regularFileSnapshot.getAbsolutePath());
            if (list.isEmpty()) {
                return null;
            }
            Hasher hasher = Hashing.newHasher();
            FingerprintHashingStrategy.SORT.appendToHasher(hasher, list);
            return hasher.hash();
        }
        catch (Exception exception) {
            this.hashingExceptionReporter.report(regularFileSnapshot, exception);
            return regularFileSnapshot.getHash();
        }
    }

    private List<FileSystemLocationFingerprint> fingerprintZipEntries(String string) throws IOException {
        try (ZipInput zipInput = FileZipInput.create(new File(string));){
            ArrayList<FileSystemLocationFingerprint> arrayList = Lists.newArrayList();
            this.fingerprintZipEntries("", string, arrayList, zipInput);
            ArrayList<FileSystemLocationFingerprint> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void fingerprintZipEntries(String string, String string2, List<FileSystemLocationFingerprint> list, ZipInput zipInput) throws IOException {
        list.add(this.newZipMarker(string));
        for (ZipEntry zipEntry : zipInput) {
            if (zipEntry.isDirectory()) continue;
            String string3 = string.isEmpty() ? zipEntry.getName() : string + "/" + zipEntry.getName();
            DefaultZipEntryContext defaultZipEntryContext = new DefaultZipEntryContext(zipEntry, string3, string2);
            if (ZipHasher.isZipFile(zipEntry.getName())) {
                defaultZipEntryContext.getEntry().withInputStream(inputStream -> {
                    this.fingerprintZipEntries(string3, string2, list, new StreamZipInput((InputStream)inputStream));
                    return null;
                });
                continue;
            }
            this.fingerprintZipEntry(defaultZipEntryContext, list);
        }
    }

    private void fingerprintZipEntry(ZipEntryContext zipEntryContext, List<FileSystemLocationFingerprint> list) throws IOException {
        HashCode hashCode = this.resourceHasher.hash(zipEntryContext);
        if (hashCode != null) {
            list.add(new DefaultFileSystemLocationFingerprint(zipEntryContext.getFullName(), FileType.RegularFile, hashCode));
        }
    }

    private DefaultFileSystemLocationFingerprint newZipMarker(String string) {
        return new DefaultFileSystemLocationFingerprint(string, FileType.RegularFile, EMPTY_HASH_MARKER);
    }

    public static interface HashingExceptionReporter {
        public void report(RegularFileSnapshot var1, Exception var2);
    }
}

