/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpClientConnection;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpHost;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.ConnectionConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.Registry;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.RegistryBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.SocketConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ConnectionPoolTimeoutException;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ConnectionRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.DnsResolver;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.HttpClientConnectionManager;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.HttpClientConnectionOperator;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.HttpConnectionFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ManagedHttpClientConnection;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.SchemePortResolver;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.routing.HttpRoute;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.socket.ConnectionSocketFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.CPool;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.CPoolEntry;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.CPoolProxy;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.pool.ConnFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.pool.PoolEntry;
import com.gradle.maven.extension.internal.dep.org.apache.http.pool.PoolEntryCallback;
import com.gradle.maven.extension.internal.dep.org.apache.http.pool.PoolStats;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Asserts;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class PoolingHttpClientConnectionManager
implements Closeable,
HttpClientConnectionManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConfigData configData = new ConfigData();
    private final CPool pool;
    private final HttpClientConnectionOperator connectionOperator;
    private final AtomicBoolean isShutDown;

    private static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)SSLConnectionSocketFactory.getSocketFactory())).build();
    }

    public PoolingHttpClientConnectionManager() {
        this(PoolingHttpClientConnectionManager.getDefaultRegistry());
    }

    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry) {
        this(registry, null, null);
    }

    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> httpConnectionFactory, DnsResolver dnsResolver) {
        this(registry, httpConnectionFactory, null, dnsResolver, -1L, TimeUnit.MILLISECONDS);
    }

    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> httpConnectionFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long l2, TimeUnit timeUnit) {
        this(new DefaultHttpClientConnectionOperator(registry, schemePortResolver, dnsResolver), httpConnectionFactory, l2, timeUnit);
    }

    public PoolingHttpClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> httpConnectionFactory, long l2, TimeUnit timeUnit) {
        this.pool = new CPool(new InternalConnectionFactory(this.configData, httpConnectionFactory), 2, 20, l2, timeUnit);
        this.pool.setValidateAfterInactivity(2000);
        this.connectionOperator = Args.notNull(httpClientConnectionOperator, "HttpClientConnectionOperator");
        this.isShutDown = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private String format(HttpRoute httpRoute, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[route: ").append(httpRoute).append("]");
        if (object != null) {
            stringBuilder.append("[state: ").append(object).append("]");
        }
        return stringBuilder.toString();
    }

    private String formatStats(HttpRoute httpRoute) {
        StringBuilder stringBuilder = new StringBuilder();
        PoolStats poolStats = this.pool.getTotalStats();
        PoolStats poolStats2 = this.pool.getStats(httpRoute);
        stringBuilder.append("[total available: ").append(poolStats.getAvailable()).append("; ");
        stringBuilder.append("route allocated: ").append(poolStats2.getLeased() + poolStats2.getAvailable());
        stringBuilder.append(" of ").append(poolStats2.getMax()).append("; ");
        stringBuilder.append("total allocated: ").append(poolStats.getLeased() + poolStats.getAvailable());
        stringBuilder.append(" of ").append(poolStats.getMax()).append("]");
        return stringBuilder.toString();
    }

    private String format(CPoolEntry cPoolEntry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[id: ").append(cPoolEntry.getId()).append("]");
        stringBuilder.append("[route: ").append(cPoolEntry.getRoute()).append("]");
        Object object = cPoolEntry.getState();
        if (object != null) {
            stringBuilder.append("[state: ").append(object).append("]");
        }
        return stringBuilder.toString();
    }

    private SocketConfig resolveSocketConfig(HttpHost httpHost) {
        SocketConfig socketConfig = this.configData.getSocketConfig(httpHost);
        if (socketConfig == null) {
            socketConfig = this.configData.getDefaultSocketConfig();
        }
        if (socketConfig == null) {
            socketConfig = SocketConfig.DEFAULT;
        }
        return socketConfig;
    }

    @Override
    public ConnectionRequest requestConnection(final HttpRoute httpRoute, Object object) {
        Args.notNull(httpRoute, "HTTP route");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connection request: " + this.format(httpRoute, object) + this.formatStats(httpRoute));
        }
        Asserts.check(!this.isShutDown.get(), "Connection pool shut down");
        final Future future = this.pool.lease(httpRoute, object, null);
        return new ConnectionRequest(){

            @Override
            public boolean cancel() {
                return future.cancel(true);
            }

            @Override
            public HttpClientConnection get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, ConnectionPoolTimeoutException {
                HttpClientConnection httpClientConnection = PoolingHttpClientConnectionManager.this.leaseConnection(future, l2, timeUnit);
                if (httpClientConnection.isOpen()) {
                    HttpHost httpHost = httpRoute.getProxyHost() != null ? httpRoute.getProxyHost() : httpRoute.getTargetHost();
                    SocketConfig socketConfig = PoolingHttpClientConnectionManager.this.resolveSocketConfig(httpHost);
                    httpClientConnection.setSocketTimeout(socketConfig.getSoTimeout());
                }
                return httpClientConnection;
            }
        };
    }

    protected HttpClientConnection leaseConnection(Future<CPoolEntry> future, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, ConnectionPoolTimeoutException {
        try {
            CPoolEntry cPoolEntry = future.get(l2, timeUnit);
            if (cPoolEntry == null || future.isCancelled()) {
                throw new ExecutionException(new CancellationException("Operation cancelled"));
            }
            Asserts.check(cPoolEntry.getConnection() != null, "Pool entry with no connection");
            if (this.log.isDebugEnabled()) {
                this.log.debug("Connection leased: " + this.format(cPoolEntry) + this.formatStats((HttpRoute)cPoolEntry.getRoute()));
            }
            return CPoolProxy.newProxy(cPoolEntry);
        }
        catch (TimeoutException timeoutException) {
            throw new ConnectionPoolTimeoutException("Timeout waiting for connection from pool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(HttpClientConnection httpClientConnection, Object object, long l2, TimeUnit timeUnit) {
        Args.notNull(httpClientConnection, "Managed connection");
        HttpClientConnection httpClientConnection2 = httpClientConnection;
        synchronized (httpClientConnection2) {
            ManagedHttpClientConnection managedHttpClientConnection;
            CPoolEntry cPoolEntry;
            block9: {
                cPoolEntry = CPoolProxy.detach(httpClientConnection);
                if (cPoolEntry == null) {
                    return;
                }
                managedHttpClientConnection = (ManagedHttpClientConnection)cPoolEntry.getConnection();
                try {
                    if (!managedHttpClientConnection.isOpen()) break block9;
                    TimeUnit timeUnit2 = timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS;
                    cPoolEntry.setState(object);
                    cPoolEntry.updateExpiry(l2, timeUnit2);
                    if (this.log.isDebugEnabled()) {
                        String string = l2 > 0L ? "for " + (double)timeUnit2.toMillis(l2) / 1000.0 + " seconds" : "indefinitely";
                        this.log.debug("Connection " + this.format(cPoolEntry) + " can be kept alive " + string);
                    }
                    managedHttpClientConnection.setSocketTimeout(0);
                }
                catch (Throwable throwable) {
                    this.pool.release(cPoolEntry, managedHttpClientConnection.isOpen() && cPoolEntry.isRouteComplete());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Connection released: " + this.format(cPoolEntry) + this.formatStats((HttpRoute)cPoolEntry.getRoute()));
                    }
                    throw throwable;
                }
            }
            this.pool.release(cPoolEntry, managedHttpClientConnection.isOpen() && cPoolEntry.isRouteComplete());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Connection released: " + this.format(cPoolEntry) + this.formatStats((HttpRoute)cPoolEntry.getRoute()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(HttpClientConnection httpClientConnection, HttpRoute httpRoute, int n2, HttpContext httpContext) throws IOException {
        ManagedHttpClientConnection managedHttpClientConnection;
        Args.notNull(httpClientConnection, "Managed Connection");
        Args.notNull(httpRoute, "HTTP route");
        Object object = httpClientConnection;
        synchronized (object) {
            CPoolEntry cPoolEntry = CPoolProxy.getPoolEntry(httpClientConnection);
            managedHttpClientConnection = (ManagedHttpClientConnection)cPoolEntry.getConnection();
        }
        object = httpRoute.getProxyHost() != null ? httpRoute.getProxyHost() : httpRoute.getTargetHost();
        this.connectionOperator.connect(managedHttpClientConnection, (HttpHost)object, httpRoute.getLocalSocketAddress(), n2, this.resolveSocketConfig((HttpHost)object), httpContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgrade(HttpClientConnection httpClientConnection, HttpRoute httpRoute, HttpContext httpContext) throws IOException {
        ManagedHttpClientConnection managedHttpClientConnection;
        Args.notNull(httpClientConnection, "Managed Connection");
        Args.notNull(httpRoute, "HTTP route");
        HttpClientConnection httpClientConnection2 = httpClientConnection;
        synchronized (httpClientConnection2) {
            CPoolEntry cPoolEntry = CPoolProxy.getPoolEntry(httpClientConnection);
            managedHttpClientConnection = (ManagedHttpClientConnection)cPoolEntry.getConnection();
        }
        this.connectionOperator.upgrade(managedHttpClientConnection, httpRoute.getTargetHost(), httpContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void routeComplete(HttpClientConnection httpClientConnection, HttpRoute httpRoute, HttpContext httpContext) throws IOException {
        Args.notNull(httpClientConnection, "Managed Connection");
        Args.notNull(httpRoute, "HTTP route");
        HttpClientConnection httpClientConnection2 = httpClientConnection;
        synchronized (httpClientConnection2) {
            CPoolEntry cPoolEntry = CPoolProxy.getPoolEntry(httpClientConnection);
            cPoolEntry.markRouteComplete();
        }
    }

    @Override
    public void shutdown() {
        if (this.isShutDown.compareAndSet(false, true)) {
            this.log.debug("Connection manager is shutting down");
            try {
                this.pool.enumLeased(new PoolEntryCallback<HttpRoute, ManagedHttpClientConnection>(){

                    @Override
                    public void process(PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry) {
                        block3: {
                            ManagedHttpClientConnection managedHttpClientConnection = poolEntry.getConnection();
                            if (managedHttpClientConnection != null) {
                                try {
                                    managedHttpClientConnection.shutdown();
                                }
                                catch (IOException iOException) {
                                    if (!PoolingHttpClientConnectionManager.this.log.isDebugEnabled()) break block3;
                                    PoolingHttpClientConnectionManager.this.log.debug("I/O exception shutting down connection", iOException);
                                }
                            }
                        }
                    }
                });
                this.pool.shutdown();
            }
            catch (IOException iOException) {
                this.log.debug("I/O exception shutting down connection manager", iOException);
            }
            this.log.debug("Connection manager shut down");
        }
    }

    @Override
    public void closeIdleConnections(long l2, TimeUnit timeUnit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Closing connections idle longer than " + l2 + " " + (Object)((Object)timeUnit));
        }
        this.pool.closeIdle(l2, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        this.log.debug("Closing expired connections");
        this.pool.closeExpired();
    }

    public void setMaxTotal(int n2) {
        this.pool.setMaxTotal(n2);
    }

    public void setDefaultMaxPerRoute(int n2) {
        this.pool.setDefaultMaxPerRoute(n2);
    }

    public void setDefaultSocketConfig(SocketConfig socketConfig) {
        this.configData.setDefaultSocketConfig(socketConfig);
    }

    public void setDefaultConnectionConfig(ConnectionConfig connectionConfig) {
        this.configData.setDefaultConnectionConfig(connectionConfig);
    }

    static class InternalConnectionFactory
    implements ConnFactory<HttpRoute, ManagedHttpClientConnection> {
        private final ConfigData configData;
        private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;

        InternalConnectionFactory(ConfigData configData, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> managedHttpClientConnectionFactory) {
            this.configData = configData != null ? configData : new ConfigData();
            this.connFactory = managedHttpClientConnectionFactory != null ? managedHttpClientConnectionFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        }

        @Override
        public ManagedHttpClientConnection create(HttpRoute httpRoute) throws IOException {
            ConnectionConfig connectionConfig = null;
            if (httpRoute.getProxyHost() != null) {
                connectionConfig = this.configData.getConnectionConfig(httpRoute.getProxyHost());
            }
            if (connectionConfig == null) {
                connectionConfig = this.configData.getConnectionConfig(httpRoute.getTargetHost());
            }
            if (connectionConfig == null) {
                connectionConfig = this.configData.getDefaultConnectionConfig();
            }
            if (connectionConfig == null) {
                connectionConfig = ConnectionConfig.DEFAULT;
            }
            return this.connFactory.create(httpRoute, connectionConfig);
        }
    }

    static class ConfigData {
        private final Map<HttpHost, SocketConfig> socketConfigMap = new ConcurrentHashMap<HttpHost, SocketConfig>();
        private final Map<HttpHost, ConnectionConfig> connectionConfigMap = new ConcurrentHashMap<HttpHost, ConnectionConfig>();
        private volatile SocketConfig defaultSocketConfig;
        private volatile ConnectionConfig defaultConnectionConfig;

        ConfigData() {
        }

        public SocketConfig getDefaultSocketConfig() {
            return this.defaultSocketConfig;
        }

        public void setDefaultSocketConfig(SocketConfig socketConfig) {
            this.defaultSocketConfig = socketConfig;
        }

        public ConnectionConfig getDefaultConnectionConfig() {
            return this.defaultConnectionConfig;
        }

        public void setDefaultConnectionConfig(ConnectionConfig connectionConfig) {
            this.defaultConnectionConfig = connectionConfig;
        }

        public SocketConfig getSocketConfig(HttpHost httpHost) {
            return this.socketConfigMap.get(httpHost);
        }

        public ConnectionConfig getConnectionConfig(HttpHost httpHost) {
            return this.connectionConfigMap.get(httpHost);
        }
    }
}

