/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;

public abstract class ResolvePathsRequest<T> {
    private Path jdkHome;
    private Path mainModuleDescriptor;
    private Collection<T> pathElements;
    private Collection<String> additionalModules;
    private boolean includeAllProviders;
    private JavaModuleDescriptor resolvedMainModuleDescriptor;
    private boolean includeStatic;

    private ResolvePathsRequest() {
    }

    public static ResolvePathsRequest<Path> ofPaths(Collection<Path> collection) {
        ResolvePathsRequest<Path> resolvePathsRequest = new ResolvePathsRequest<Path>(){

            @Override
            protected Path toPath(Path path) {
                return path;
            }
        };
        resolvePathsRequest.pathElements = collection;
        return resolvePathsRequest;
    }

    protected abstract Path toPath(T var1);

    final ResolvePathsResult<T> createResult() {
        return new ResolvePathsResult();
    }

    public Path getMainModuleDescriptor() {
        return this.mainModuleDescriptor;
    }

    public JavaModuleDescriptor getModuleDescriptor() {
        return this.resolvedMainModuleDescriptor;
    }

    public ResolvePathsRequest<T> setModuleDescriptor(JavaModuleDescriptor javaModuleDescriptor) {
        this.resolvedMainModuleDescriptor = javaModuleDescriptor;
        return this;
    }

    public Collection<T> getPathElements() {
        return this.pathElements;
    }

    public ResolvePathsRequest<T> setJdkHome(T t2) {
        this.jdkHome = this.toPath(t2);
        return this;
    }

    public Path getJdkHome() {
        return this.jdkHome;
    }

    public Collection<String> getAdditionalModules() {
        if (this.additionalModules == null) {
            this.additionalModules = Collections.emptyList();
        }
        return this.additionalModules;
    }

    public boolean isIncludeAllProviders() {
        return this.includeAllProviders;
    }

    public boolean isIncludeStatic() {
        return this.includeStatic;
    }
}

