/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ConnectionPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Attachable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.IO;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Pool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Promise;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Sweeper;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractConnectionPool
extends ContainerLifeCycle
implements ConnectionPool,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(AbstractConnectionPool.class);
    private final AtomicInteger pending = new AtomicInteger();
    private final HttpDestination destination;
    private final Callback requester;
    private final Pool<Connection> pool;
    private boolean maximizeConnections;
    private volatile long maxDurationNanos = 0L;

    protected AbstractConnectionPool(HttpDestination httpDestination, Pool.StrategyType strategyType, int n2, boolean bl2, Callback callback) {
        this(httpDestination, new Pool<Connection>(strategyType, n2, bl2), callback);
    }

    protected AbstractConnectionPool(HttpDestination httpDestination, Pool<Connection> pool, Callback callback) {
        this.destination = httpDestination;
        this.requester = callback;
        this.pool = pool;
        pool.setMaxMultiplex(1);
        this.addBean(pool);
    }

    @Override
    protected void doStop() throws Exception {
        this.pool.close();
    }

    protected int getMaxMultiplex() {
        return this.pool.getMaxMultiplex();
    }

    public int getActiveConnectionCount() {
        return this.pool.getInUseCount();
    }

    public int getIdleConnectionCount() {
        return this.pool.getIdleCount();
    }

    public int getMaxConnectionCount() {
        return this.pool.getMaxEntries();
    }

    public int getConnectionCount() {
        return this.pool.size();
    }

    public int getPendingConnectionCount() {
        return this.pending.get();
    }

    @Override
    public boolean isEmpty() {
        return this.pool.size() == 0;
    }

    public boolean isClosed() {
        return this.pool.isClosed();
    }

    public boolean isMaximizeConnections() {
        return this.maximizeConnections;
    }

    @Override
    public Connection acquire() {
        return this.acquire(true);
    }

    protected Connection acquire(boolean bl2) {
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquiring create={} on {}", bl2, this);
        }
        if ((connection = this.activate()) == null) {
            this.tryCreate(bl2);
            connection = this.activate();
        }
        return connection;
    }

    protected void tryCreate(boolean bl2) {
        int n2;
        int n3 = this.getConnectionCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try creating connection {}/{} with {} pending", n3, this.getMaxConnectionCount(), this.getPendingConnectionCount());
        }
        int n4 = this.getMaxMultiplex();
        do {
            boolean bl3;
            n2 = this.pending.get();
            int n5 = n2 * n4;
            int n6 = this.destination.getQueuedRequestCount() + (bl2 ? 1 : 0);
            boolean bl4 = bl3 = this.isMaximizeConnections() || n5 < n6;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try creating({}) connection, pending/demand/supply: {}/{}/{}, result={}", bl2, n2, n6, n5, bl3);
            }
            if (bl3) continue;
            return;
        } while (!this.pending.compareAndSet(n2, n2 + 1));
        Pool.Entry entry = this.pool.reserve();
        if (entry == null) {
            this.pending.decrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not creating connection as pool is full, pending: {}", this.pending);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connection {}/{} at {}", n3, this.getMaxConnectionCount(), entry);
        }
        FutureConnection futureConnection = new FutureConnection(entry);
        this.destination.newConnection(futureConnection);
    }

    protected void proceed() {
        this.requester.succeeded();
    }

    protected Connection activate() {
        Pool.Entry entry;
        while ((entry = this.pool.acquire()) != null) {
            EntryHolder entryHolder;
            Connection connection = (Connection)entry.getPooled();
            long l2 = this.maxDurationNanos;
            if (l2 > 0L && (entryHolder = (EntryHolder)((Attachable)((Object)connection)).getAttachment()).isExpired(l2)) {
                boolean bl2 = this.remove(connection);
                if (bl2) {
                    IO.close(connection);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Connection removed{} due to expiration {} {}", bl2 ? " and closed" : "", entry, this.pool);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activated {} {}", entry, this.pool);
            }
            this.acquired(connection);
            return connection;
        }
        return null;
    }

    @Override
    public boolean isActive(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        EntryHolder entryHolder = (EntryHolder)attachable.getAttachment();
        if (entryHolder == null) {
            return false;
        }
        return !entryHolder.entry.isIdle();
    }

    @Override
    public boolean release(Connection connection) {
        if (!this.deactivate(connection)) {
            return false;
        }
        this.released(connection);
        return this.idle(connection, this.isClosed());
    }

    protected boolean deactivate(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        EntryHolder entryHolder = (EntryHolder)attachable.getAttachment();
        if (entryHolder == null) {
            return true;
        }
        long l2 = this.maxDurationNanos;
        if (l2 > 0L && entryHolder.isExpired(l2)) {
            return !this.remove(connection);
        }
        boolean bl2 = this.pool.release(entryHolder.entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released ({}) {} {}", bl2, entryHolder.entry, this.pool);
        }
        if (bl2) {
            return true;
        }
        return !this.remove(connection);
    }

    @Override
    public boolean remove(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)((Object)connection);
        EntryHolder entryHolder = (EntryHolder)attachable.getAttachment();
        if (entryHolder == null) {
            return false;
        }
        boolean bl2 = this.pool.remove(entryHolder.entry);
        if (bl2) {
            attachable.setAttachment(null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed ({}) {} {}", bl2, entryHolder.entry, this.pool);
        }
        if (bl2) {
            this.released(connection);
            this.removed(connection);
        }
        return bl2;
    }

    protected void onCreated(Connection connection) {
    }

    protected boolean idle(Connection connection, boolean bl2) {
        return !bl2;
    }

    protected void acquired(Connection connection) {
    }

    protected void released(Connection connection) {
    }

    protected void removed(Connection connection) {
    }

    @Override
    public void close() {
        this.pool.close();
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, new Object[0]);
    }

    @Override
    public boolean sweep() {
        this.pool.values().stream().map(Pool.Entry::getPooled).filter(connection -> connection instanceof Sweeper.Sweepable).forEach(connection -> {
            if (((Sweeper.Sweepable)((Object)connection)).sweep()) {
                boolean bl2 = this.remove((Connection)connection);
                LOG.warn("Connection swept: {}{}{} from active connections{}{}", connection, System.lineSeparator(), bl2 ? "Removed" : "Not removed", System.lineSeparator(), this.dump());
            }
        });
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s@%x[c=%d/%d/%d,a=%d,i=%d,q=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getPendingConnectionCount(), this.getConnectionCount(), this.getMaxConnectionCount(), this.getActiveConnectionCount(), this.getIdleConnectionCount(), this.destination.getQueuedRequestCount());
    }

    private static class EntryHolder {
        private final Pool.Entry entry;
        private final long creationTimestamp = System.nanoTime();

        private EntryHolder(Pool.Entry entry) {
            this.entry = Objects.requireNonNull(entry);
        }

        private boolean isExpired(long l2) {
            return System.nanoTime() - this.creationTimestamp >= l2;
        }
    }

    private class FutureConnection
    extends Promise.Completable<Connection> {
        private final Pool.Entry reserved;

        public FutureConnection(Pool.Entry entry) {
            this.reserved = entry;
        }

        @Override
        public void succeeded(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection creation succeeded {}: {}", this.reserved, connection);
            }
            if (connection instanceof Attachable) {
                ((Attachable)((Object)connection)).setAttachment(new EntryHolder(this.reserved));
                AbstractConnectionPool.this.onCreated(connection);
                AbstractConnectionPool.this.pending.decrementAndGet();
                this.reserved.enable(connection, false);
                AbstractConnectionPool.this.idle(connection, false);
                this.complete(null);
                AbstractConnectionPool.this.proceed();
            } else {
                this.failed(new IllegalArgumentException("Invalid connection object: " + connection));
            }
        }

        @Override
        public void failed(Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection creation failed {}", this.reserved, throwable);
            }
            AbstractConnectionPool.this.pending.decrementAndGet();
            this.reserved.remove();
            this.completeExceptionally(throwable);
            AbstractConnectionPool.this.requester.failed(throwable);
        }
    }
}

