/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.BooleanTypedValue;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class OperatorMatches
extends Operator {
    private final ConcurrentMap<String, Pattern> patternCache;

    public OperatorMatches(ConcurrentMap<String, Pattern> concurrentMap, int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super("matches", n2, n3, spelNodeImplArray);
        this.patternCache = concurrentMap;
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        SpelNodeImpl spelNodeImpl = this.getLeftOperand();
        SpelNodeImpl spelNodeImpl2 = this.getRightOperand();
        String string = spelNodeImpl.getValue(expressionState, String.class);
        if (string == null) {
            throw new SpelEvaluationException(spelNodeImpl.getStartPosition(), SpelMessage.INVALID_FIRST_OPERAND_FOR_MATCHES_OPERATOR, new Object[]{null});
        }
        Object object = spelNodeImpl2.getValue(expressionState);
        if (!(object instanceof String)) {
            throw new SpelEvaluationException(spelNodeImpl2.getStartPosition(), SpelMessage.INVALID_SECOND_OPERAND_FOR_MATCHES_OPERATOR, object);
        }
        String string2 = (String)object;
        try {
            Pattern pattern = (Pattern)this.patternCache.get(string2);
            if (pattern == null) {
                this.checkRegexLength(string2);
                pattern = Pattern.compile(string2);
                this.patternCache.putIfAbsent(string2, pattern);
            }
            Matcher matcher = pattern.matcher(new MatcherInput(string, new AccessCount()));
            return BooleanTypedValue.forValue(matcher.matches());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new SpelEvaluationException(spelNodeImpl2.getStartPosition(), (Throwable)patternSyntaxException, SpelMessage.INVALID_PATTERN, object);
        }
        catch (IllegalStateException illegalStateException) {
            throw new SpelEvaluationException(spelNodeImpl2.getStartPosition(), (Throwable)illegalStateException, SpelMessage.FLAWED_PATTERN, object);
        }
    }

    private void checkRegexLength(String string) {
        if (string.length() > 256) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MAX_REGEX_LENGTH_EXCEEDED, 256);
        }
    }

    private static class MatcherInput
    implements CharSequence {
        private final CharSequence value;
        private final AccessCount access;

        public MatcherInput(CharSequence charSequence, AccessCount accessCount) {
            this.value = charSequence;
            this.access = accessCount;
        }

        @Override
        public char charAt(int n2) {
            this.access.check();
            return this.value.charAt(n2);
        }

        @Override
        public CharSequence subSequence(int n2, int n3) {
            return new MatcherInput(this.value.subSequence(n2, n3), this.access);
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }

    private static class AccessCount {
        private int count;

        private AccessCount() {
        }

        public void check() throws IllegalStateException {
            if (this.count++ > 1000000) {
                throw new IllegalStateException("Pattern access threshold exceeded");
            }
        }
    }
}

