/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.CyclicTimeout;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.Destroyable;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class CyclicTimeouts<T extends Expirable>
implements Destroyable {
    private static final Logger LOG = Log.getLogger(CyclicTimeouts.class);
    private final AtomicLong earliestTimeout = new AtomicLong(Long.MAX_VALUE);
    private final CyclicTimeout cyclicTimeout;

    public CyclicTimeouts(Scheduler scheduler) {
        this.cyclicTimeout = new Timeouts(scheduler);
    }

    protected abstract Iterator<T> iterator();

    protected abstract boolean onExpired(T var1);

    private void onTimeoutExpired() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timeouts check for {}", this);
        }
        long l2 = System.nanoTime();
        long l3 = Long.MAX_VALUE;
        this.earliestTimeout.set(l3);
        Iterator<T> iterator = this.iterator();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Expirable expirable = (Expirable)iterator.next();
            long l4 = expirable.getExpireNanoTime();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Entity {} expires in {} ms for {}", expirable, TimeUnit.NANOSECONDS.toMillis(l4 - l2), this);
            }
            if (l4 == -1L) continue;
            if (l4 <= l2) {
                boolean bl2 = this.onExpired(expirable);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Entity {} expired, remove={} for {}", expirable, bl2, this);
                }
                if (!bl2) continue;
                iterator.remove();
                continue;
            }
            l3 = Math.min(l3, l4);
        }
        if (l3 < Long.MAX_VALUE) {
            this.schedule(l3);
        }
    }

    public void schedule(T t2) {
        long l2 = t2.getExpireNanoTime();
        if (l2 < Long.MAX_VALUE) {
            this.schedule(l2);
        }
    }

    private void schedule(long l2) {
        long l4 = this.earliestTimeout.getAndUpdate(l3 -> Math.min(l3, l2));
        long l5 = l2;
        while (l5 < l4) {
            long l6 = Math.max(0L, l5 - System.nanoTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling timeout in {} ms for {}", TimeUnit.NANOSECONDS.toMillis(l6), this);
            }
            this.schedule(this.cyclicTimeout, l6, TimeUnit.NANOSECONDS);
            l4 = l5;
            l5 = this.earliestTimeout.get();
        }
    }

    @Override
    public void destroy() {
        this.cyclicTimeout.destroy();
    }

    boolean schedule(CyclicTimeout cyclicTimeout, long l2, TimeUnit timeUnit) {
        return cyclicTimeout.schedule(l2, timeUnit);
    }

    private class Timeouts
    extends CyclicTimeout {
        private Timeouts(Scheduler scheduler) {
            super(scheduler);
        }

        @Override
        public void onTimeoutExpired() {
            CyclicTimeouts.this.onTimeoutExpired();
        }
    }

    public static interface Expirable {
        public long getExpireNanoTime();
    }
}

