/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.KryoException;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.Serializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.io.Output;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util.Util;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

public class ClosureSerializer
extends Serializer {
    private static Method readResolve;

    public void write(Kryo kryo, Output output, Object object) {
        SerializedLambda serializedLambda = this.toSerializedLambda(object);
        int n2 = serializedLambda.getCapturedArgCount();
        output.writeVarInt(n2, true);
        for (int i2 = 0; i2 < n2; ++i2) {
            kryo.writeClassAndObject(output, serializedLambda.getCapturedArg(i2));
        }
        try {
            kryo.writeClass(output, Class.forName(serializedLambda.getCapturingClass().replace('/', '.')));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new KryoException("Error writing closure.", classNotFoundException);
        }
        output.writeString(serializedLambda.getFunctionalInterfaceClass());
        output.writeString(serializedLambda.getFunctionalInterfaceMethodName());
        output.writeString(serializedLambda.getFunctionalInterfaceMethodSignature());
        output.writeVarInt(serializedLambda.getImplMethodKind(), true);
        output.writeString(serializedLambda.getImplClass());
        output.writeString(serializedLambda.getImplMethodName());
        output.writeString(serializedLambda.getImplMethodSignature());
        output.writeString(serializedLambda.getInstantiatedMethodType());
    }

    public Object read(Kryo kryo, Input input, Class clazz) {
        int n2 = input.readVarInt(true);
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = kryo.readClassAndObject(input);
        }
        Class clazz2 = kryo.readClass(input).getType();
        SerializedLambda serializedLambda = new SerializedLambda(clazz2, input.readString(), input.readString(), input.readString(), input.readVarInt(true), input.readString(), input.readString(), input.readString(), input.readString(), objectArray);
        try {
            return this.readResolve(clazz2, serializedLambda);
        }
        catch (Exception exception) {
            throw new KryoException("Error reading closure.", exception);
        }
    }

    public Object copy(Kryo kryo, Object object) {
        try {
            SerializedLambda serializedLambda = this.toSerializedLambda(object);
            Class<?> clazz = Class.forName(serializedLambda.getCapturingClass().replace('/', '.'));
            return this.readResolve(clazz, serializedLambda);
        }
        catch (Exception exception) {
            throw new KryoException("Error copying closure.", exception);
        }
    }

    private Object readResolve(Class<?> clazz, SerializedLambda serializedLambda) throws Exception {
        if (readResolve != null) {
            return readResolve.invoke((Object)serializedLambda, new Object[0]);
        }
        Method method = clazz.getDeclaredMethod("$deserializeLambda$", SerializedLambda.class);
        method.setAccessible(true);
        return method.invoke(null, serializedLambda);
    }

    private SerializedLambda toSerializedLambda(Object object) {
        Object object2;
        try {
            Method method = object.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            object2 = method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            if (object instanceof Serializable) {
                throw new KryoException("Error serializing closure.", exception);
            }
            throw new KryoException("Closure must implement java.io.Serializable.", exception);
        }
        try {
            return (SerializedLambda)object2;
        }
        catch (Exception exception) {
            throw new KryoException("writeReplace must return a SerializedLambda: " + Util.className(object2.getClass()), exception);
        }
    }

    public static class Closure {
    }
}

