/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.objectweb.asm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Type {
    public static final Type VOID_TYPE = new Type(0, "VZCBSIFJD", 0, 1);
    public static final Type BOOLEAN_TYPE = new Type(1, "VZCBSIFJD", 1, 2);
    public static final Type CHAR_TYPE = new Type(2, "VZCBSIFJD", 2, 3);
    public static final Type BYTE_TYPE = new Type(3, "VZCBSIFJD", 3, 4);
    public static final Type SHORT_TYPE = new Type(4, "VZCBSIFJD", 4, 5);
    public static final Type INT_TYPE = new Type(5, "VZCBSIFJD", 5, 6);
    public static final Type FLOAT_TYPE = new Type(6, "VZCBSIFJD", 6, 7);
    public static final Type LONG_TYPE = new Type(7, "VZCBSIFJD", 7, 8);
    public static final Type DOUBLE_TYPE = new Type(8, "VZCBSIFJD", 8, 9);
    private final int sort;
    private final String valueBuffer;
    private final int valueBegin;
    private final int valueEnd;

    private Type(int n2, String string, int n3, int n4) {
        this.sort = n2;
        this.valueBuffer = string;
        this.valueBegin = n3;
        this.valueEnd = n4;
    }

    public static Type getType(String string) {
        return Type.getTypeInternal(string, 0, string.length());
    }

    public static Type getType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_TYPE;
            }
            if (clazz == Void.TYPE) {
                return VOID_TYPE;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_TYPE;
            }
            if (clazz == Byte.TYPE) {
                return BYTE_TYPE;
            }
            if (clazz == Character.TYPE) {
                return CHAR_TYPE;
            }
            if (clazz == Short.TYPE) {
                return SHORT_TYPE;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE_TYPE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT_TYPE;
            }
            if (clazz == Long.TYPE) {
                return LONG_TYPE;
            }
            throw new AssertionError();
        }
        return Type.getType(Type.getDescriptor(clazz));
    }

    public Type getElementType() {
        int n2 = this.getDimensions();
        return Type.getTypeInternal(this.valueBuffer, this.valueBegin + n2, this.valueEnd);
    }

    public static Type getObjectType(String string) {
        return new Type(string.charAt(0) == '[' ? 9 : 12, string, 0, string.length());
    }

    public static Type getMethodType(String string) {
        return new Type(11, string, 0, string.length());
    }

    public static Type[] getArgumentTypes(String string) {
        int n2 = 0;
        int n3 = 1;
        while (string.charAt(n3) != ')') {
            while (string.charAt(n3) == '[') {
                ++n3;
            }
            if (string.charAt(n3++) == 'L') {
                int n4 = string.indexOf(59, n3);
                n3 = Math.max(n3, n4 + 1);
            }
            ++n2;
        }
        Type[] typeArray = new Type[n2];
        n3 = 1;
        int n5 = 0;
        while (string.charAt(n3) != ')') {
            int n6 = n3;
            while (string.charAt(n3) == '[') {
                ++n3;
            }
            if (string.charAt(n3++) == 'L') {
                int n7 = string.indexOf(59, n3);
                n3 = Math.max(n3, n7 + 1);
            }
            typeArray[n5++] = Type.getTypeInternal(string, n6, n3);
        }
        return typeArray;
    }

    public static Type getReturnType(String string) {
        return Type.getTypeInternal(string, Type.getReturnTypeOffset(string), string.length());
    }

    static int getReturnTypeOffset(String string) {
        int n2 = 1;
        while (string.charAt(n2) != ')') {
            while (string.charAt(n2) == '[') {
                ++n2;
            }
            if (string.charAt(n2++) != 'L') continue;
            int n3 = string.indexOf(59, n2);
            n2 = Math.max(n2, n3 + 1);
        }
        return n2 + 1;
    }

    private static Type getTypeInternal(String string, int n2, int n3) {
        switch (string.charAt(n2)) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                return new Type(9, string, n2, n3);
            }
            case 'L': {
                return new Type(10, string, n2 + 1, n3 - 1);
            }
            case '(': {
                return new Type(11, string, n2, n3);
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + string);
    }

    public String getClassName() {
        switch (this.sort) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                StringBuilder stringBuilder = new StringBuilder(this.getElementType().getClassName());
                for (int i2 = this.getDimensions(); i2 > 0; --i2) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            case 10: 
            case 12: {
                return this.valueBuffer.substring(this.valueBegin, this.valueEnd).replace('/', '.');
            }
        }
        throw new AssertionError();
    }

    public String getInternalName() {
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public static String getInternalName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public String getDescriptor() {
        if (this.sort == 10) {
            return this.valueBuffer.substring(this.valueBegin - 1, this.valueEnd + 1);
        }
        if (this.sort == 12) {
            return 'L' + this.valueBuffer.substring(this.valueBegin, this.valueEnd) + ';';
        }
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public static String getDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        Type.appendDescriptor(clazz, stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendDescriptor(Class<?> clazz, StringBuilder stringBuilder) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            stringBuilder.append('[');
            clazz2 = clazz2.getComponentType();
        }
        if (clazz2.isPrimitive()) {
            int n2;
            if (clazz2 == Integer.TYPE) {
                n2 = 73;
            } else if (clazz2 == Void.TYPE) {
                n2 = 86;
            } else if (clazz2 == Boolean.TYPE) {
                n2 = 90;
            } else if (clazz2 == Byte.TYPE) {
                n2 = 66;
            } else if (clazz2 == Character.TYPE) {
                n2 = 67;
            } else if (clazz2 == Short.TYPE) {
                n2 = 83;
            } else if (clazz2 == Double.TYPE) {
                n2 = 68;
            } else if (clazz2 == Float.TYPE) {
                n2 = 70;
            } else if (clazz2 == Long.TYPE) {
                n2 = 74;
            } else {
                throw new AssertionError();
            }
            stringBuilder.append((char)n2);
        } else {
            stringBuilder.append('L').append(Type.getInternalName(clazz2)).append(';');
        }
    }

    public int getSort() {
        return this.sort == 12 ? 10 : this.sort;
    }

    public int getDimensions() {
        int n2 = 1;
        while (this.valueBuffer.charAt(this.valueBegin + n2) == '[') {
            ++n2;
        }
        return n2;
    }

    public static int getArgumentsAndReturnSizes(String string) {
        int n2;
        int n3 = 1;
        int n4 = 1;
        char c2 = string.charAt(n4);
        while (c2 != ')') {
            if (c2 == 'J' || c2 == 'D') {
                ++n4;
                n3 += 2;
            } else {
                while (string.charAt(n4) == '[') {
                    ++n4;
                }
                if (string.charAt(n4++) == 'L') {
                    n2 = string.indexOf(59, n4);
                    n4 = Math.max(n4, n2 + 1);
                }
                ++n3;
            }
            c2 = string.charAt(n4);
        }
        c2 = string.charAt(n4 + 1);
        if (c2 == 'V') {
            return n3 << 2;
        }
        n2 = c2 == 'J' || c2 == 'D' ? 2 : 1;
        return n3 << 2 | n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        Type type = (Type)object;
        if ((this.sort == 12 ? 10 : this.sort) != (type.sort == 12 ? 10 : type.sort)) {
            return false;
        }
        int n2 = this.valueEnd;
        int n3 = this.valueBegin;
        int n4 = type.valueEnd;
        int n5 = type.valueBegin;
        if (n2 - n3 != n4 - n5) {
            return false;
        }
        int n6 = n3;
        int n7 = n5;
        while (n6 < n2) {
            if (this.valueBuffer.charAt(n6) != type.valueBuffer.charAt(n7)) {
                return false;
            }
            ++n6;
            ++n7;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 13 * (this.sort == 12 ? 10 : this.sort);
        if (this.sort >= 9) {
            int n3 = this.valueEnd;
            for (int i2 = this.valueBegin; i2 < n3; ++i2) {
                n2 = 17 * (n2 + this.valueBuffer.charAt(i2));
            }
        }
        return n2;
    }

    public String toString() {
        return this.getDescriptor();
    }
}

