/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyMetadata;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.FailingDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.ConcreteBeanPropertyBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.Annotations;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ViewMatcher;
import java.io.IOException;
import java.io.Serializable;

public abstract class SettableBeanProperty
extends ConcreteBeanPropertyBase
implements Serializable {
    protected static final JsonDeserializer<Object> MISSING_VALUE_DESERIALIZER = new FailingDeserializer("No _valueDeserializer assigned");
    protected final PropertyName _propName;
    protected final JavaType _type;
    protected final PropertyName _wrapperName;
    protected final transient Annotations _contextAnnotations;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final NullValueProvider _nullProvider;
    protected String _managedReferenceName;
    protected ObjectIdInfo _objectIdInfo;
    protected ViewMatcher _viewMatcher;
    protected int _propertyIndex = -1;

    protected SettableBeanProperty(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations) {
        this(beanPropertyDefinition.getFullName(), javaType, beanPropertyDefinition.getWrapperName(), typeDeserializer, annotations, beanPropertyDefinition.getMetadata());
    }

    protected SettableBeanProperty(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, TypeDeserializer typeDeserializer, Annotations annotations, PropertyMetadata propertyMetadata) {
        super(propertyMetadata);
        this._propName = propertyName == null ? PropertyName.NO_NAME : propertyName.internSimpleName();
        this._type = javaType;
        this._wrapperName = propertyName2;
        this._contextAnnotations = annotations;
        this._viewMatcher = null;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(this);
        }
        this._valueTypeDeserializer = typeDeserializer;
        this._valueDeserializer = MISSING_VALUE_DESERIALIZER;
        this._nullProvider = MISSING_VALUE_DESERIALIZER;
    }

    protected SettableBeanProperty(PropertyName propertyName, JavaType javaType, PropertyMetadata propertyMetadata, JsonDeserializer<Object> jsonDeserializer) {
        super(propertyMetadata);
        this._propName = propertyName == null ? PropertyName.NO_NAME : propertyName.internSimpleName();
        this._type = javaType;
        this._wrapperName = null;
        this._contextAnnotations = null;
        this._viewMatcher = null;
        this._valueTypeDeserializer = null;
        this._valueDeserializer = jsonDeserializer;
        this._nullProvider = jsonDeserializer;
    }

    protected SettableBeanProperty(SettableBeanProperty settableBeanProperty) {
        super(settableBeanProperty);
        this._propName = settableBeanProperty._propName;
        this._type = settableBeanProperty._type;
        this._wrapperName = settableBeanProperty._wrapperName;
        this._contextAnnotations = settableBeanProperty._contextAnnotations;
        this._valueDeserializer = settableBeanProperty._valueDeserializer;
        this._valueTypeDeserializer = settableBeanProperty._valueTypeDeserializer;
        this._managedReferenceName = settableBeanProperty._managedReferenceName;
        this._propertyIndex = settableBeanProperty._propertyIndex;
        this._viewMatcher = settableBeanProperty._viewMatcher;
        this._nullProvider = settableBeanProperty._nullProvider;
    }

    protected SettableBeanProperty(SettableBeanProperty settableBeanProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider jsonDeserializer2) {
        super(settableBeanProperty);
        this._propName = settableBeanProperty._propName;
        this._type = settableBeanProperty._type;
        this._wrapperName = settableBeanProperty._wrapperName;
        this._contextAnnotations = settableBeanProperty._contextAnnotations;
        this._valueTypeDeserializer = settableBeanProperty._valueTypeDeserializer;
        this._managedReferenceName = settableBeanProperty._managedReferenceName;
        this._propertyIndex = settableBeanProperty._propertyIndex;
        this._valueDeserializer = jsonDeserializer == null ? MISSING_VALUE_DESERIALIZER : jsonDeserializer;
        this._viewMatcher = settableBeanProperty._viewMatcher;
        if (jsonDeserializer2 == MISSING_VALUE_DESERIALIZER) {
            jsonDeserializer2 = this._valueDeserializer;
        }
        this._nullProvider = jsonDeserializer2;
    }

    protected SettableBeanProperty(SettableBeanProperty settableBeanProperty, PropertyName propertyName) {
        super(settableBeanProperty);
        this._propName = propertyName;
        this._type = settableBeanProperty._type;
        this._wrapperName = settableBeanProperty._wrapperName;
        this._contextAnnotations = settableBeanProperty._contextAnnotations;
        this._valueDeserializer = settableBeanProperty._valueDeserializer;
        this._valueTypeDeserializer = settableBeanProperty._valueTypeDeserializer;
        this._managedReferenceName = settableBeanProperty._managedReferenceName;
        this._propertyIndex = settableBeanProperty._propertyIndex;
        this._viewMatcher = settableBeanProperty._viewMatcher;
        this._nullProvider = settableBeanProperty._nullProvider;
    }

    public abstract SettableBeanProperty withValueDeserializer(JsonDeserializer<?> var1);

    public abstract SettableBeanProperty withName(PropertyName var1);

    public SettableBeanProperty withSimpleName(String string) {
        PropertyName propertyName = this._propName == null ? new PropertyName(string) : this._propName.withSimpleName(string);
        return propertyName == this._propName ? this : this.withName(propertyName);
    }

    public abstract SettableBeanProperty withNullProvider(NullValueProvider var1);

    public void setManagedReferenceName(String string) {
        this._managedReferenceName = string;
    }

    public void setObjectIdInfo(ObjectIdInfo objectIdInfo) {
        this._objectIdInfo = objectIdInfo;
    }

    public void setViews(Class<?>[] classArray) {
        this._viewMatcher = classArray == null ? null : ViewMatcher.construct(classArray);
    }

    public void assignIndex(int n2) {
        if (this._propertyIndex != -1) {
            throw new IllegalStateException("Property '" + this.getName() + "' already had index (" + this._propertyIndex + "), trying to assign " + n2);
        }
        this._propertyIndex = n2;
    }

    public void fixAccess(DeserializationConfig deserializationConfig) {
    }

    public void markAsIgnorable() {
    }

    public boolean isIgnorable() {
        return false;
    }

    @Override
    public final String getName() {
        return this._propName.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._propName;
    }

    @Override
    public JavaType getType() {
        return this._type;
    }

    @Override
    public abstract AnnotatedMember getMember();

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.isRequired()) {
            jsonObjectFormatVisitor.property(this);
        } else {
            jsonObjectFormatVisitor.optionalProperty(this);
        }
    }

    protected Class<?> getDeclaringClass() {
        return this.getMember().getDeclaringClass();
    }

    public String getManagedReferenceName() {
        return this._managedReferenceName;
    }

    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null && this._valueDeserializer != MISSING_VALUE_DESERIALIZER;
    }

    public boolean hasValueTypeDeserializer() {
        return this._valueTypeDeserializer != null;
    }

    public JsonDeserializer<Object> getValueDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        if (jsonDeserializer == MISSING_VALUE_DESERIALIZER) {
            return null;
        }
        return jsonDeserializer;
    }

    public TypeDeserializer getValueTypeDeserializer() {
        return this._valueTypeDeserializer;
    }

    public NullValueProvider getNullValueProvider() {
        return this._nullProvider;
    }

    public boolean visibleInView(Class<?> clazz) {
        return this._viewMatcher == null || this._viewMatcher.isVisibleForView(clazz);
    }

    public boolean hasViews() {
        return this._viewMatcher != null;
    }

    public int getCreatorIndex() {
        throw new IllegalStateException(String.format("Internal error: no creator index for property '%s' (of type %s)", this.getName(), this.getClass().getName()));
    }

    public Object getInjectableValueId() {
        return null;
    }

    public boolean isInjectionOnly() {
        return false;
    }

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException;

    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3) throws IOException;

    public abstract void set(Object var1, Object var2) throws IOException;

    public abstract Object setAndReturn(Object var1, Object var2) throws IOException;

    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return this._nullProvider.getNullValue(deserializationContext);
        }
        if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        Object object = this._valueDeserializer.deserialize(jsonParser, deserializationContext);
        if (object == null) {
            object = this._nullProvider.getNullValue(deserializationContext);
        }
        return object;
    }

    public final Object deserializeWith(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            if (NullsConstantProvider.isSkipper(this._nullProvider)) {
                return object;
            }
            return this._nullProvider.getNullValue(deserializationContext);
        }
        if (this._valueTypeDeserializer != null) {
            JavaType javaType = deserializationContext.getTypeFactory().constructType(object.getClass());
            JsonDeserializer<Object> jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, this);
            return jsonDeserializer.deserialize(jsonParser, deserializationContext, object);
        }
        Object object2 = this._valueDeserializer.deserialize(jsonParser, deserializationContext, object);
        if (object2 == null) {
            if (NullsConstantProvider.isSkipper(this._nullProvider)) {
                return object;
            }
            object2 = this._nullProvider.getNullValue(deserializationContext);
        }
        return object2;
    }

    protected void _throwAsIOE(JsonParser jsonParser, Exception exception, Object object) throws IOException {
        if (exception instanceof IllegalArgumentException) {
            String string = ClassUtil.classNameOf(object);
            StringBuilder stringBuilder = new StringBuilder("Problem deserializing property '").append(this.getName()).append("' (expected type: ").append(this.getType()).append("; actual type: ").append(string).append(")");
            String string2 = ClassUtil.exceptionMessage(exception);
            if (string2 != null) {
                stringBuilder.append(", problem: ").append(string2);
            } else {
                stringBuilder.append(" (no error message provided)");
            }
            throw JsonMappingException.from(jsonParser, stringBuilder.toString(), (Throwable)exception);
        }
        this._throwAsIOE(jsonParser, exception);
    }

    protected IOException _throwAsIOE(JsonParser jsonParser, Exception exception) throws IOException {
        ClassUtil.throwIfIOE(exception);
        ClassUtil.throwIfRTE(exception);
        Throwable throwable = ClassUtil.getRootCause(exception);
        throw JsonMappingException.from(jsonParser, ClassUtil.exceptionMessage(throwable), throwable);
    }

    protected void _throwAsIOE(Exception exception, Object object) throws IOException {
        this._throwAsIOE(null, exception, object);
    }

    public String toString() {
        return "[property '" + this.getName() + "']";
    }

    public static abstract class Delegating
    extends SettableBeanProperty {
        protected final SettableBeanProperty delegate;

        protected Delegating(SettableBeanProperty settableBeanProperty) {
            super(settableBeanProperty);
            this.delegate = settableBeanProperty;
        }

        protected abstract SettableBeanProperty withDelegate(SettableBeanProperty var1);

        protected SettableBeanProperty _with(SettableBeanProperty settableBeanProperty) {
            if (settableBeanProperty == this.delegate) {
                return this;
            }
            return this.withDelegate(settableBeanProperty);
        }

        @Override
        public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
            return this._with(this.delegate.withValueDeserializer(jsonDeserializer));
        }

        @Override
        public SettableBeanProperty withName(PropertyName propertyName) {
            return this._with(this.delegate.withName(propertyName));
        }

        @Override
        public SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
            return this._with(this.delegate.withNullProvider(nullValueProvider));
        }

        @Override
        public void assignIndex(int n2) {
            this.delegate.assignIndex(n2);
        }

        @Override
        public void fixAccess(DeserializationConfig deserializationConfig) {
            this.delegate.fixAccess(deserializationConfig);
        }

        @Override
        protected Class<?> getDeclaringClass() {
            return this.delegate.getDeclaringClass();
        }

        @Override
        public String getManagedReferenceName() {
            return this.delegate.getManagedReferenceName();
        }

        @Override
        public ObjectIdInfo getObjectIdInfo() {
            return this.delegate.getObjectIdInfo();
        }

        @Override
        public boolean hasValueDeserializer() {
            return this.delegate.hasValueDeserializer();
        }

        @Override
        public boolean hasValueTypeDeserializer() {
            return this.delegate.hasValueTypeDeserializer();
        }

        @Override
        public JsonDeserializer<Object> getValueDeserializer() {
            return this.delegate.getValueDeserializer();
        }

        @Override
        public TypeDeserializer getValueTypeDeserializer() {
            return this.delegate.getValueTypeDeserializer();
        }

        @Override
        public boolean visibleInView(Class<?> clazz) {
            return this.delegate.visibleInView(clazz);
        }

        @Override
        public boolean hasViews() {
            return this.delegate.hasViews();
        }

        @Override
        public int getCreatorIndex() {
            return this.delegate.getCreatorIndex();
        }

        @Override
        public Object getInjectableValueId() {
            return this.delegate.getInjectableValueId();
        }

        @Override
        public boolean isInjectionOnly() {
            return this.delegate.isInjectionOnly();
        }

        @Override
        public AnnotatedMember getMember() {
            return this.delegate.getMember();
        }

        @Override
        public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
            this.delegate.deserializeAndSet(jsonParser, deserializationContext, object);
        }

        @Override
        public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
            return this.delegate.deserializeSetAndReturn(jsonParser, deserializationContext, object);
        }

        @Override
        public void set(Object object, Object object2) throws IOException {
            this.delegate.set(object, object2);
        }

        @Override
        public Object setAndReturn(Object object, Object object2) throws IOException {
            return this.delegate.setAndReturn(object, object2);
        }
    }
}

