/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.NullnessCasts;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Objects;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Supplier;
import java.io.Serializable;

public final class Suppliers {
    public static <T> Supplier<T> memoize(Supplier<T> supplier) {
        if (supplier instanceof NonSerializableMemoizingSupplier || supplier instanceof MemoizingSupplier) {
            return supplier;
        }
        return supplier instanceof Serializable ? new MemoizingSupplier<T>(supplier) : new NonSerializableMemoizingSupplier<T>(supplier);
    }

    public static <T> Supplier<T> ofInstance(T t2) {
        return new SupplierOfInstance<T>(t2);
    }

    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        final T instance;

        SupplierOfInstance(T t2) {
            this.instance = t2;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public boolean equals(Object object) {
            if (object instanceof SupplierOfInstance) {
                SupplierOfInstance supplierOfInstance = (SupplierOfInstance)object;
                return Objects.equal(this.instance, supplierOfInstance.instance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }

        public String toString() {
            String string = String.valueOf(this.instance);
            return new StringBuilder(22 + String.valueOf(string).length()).append("Suppliers.ofInstance(").append(string).append(")").toString();
        }
    }

    static class NonSerializableMemoizingSupplier<T>
    implements Supplier<T> {
        volatile Supplier<T> delegate;
        volatile boolean initialized;
        T value;

        NonSerializableMemoizingSupplier(Supplier<T> supplier) {
            this.delegate = Preconditions.checkNotNull(supplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                NonSerializableMemoizingSupplier nonSerializableMemoizingSupplier = this;
                synchronized (nonSerializableMemoizingSupplier) {
                    if (!this.initialized) {
                        T t2 = java.util.Objects.requireNonNull(this.delegate).get();
                        this.value = t2;
                        this.initialized = true;
                        this.delegate = null;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            Object object;
            String string;
            Supplier<T> supplier = this.delegate;
            if (supplier == null) {
                string = String.valueOf(this.value);
                object = new StringBuilder(25 + String.valueOf(string).length()).append("<supplier that returned ").append(string).append(">").toString();
            } else {
                object = supplier;
            }
            string = String.valueOf(object);
            return new StringBuilder(19 + String.valueOf(string).length()).append("Suppliers.memoize(").append(string).append(")").toString();
        }
    }

    static class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;

        MemoizingSupplier(Supplier<T> supplier) {
            this.delegate = Preconditions.checkNotNull(supplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        T t2 = this.delegate.get();
                        this.value = t2;
                        this.initialized = true;
                        return t2;
                    }
                }
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.value);
        }

        public String toString() {
            Object object;
            String string;
            if (this.initialized) {
                string = String.valueOf(this.value);
                object = new StringBuilder(25 + String.valueOf(string).length()).append("<supplier that returned ").append(string).append(">").toString();
            } else {
                object = this.delegate;
            }
            string = String.valueOf(object);
            return new StringBuilder(19 + String.valueOf(string).length()).append("Suppliers.memoize(").append(string).append(")").toString();
        }
    }
}

