/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.de.javakaffee.kryoserializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class UnmodifiableCollectionsSerializer
extends Serializer<Object> {
    private static final Field SOURCE_COLLECTION_FIELD;
    private static final Field SOURCE_MAP_FIELD;

    @Override
    public Object read(Kryo kryo, Input input, Class<? extends Object> clazz) {
        int n2 = input.readInt(true);
        UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.values()[n2];
        Object object = kryo.readClassAndObject(input);
        return unmodifiableCollection.create(object);
    }

    @Override
    public void write(Kryo kryo, Output output, Object object) {
        try {
            UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.valueOfType(object.getClass());
            output.writeInt(unmodifiableCollection.ordinal(), true);
            kryo.writeClassAndObject(output, unmodifiableCollection.sourceCollectionField.get(object));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object copy(Kryo kryo, Object object) {
        try {
            UnmodifiableCollection unmodifiableCollection = UnmodifiableCollection.valueOfType(object.getClass());
            Object object2 = kryo.copy(unmodifiableCollection.sourceCollectionField.get(object));
            return unmodifiableCollection.create(object2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void registerSerializers(Kryo kryo) {
        UnmodifiableCollectionsSerializer unmodifiableCollectionsSerializer = new UnmodifiableCollectionsSerializer();
        UnmodifiableCollection.values();
        for (UnmodifiableCollection unmodifiableCollection : UnmodifiableCollection.values()) {
            kryo.register(unmodifiableCollection.type, unmodifiableCollectionsSerializer);
        }
    }

    static /* synthetic */ Field access$100() {
        return SOURCE_COLLECTION_FIELD;
    }

    static /* synthetic */ Field access$300() {
        return SOURCE_MAP_FIELD;
    }

    static {
        try {
            SOURCE_COLLECTION_FIELD = Class.forName("java.util.Collections$UnmodifiableCollection").getDeclaredField("c");
            SOURCE_COLLECTION_FIELD.setAccessible(true);
            SOURCE_MAP_FIELD = Class.forName("java.util.Collections$UnmodifiableMap").getDeclaredField("m");
            SOURCE_MAP_FIELD.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not access source collection field in java.util.Collections$UnmodifiableCollection.", exception);
        }
    }

    private static enum UnmodifiableCollection {
        COLLECTION((Class)Collections.unmodifiableCollection(Arrays.asList("")).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object object) {
                return Collections.unmodifiableCollection((Collection)object);
            }
        }
        ,
        RANDOM_ACCESS_LIST((Class)Collections.unmodifiableList(new ArrayList<E>()).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object object) {
                return Collections.unmodifiableList((List)object);
            }
        }
        ,
        LIST((Class)Collections.unmodifiableList(new LinkedList<E>()).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object object) {
                return Collections.unmodifiableList((List)object);
            }
        }
        ,
        SET((Class)Collections.unmodifiableSet(new HashSet<E>()).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object object) {
                return Collections.unmodifiableSet((Set)object);
            }
        }
        ,
        SORTED_SET((Class)Collections.unmodifiableSortedSet(new TreeSet<E>()).getClass(), UnmodifiableCollectionsSerializer.access$100()){

            @Override
            public Object create(Object object) {
                return Collections.unmodifiableSortedSet((SortedSet)object);
            }
        }
        ,
        MAP((Class)Collections.unmodifiableMap(new HashMap<K, V>()).getClass(), UnmodifiableCollectionsSerializer.access$300()){

            @Override
            public Object create(Object object) {
                return Collections.unmodifiableMap((Map)object);
            }
        }
        ,
        SORTED_MAP((Class)Collections.unmodifiableSortedMap(new TreeMap<K, V>()).getClass(), UnmodifiableCollectionsSerializer.access$300()){

            @Override
            public Object create(Object object) {
                return Collections.unmodifiableSortedMap((SortedMap)object);
            }
        };

        private final Class<?> type;
        private final Field sourceCollectionField;

        private UnmodifiableCollection(Class<?> clazz, Field field) {
            this.type = clazz;
            this.sourceCollectionField = field;
        }

        public abstract Object create(Object var1);

        static UnmodifiableCollection valueOfType(Class<?> clazz) {
            for (UnmodifiableCollection unmodifiableCollection : UnmodifiableCollection.values()) {
                if (!unmodifiableCollection.type.equals(clazz)) continue;
                return unmodifiableCollection;
            }
            throw new IllegalArgumentException("The type " + clazz + " is not supported.");
        }
    }
}

