/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar;

import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncoding;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TarUtils {
    static final ZipEncoding DEFAULT_ENCODING = ZipEncodingHelper.getZipEncoding(null);
    static final ZipEncoding FALLBACK_ENCODING = new ZipEncoding(){

        @Override
        public boolean canEncode(String string) {
            return true;
        }

        @Override
        public ByteBuffer encode(String string) {
            int n2 = string.length();
            byte[] byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = (byte)string.charAt(i2);
            }
            return ByteBuffer.wrap(byArray);
        }

        @Override
        public String decode(byte[] byArray) {
            int n2 = byArray.length;
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (byte by2 : byArray) {
                if (by2 == 0) break;
                stringBuilder.append((char)(by2 & 0xFF));
            }
            return stringBuilder.toString();
        }
    };

    public static long parseOctal(byte[] byArray, int n2, int n3) {
        int n4;
        long l2 = 0L;
        int n5 = n2 + n3;
        if (n3 < 2) {
            throw new IllegalArgumentException("Length " + n3 + " must be at least 2");
        }
        if (byArray[n4] == 0) {
            return 0L;
        }
        for (n4 = n2; n4 < n5 && byArray[n4] == 32; ++n4) {
        }
        byte by2 = byArray[n5 - 1];
        while (n4 < n5 && (by2 == 0 || by2 == 32)) {
            by2 = byArray[--n5 - 1];
        }
        while (n4 < n5) {
            byte by3 = byArray[n4];
            if (by3 < 48 || by3 > 55) {
                throw new IllegalArgumentException(TarUtils.exceptionMessage(byArray, n2, n3, n4, by3));
            }
            l2 = (l2 << 3) + (long)(by3 - 48);
            ++n4;
        }
        return l2;
    }

    public static long parseOctalOrBinary(byte[] byArray, int n2, int n3) {
        boolean bl2;
        if ((byArray[n2] & 0x80) == 0) {
            return TarUtils.parseOctal(byArray, n2, n3);
        }
        boolean bl3 = bl2 = byArray[n2] == -1;
        if (n3 < 9) {
            return TarUtils.parseBinaryLong(byArray, n2, n3, bl2);
        }
        return TarUtils.parseBinaryBigInteger(byArray, n2, n3, bl2);
    }

    private static long parseBinaryLong(byte[] byArray, int n2, int n3, boolean bl2) {
        if (n3 >= 9) {
            throw new IllegalArgumentException("At offset " + n2 + ", " + n3 + " byte binary number exceeds maximum signed long value");
        }
        long l2 = 0L;
        for (int i2 = 1; i2 < n3; ++i2) {
            l2 = (l2 << 8) + (long)(byArray[n2 + i2] & 0xFF);
        }
        if (bl2) {
            --l2;
            l2 ^= (long)Math.pow(2.0, (double)(n3 - 1) * 8.0) - 1L;
        }
        return bl2 ? -l2 : l2;
    }

    private static long parseBinaryBigInteger(byte[] byArray, int n2, int n3, boolean bl2) {
        byte[] byArray2 = new byte[n3 - 1];
        System.arraycopy(byArray, n2 + 1, byArray2, 0, n3 - 1);
        BigInteger bigInteger = new BigInteger(byArray2);
        if (bl2) {
            bigInteger = bigInteger.add(BigInteger.valueOf(-1L)).not();
        }
        if (bigInteger.bitLength() > 63) {
            throw new IllegalArgumentException("At offset " + n2 + ", " + n3 + " byte binary number exceeds maximum signed long value");
        }
        return bl2 ? -bigInteger.longValue() : bigInteger.longValue();
    }

    public static boolean parseBoolean(byte[] byArray, int n2) {
        return byArray[n2] == 1;
    }

    private static String exceptionMessage(byte[] byArray, int n2, int n3, int n4, byte by2) {
        String string = new String(byArray, n2, n3, Charset.defaultCharset());
        string = string.replace("\u0000", "{NUL}");
        return "Invalid byte " + by2 + " at offset " + (n4 - n2) + " in '" + string + "' len=" + n3;
    }

    public static String parseName(byte[] byArray, int n2, int n3) {
        try {
            return TarUtils.parseName(byArray, n2, n3, DEFAULT_ENCODING);
        }
        catch (IOException iOException) {
            try {
                return TarUtils.parseName(byArray, n2, n3, FALLBACK_ENCODING);
            }
            catch (IOException iOException2) {
                throw new UncheckedIOException(iOException2);
            }
        }
    }

    public static String parseName(byte[] byArray, int n2, int n3, ZipEncoding zipEncoding) throws IOException {
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3 && byArray[n5] != 0) {
            ++n4;
            ++n5;
        }
        if (n4 > 0) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n2, byArray2, 0, n4);
            return zipEncoding.decode(byArray2);
        }
        return "";
    }

    public static TarArchiveStructSparse parseSparse(byte[] byArray, int n2) {
        long l2 = TarUtils.parseOctalOrBinary(byArray, n2, 12);
        long l3 = TarUtils.parseOctalOrBinary(byArray, n2 + 12, 12);
        return new TarArchiveStructSparse(l2, l3);
    }

    static List<TarArchiveStructSparse> readSparseStructs(byte[] byArray, int n2, int n3) throws IOException {
        ArrayList<TarArchiveStructSparse> arrayList = new ArrayList<TarArchiveStructSparse>();
        for (int i2 = 0; i2 < n3; ++i2) {
            try {
                TarArchiveStructSparse tarArchiveStructSparse = TarUtils.parseSparse(byArray, n2 + i2 * 24);
                if (tarArchiveStructSparse.getOffset() < 0L) {
                    throw new IOException("Corrupted TAR archive, sparse entry with negative offset");
                }
                if (tarArchiveStructSparse.getNumbytes() < 0L) {
                    throw new IOException("Corrupted TAR archive, sparse entry with negative numbytes");
                }
                arrayList.add(tarArchiveStructSparse);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Corrupted TAR archive, sparse entry is invalid", illegalArgumentException);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static int formatNameBytes(String string, byte[] byArray, int n2, int n3) {
        try {
            return TarUtils.formatNameBytes(string, byArray, n2, n3, DEFAULT_ENCODING);
        }
        catch (IOException iOException) {
            try {
                return TarUtils.formatNameBytes(string, byArray, n2, n3, FALLBACK_ENCODING);
            }
            catch (IOException iOException2) {
                throw new UncheckedIOException(iOException2);
            }
        }
    }

    public static int formatNameBytes(String string, byte[] byArray, int n2, int n3, ZipEncoding zipEncoding) throws IOException {
        int n4 = string.length();
        ByteBuffer byteBuffer = zipEncoding.encode(string);
        while (byteBuffer.limit() > n3 && n4 > 0) {
            byteBuffer = zipEncoding.encode(string.substring(0, --n4));
        }
        int n5 = byteBuffer.limit() - byteBuffer.position();
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray, n2, n5);
        for (int i2 = n5; i2 < n3; ++i2) {
            byArray[n2 + i2] = 0;
        }
        return n2 + n3;
    }

    public static void formatUnsignedOctalString(long l2, byte[] byArray, int n2, int n3) {
        int n4 = n3;
        --n4;
        if (l2 == 0L) {
            byArray[n2 + n4--] = 48;
        } else {
            long l3;
            for (l3 = l2; n4 >= 0 && l3 != 0L; l3 >>>= 3, --n4) {
                byArray[n2 + n4] = (byte)(48 + (byte)(l3 & 7L));
            }
            if (l3 != 0L) {
                throw new IllegalArgumentException(l2 + "=" + Long.toOctalString(l2) + " will not fit in octal number buffer of length " + n3);
            }
        }
        while (n4 >= 0) {
            byArray[n2 + n4] = 48;
            --n4;
        }
    }

    public static int formatLongOctalBytes(long l2, byte[] byArray, int n2, int n3) {
        int n4 = n3 - 1;
        TarUtils.formatUnsignedOctalString(l2, byArray, n2, n4);
        byArray[n2 + n4] = 32;
        return n2 + n3;
    }

    public static int formatLongOctalOrBinaryBytes(long l2, byte[] byArray, int n2, int n3) {
        boolean bl2;
        long l3 = n3 == 8 ? 0x1FFFFFL : 0x1FFFFFFFFL;
        boolean bl3 = bl2 = l2 < 0L;
        if (!bl2 && l2 <= l3) {
            return TarUtils.formatLongOctalBytes(l2, byArray, n2, n3);
        }
        if (n3 < 9) {
            TarUtils.formatLongBinary(l2, byArray, n2, n3, bl2);
        } else {
            TarUtils.formatBigIntegerBinary(l2, byArray, n2, n3, bl2);
        }
        byArray[n2] = (byte)(bl2 ? 255 : 128);
        return n2 + n3;
    }

    private static void formatLongBinary(long l2, byte[] byArray, int n2, int n3, boolean bl2) {
        int n4 = (n3 - 1) * 8;
        long l3 = 1L << n4;
        long l4 = Math.abs(l2);
        if (l4 < 0L || l4 >= l3) {
            throw new IllegalArgumentException("Value " + l2 + " is too large for " + n3 + " byte field.");
        }
        if (bl2) {
            l4 ^= l3 - 1L;
            ++l4;
            l4 |= 255L << n4;
        }
        for (int i2 = n2 + n3 - 1; i2 >= n2; --i2) {
            byArray[i2] = (byte)l4;
            l4 >>= 8;
        }
    }

    private static void formatBigIntegerBinary(long l2, byte[] byArray, int n2, int n3, boolean bl2) {
        BigInteger bigInteger = BigInteger.valueOf(l2);
        byte[] byArray2 = bigInteger.toByteArray();
        int n4 = byArray2.length;
        if (n4 > n3 - 1) {
            throw new IllegalArgumentException("Value " + l2 + " is too large for " + n3 + " byte field.");
        }
        int n5 = n2 + n3 - n4;
        System.arraycopy(byArray2, 0, byArray, n5, n4);
        byte by2 = (byte)(bl2 ? 255 : 0);
        for (int i2 = n2 + 1; i2 < n5; ++i2) {
            byArray[i2] = by2;
        }
    }

    public static int formatCheckSumOctalBytes(long l2, byte[] byArray, int n2, int n3) {
        int n4 = n3 - 2;
        TarUtils.formatUnsignedOctalString(l2, byArray, n2, n4);
        byArray[n2 + n4++] = 0;
        byArray[n2 + n4] = 32;
        return n2 + n3;
    }

    public static long computeCheckSum(byte[] byArray) {
        long l2 = 0L;
        for (byte by2 : byArray) {
            l2 += (long)(0xFF & by2);
        }
        return l2;
    }

    public static boolean verifyCheckSum(byte[] byArray) {
        long l2 = TarUtils.parseOctal(byArray, 148, 8);
        long l3 = 0L;
        long l4 = 0L;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2];
            if (148 <= i2 && i2 < 156) {
                n2 = 32;
            }
            l3 += (long)(0xFF & n2);
            l4 += (long)n2;
        }
        return l2 == l3 || l2 == l4;
    }

    protected static Map<String, String> parsePaxHeaders(InputStream inputStream, List<TarArchiveStructSparse> list, Map<String, String> map, long l2) throws IOException {
        int n2;
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        Long l3 = null;
        int n3 = 0;
        block4: do {
            int n4 = 0;
            int n5 = 0;
            while ((n2 = inputStream.read()) != -1) {
                ++n5;
                ++n3;
                if (n2 == 10) continue block4;
                if (n2 == 32) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n2 = inputStream.read()) != -1) {
                        ++n5;
                        if (++n3 < 0 || l2 >= 0L && (long)n3 >= l2) continue block4;
                        if (n2 == 61) {
                            long l4;
                            String string = byteArrayOutputStream.toString("UTF-8");
                            int n6 = n4 - n5;
                            if (n6 <= 1) {
                                hashMap.remove(string);
                                continue block4;
                            }
                            if (l2 >= 0L && (long)n6 > l2 - (long)n3) {
                                throw new IOException("Paxheader value size " + n6 + " exceeds size of header record");
                            }
                            byte[] byArray = IOUtils.readRange(inputStream, n6);
                            int n7 = byArray.length;
                            if (n7 != n6) {
                                throw new IOException("Failed to read Paxheader. Expected " + n6 + " bytes, read " + n7);
                            }
                            n3 += n6;
                            if (byArray[n6 - 1] != 10) {
                                throw new IOException("Failed to read Paxheader.Value should end with a newline");
                            }
                            String string2 = new String(byArray, 0, n6 - 1, StandardCharsets.UTF_8);
                            hashMap.put(string, string2);
                            if (string.equals("GNU.sparse.offset")) {
                                if (l3 != null) {
                                    list.add(new TarArchiveStructSparse(l3, 0L));
                                }
                                try {
                                    l3 = Long.valueOf(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new IOException("Failed to read Paxheader.GNU.sparse.offset contains a non-numeric value");
                                }
                                if (l3 < 0L) {
                                    throw new IOException("Failed to read Paxheader.GNU.sparse.offset contains negative value");
                                }
                            }
                            if (!string.equals("GNU.sparse.numbytes")) continue block4;
                            if (l3 == null) {
                                throw new IOException("Failed to read Paxheader.GNU.sparse.offset is expected before GNU.sparse.numbytes shows up.");
                            }
                            try {
                                l4 = Long.parseLong(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IOException("Failed to read Paxheader.GNU.sparse.numbytes contains a non-numeric value.");
                            }
                            if (l4 < 0L) {
                                throw new IOException("Failed to read Paxheader.GNU.sparse.numbytes contains negative value");
                            }
                            list.add(new TarArchiveStructSparse(l3, l4));
                            l3 = null;
                            continue block4;
                        }
                        byteArrayOutputStream.write((byte)n2);
                    }
                    continue block4;
                }
                if (n2 < 48 || n2 > 57) {
                    throw new IOException("Failed to read Paxheader. Encountered a non-number while reading length");
                }
                n4 *= 10;
                n4 += n2 - 48;
            }
        } while (n2 != -1);
        if (l3 != null) {
            list.add(new TarArchiveStructSparse(l3, 0L));
        }
        return hashMap;
    }

    protected static List<TarArchiveStructSparse> parseFromPAX01SparseHeaders(String string) throws IOException {
        ArrayList<TarArchiveStructSparse> arrayList = new ArrayList<TarArchiveStructSparse>();
        String[] stringArray = string.split(",");
        if (stringArray.length % 2 == 1) {
            throw new IOException("Corrupted TAR archive. Bad format in GNU.sparse.map PAX Header");
        }
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            long l2;
            long l3;
            try {
                l3 = Long.parseLong(stringArray[i2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Corrupted TAR archive. Sparse struct offset contains a non-numeric value");
            }
            if (l3 < 0L) {
                throw new IOException("Corrupted TAR archive. Sparse struct offset contains negative value");
            }
            try {
                l2 = Long.parseLong(stringArray[i2 + 1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Corrupted TAR archive. Sparse struct numbytes contains a non-numeric value");
            }
            if (l2 < 0L) {
                throw new IOException("Corrupted TAR archive. Sparse struct numbytes contains negative value");
            }
            arrayList.add(new TarArchiveStructSparse(l3, l2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected static List<TarArchiveStructSparse> parsePAX1XSparseHeaders(InputStream inputStream, int n2) throws IOException {
        long l2;
        ArrayList<TarArchiveStructSparse> arrayList = new ArrayList<TarArchiveStructSparse>();
        long l3 = 0L;
        long[] lArray = TarUtils.readLineOfNumberForPax1X(inputStream);
        long l4 = lArray[0];
        if (l4 < 0L) {
            throw new IOException("Corrupted TAR archive. Negative value in sparse headers block");
        }
        l3 += lArray[1];
        while (l4-- > 0L) {
            lArray = TarUtils.readLineOfNumberForPax1X(inputStream);
            l2 = lArray[0];
            if (l2 < 0L) {
                throw new IOException("Corrupted TAR archive. Sparse header block offset contains negative value");
            }
            l3 += lArray[1];
            lArray = TarUtils.readLineOfNumberForPax1X(inputStream);
            long l5 = lArray[0];
            if (l5 < 0L) {
                throw new IOException("Corrupted TAR archive. Sparse header block numbytes contains negative value");
            }
            l3 += lArray[1];
            arrayList.add(new TarArchiveStructSparse(l2, l5));
        }
        l2 = (long)n2 - l3 % (long)n2;
        IOUtils.skip(inputStream, l2);
        return arrayList;
    }

    private static long[] readLineOfNumberForPax1X(InputStream inputStream) throws IOException {
        int n2;
        long l2 = 0L;
        long l3 = 0L;
        while ((n2 = inputStream.read()) != 10) {
            ++l3;
            if (n2 == -1) {
                throw new IOException("Unexpected EOF when reading parse information of 1.X PAX format");
            }
            if (n2 < 48 || n2 > 57) {
                throw new IOException("Corrupted TAR archive. Non-numeric value in sparse headers block");
            }
            l2 = l2 * 10L + (long)(n2 - 48);
        }
        return new long[]{l2, ++l3};
    }
}

