/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.PlexusResource;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.ResourceManager;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader.ResourceLoader;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultResourceManager
implements ResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceManager.class);
    private final Map<String, ResourceLoader> resourceLoaders;
    private File outputDirectory;

    @Inject
    private DefaultResourceManager(Map<String, ResourceLoader> map) {
        this.resourceLoaders = map;
    }

    @Override
    public void setOutputDirectory(File file) {
        this.outputDirectory = file;
    }

    @Override
    public void addSearchPath(String string, String string2) {
        ResourceLoader resourceLoader = this.resourceLoaders.get(string);
        if (resourceLoader == null) {
            throw new IllegalArgumentException("unknown resource loader: " + string);
        }
        resourceLoader.addSearchPath(string2);
    }

    @Override
    public PlexusResource getResource(String string) throws ResourceNotFoundException {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            try {
                PlexusResource plexusResource = resourceLoader.getResource(string);
                LOGGER.debug("The resource '{}' was found as '{}'", (Object)string, (Object)plexusResource.getName());
                return plexusResource;
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                LOGGER.debug("The resource '{}' was not found with resourceLoader '{}'", (Object)string, (Object)resourceLoader.getClass().getName());
            }
        }
        throw new ResourceNotFoundException(string);
    }
}

