/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.util;

import com.gradle.maven.extension.internal.dep.org.springframework.util.CollectionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.TimeZone;

public abstract class StringUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean hasLength(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static boolean hasLength(String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean hasText(String string) {
        return string != null && !string.isEmpty() && StringUtils.containsText(string);
    }

    private static boolean containsText(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(charSequence.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static CharSequence trimAllWhitespace(CharSequence charSequence) {
        if (!StringUtils.hasLength(charSequence)) {
            return charSequence;
        }
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (Character.isWhitespace(c2)) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String trimAllWhitespace(String string) {
        if (string == null) {
            return null;
        }
        return StringUtils.trimAllWhitespace((CharSequence)string).toString();
    }

    public static String trimLeadingWhitespace(String string) {
        int n2;
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        for (n2 = 0; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
        }
        return string.substring(n2);
    }

    public static String trimLeadingCharacter(String string, char c2) {
        int n2;
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        for (n2 = 0; n2 < string.length() && c2 == string.charAt(n2); ++n2) {
        }
        return string.substring(n2);
    }

    public static String replace(String string, String string2, String string3) {
        if (!StringUtils.hasLength(string) || !StringUtils.hasLength(string2) || string3 == null) {
            return string;
        }
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.length();
        if (string3.length() > string2.length()) {
            n3 += 16;
        }
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = 0;
        int n5 = string2.length();
        while (n2 >= 0) {
            stringBuilder.append(string, n4, n2);
            stringBuilder.append(string3);
            n4 = n2 + n5;
            n2 = string.indexOf(string2, n4);
        }
        stringBuilder.append(string, n4, string.length());
        return stringBuilder.toString();
    }

    public static String deleteAny(String string, String string2) {
        if (!StringUtils.hasLength(string) || !StringUtils.hasLength(string2)) {
            return string;
        }
        int n2 = 0;
        char[] cArray = new char[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (string2.indexOf(c2) != -1) continue;
            cArray[n2++] = c2;
        }
        if (n2 == string.length()) {
            return string;
        }
        return new String(cArray, 0, n2);
    }

    public static String capitalize(String string) {
        return StringUtils.changeFirstCharacterCase(string, true);
    }

    public static String uncapitalize(String string) {
        return StringUtils.changeFirstCharacterCase(string, false);
    }

    private static String changeFirstCharacterCase(String string, boolean bl2) {
        char c2;
        if (!StringUtils.hasLength(string)) {
            return string;
        }
        char c3 = string.charAt(0);
        if (c3 == (c2 = bl2 ? Character.toUpperCase(c3) : Character.toLowerCase(c3))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = c2;
        return new String(cArray);
    }

    public static Locale parseLocale(String string) {
        String[] stringArray = StringUtils.tokenizeLocaleSource(string);
        if (stringArray.length == 1) {
            StringUtils.validateLocalePart(string);
            Locale locale = Locale.forLanguageTag(string);
            if (locale.getLanguage().length() > 0) {
                return locale;
            }
        }
        return StringUtils.parseLocaleTokens(string, stringArray);
    }

    private static String[] tokenizeLocaleSource(String string) {
        return StringUtils.tokenizeToStringArray(string, "_ ", false, false);
    }

    private static Locale parseLocaleTokens(String string, String[] stringArray) {
        int n2;
        String string2 = stringArray.length > 0 ? stringArray[0] : "";
        String string3 = stringArray.length > 1 ? stringArray[1] : "";
        StringUtils.validateLocalePart(string2);
        StringUtils.validateLocalePart(string3);
        String string4 = "";
        if (stringArray.length > 2 && (string4 = StringUtils.trimLeadingWhitespace(string.substring(n2 = string.indexOf(string3, string2.length()) + string3.length()))).startsWith("_")) {
            string4 = StringUtils.trimLeadingCharacter(string4, '_');
        }
        if (string4.isEmpty() && string3.startsWith("#")) {
            string4 = string3;
            string3 = "";
        }
        return string2.length() > 0 ? new Locale(string2, string3, string4) : null;
    }

    private static void validateLocalePart(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ' || c2 == '_' || c2 == '-' || c2 == '#' || Character.isLetterOrDigit(c2)) continue;
            throw new IllegalArgumentException("Locale part \"" + string + "\" contains invalid characters");
        }
    }

    public static TimeZone parseTimeZoneString(String string) {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        if ("GMT".equals(timeZone.getID()) && !string.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + string + "'");
        }
        return timeZone;
    }

    public static String[] toStringArray(Collection<String> collection) {
        return !CollectionUtils.isEmpty(collection) ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static String[] tokenizeToStringArray(String string, String string2, boolean bl2, boolean bl3) {
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (bl2) {
                string3 = string3.trim();
            }
            if (bl3 && string3.length() <= 0) continue;
            arrayList.add(string3);
        }
        return StringUtils.toStringArray(arrayList);
    }

    public static String[] delimitedListToStringArray(String string, String string2) {
        return StringUtils.delimitedListToStringArray(string, string2, null);
    }

    public static String[] delimitedListToStringArray(String string, String string2, String string3) {
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (string2 == null) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2.isEmpty()) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                arrayList.add(StringUtils.deleteAny(string.substring(i2, i2 + 1), string3));
            }
        } else {
            int n2;
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) != -1) {
                arrayList.add(StringUtils.deleteAny(string.substring(n3, n2), string3));
                n3 = n2 + string2.length();
            }
            if (string.length() > 0 && n3 <= string.length()) {
                arrayList.add(StringUtils.deleteAny(string.substring(n3), string3));
            }
        }
        return StringUtils.toStringArray(arrayList);
    }

    public static String[] commaDelimitedListToStringArray(String string) {
        return StringUtils.delimitedListToStringArray(string, ",");
    }

    public static String collectionToDelimitedString(Collection<?> collection, String string, String string2, String string3) {
        Object object2;
        if (CollectionUtils.isEmpty(collection)) {
            return "";
        }
        int n2 = collection.size() * (string2.length() + string3.length()) + (collection.size() - 1) * string.length();
        for (Object object2 : collection) {
            n2 += String.valueOf(object2).length();
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        object2 = collection.iterator();
        while (object2.hasNext()) {
            stringBuilder.append(string2).append(object2.next()).append(string3);
            if (!object2.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String collectionToDelimitedString(Collection<?> collection, String string) {
        return StringUtils.collectionToDelimitedString(collection, string, "", "");
    }

    public static String collectionToCommaDelimitedString(Collection<?> collection) {
        return StringUtils.collectionToDelimitedString(collection, ",");
    }

    public static String arrayToDelimitedString(Object[] objectArray, String string) {
        if (ObjectUtils.isEmpty(objectArray)) {
            return "";
        }
        if (objectArray.length == 1) {
            return ObjectUtils.nullSafeToString(objectArray[0]);
        }
        StringJoiner stringJoiner = new StringJoiner(string);
        for (Object object : objectArray) {
            stringJoiner.add(String.valueOf(object));
        }
        return stringJoiner.toString();
    }
}

