/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.JWTDecoder;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms.Algorithm;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.IncorrectClaimException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.InvalidClaimException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTVerificationException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.MissingClaimException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.TokenExpiredException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.ExpectedCheckHolder;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.JWTParser;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Claim;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.DecodedJWT;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Verification;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;

public final class JWTVerifier {
    private final Algorithm algorithm;
    final List<ExpectedCheckHolder> expectedChecks;
    private final JWTParser parser;

    JWTVerifier(Algorithm algorithm, List<ExpectedCheckHolder> list) {
        this.algorithm = algorithm;
        this.expectedChecks = Collections.unmodifiableList(list);
        this.parser = new JWTParser();
    }

    static Verification init(Algorithm algorithm) throws IllegalArgumentException {
        return new BaseVerification(algorithm);
    }

    public DecodedJWT verify(String string) throws JWTVerificationException {
        JWTDecoder jWTDecoder = new JWTDecoder(this.parser, string);
        return this.verify(jWTDecoder);
    }

    public DecodedJWT verify(DecodedJWT decodedJWT) throws JWTVerificationException {
        this.verifyAlgorithm(decodedJWT, this.algorithm);
        this.algorithm.verify(decodedJWT);
        this.verifyClaims(decodedJWT, this.expectedChecks);
        return decodedJWT;
    }

    private void verifyAlgorithm(DecodedJWT decodedJWT, Algorithm algorithm) throws AlgorithmMismatchException {
        if (!algorithm.getName().equals(decodedJWT.getAlgorithm())) {
            throw new AlgorithmMismatchException("The provided Algorithm doesn't match the one defined in the JWT's Header.");
        }
    }

    private void verifyClaims(DecodedJWT decodedJWT, List<ExpectedCheckHolder> list) throws TokenExpiredException, InvalidClaimException {
        for (ExpectedCheckHolder expectedCheckHolder : list) {
            String string;
            Claim claim;
            boolean bl2 = expectedCheckHolder.verify(claim = decodedJWT.getClaim(string = expectedCheckHolder.getClaimName()), decodedJWT);
            if (bl2) continue;
            throw new IncorrectClaimException(String.format("The Claim '%s' value doesn't match the required one.", string), string, claim);
        }
    }

    public static class BaseVerification
    implements Verification {
        private final Algorithm algorithm;
        private final List<ExpectedCheckHolder> expectedChecks;
        private long defaultLeeway;
        private final Map<String, Long> customLeeways;
        private boolean ignoreIssuedAt;
        private Clock clock;

        BaseVerification(Algorithm algorithm) throws IllegalArgumentException {
            if (algorithm == null) {
                throw new IllegalArgumentException("The Algorithm cannot be null.");
            }
            this.algorithm = algorithm;
            this.expectedChecks = new ArrayList<ExpectedCheckHolder>();
            this.customLeeways = new HashMap<String, Long>();
            this.defaultLeeway = 0L;
        }

        @Override
        public Verification withSubject(String string) {
            this.addCheck("sub", (claim, decodedJWT) -> this.verifyNull((Claim)claim, string) || string.equals(claim.asString()));
            return this;
        }

        @Override
        public Verification acceptLeeway(long l2) throws IllegalArgumentException {
            this.assertPositive(l2);
            this.defaultLeeway = l2;
            return this;
        }

        @Override
        public JWTVerifier build() {
            return this.build(Clock.systemUTC());
        }

        public JWTVerifier build(Clock clock) {
            this.clock = clock;
            this.addMandatoryClaimChecks();
            return new JWTVerifier(this.algorithm, this.expectedChecks);
        }

        public long getLeewayFor(String string) {
            return this.customLeeways.getOrDefault(string, this.defaultLeeway);
        }

        private void addMandatoryClaimChecks() {
            long l2 = this.getLeewayFor("exp");
            long l3 = this.getLeewayFor("nbf");
            long l4 = this.getLeewayFor("iat");
            this.expectedChecks.add(this.constructExpectedCheck("exp", (claim, decodedJWT) -> this.assertValidInstantClaim("exp", (Claim)claim, l2, true)));
            this.expectedChecks.add(this.constructExpectedCheck("nbf", (claim, decodedJWT) -> this.assertValidInstantClaim("nbf", (Claim)claim, l3, false)));
            if (!this.ignoreIssuedAt) {
                this.expectedChecks.add(this.constructExpectedCheck("iat", (claim, decodedJWT) -> this.assertValidInstantClaim("iat", (Claim)claim, l4, false)));
            }
        }

        private boolean assertValidInstantClaim(String string, Claim claim, long l2, boolean bl2) {
            Instant instant = claim.asInstant();
            Instant instant2 = this.clock.instant().truncatedTo(ChronoUnit.SECONDS);
            if (bl2) {
                boolean bl3 = this.assertInstantIsFuture(instant, l2, instant2);
                if (!bl3) {
                    throw new TokenExpiredException(String.format("The Token has expired on %s.", instant), instant);
                }
            } else {
                boolean bl4 = this.assertInstantIsPast(instant, l2, instant2);
                if (!bl4) {
                    throw new IncorrectClaimException(String.format("The Token can't be used before %s.", instant), string, claim);
                }
            }
            return true;
        }

        private boolean assertInstantIsFuture(Instant instant, long l2, Instant instant2) {
            return instant == null || !instant2.minus(Duration.ofSeconds(l2)).isAfter(instant);
        }

        private boolean assertInstantIsPast(Instant instant, long l2, Instant instant2) {
            return instant == null || !instant2.plus(Duration.ofSeconds(l2)).isBefore(instant);
        }

        private void assertPositive(long l2) {
            if (l2 < 0L) {
                throw new IllegalArgumentException("Leeway value can't be negative.");
            }
        }

        private void addCheck(String string, BiPredicate<Claim, DecodedJWT> biPredicate) {
            this.expectedChecks.add(this.constructExpectedCheck(string, (claim, decodedJWT) -> {
                if (claim.isMissing()) {
                    throw new MissingClaimException(string);
                }
                return biPredicate.test((Claim)claim, (DecodedJWT)decodedJWT);
            }));
        }

        private ExpectedCheckHolder constructExpectedCheck(final String string, final BiPredicate<Claim, DecodedJWT> biPredicate) {
            return new ExpectedCheckHolder(){

                @Override
                public String getClaimName() {
                    return string;
                }

                @Override
                public boolean verify(Claim claim, DecodedJWT decodedJWT) {
                    return biPredicate.test(claim, decodedJWT);
                }
            };
        }

        private boolean verifyNull(Claim claim, Object object) {
            return object == null && claim.isNull();
        }
    }
}

