/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.message;

import com.gradle.maven.extension.internal.dep.org.apache.http.HttpEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponse;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.org.apache.http.ProtocolVersion;
import com.gradle.maven.extension.internal.dep.org.apache.http.ReasonPhraseCatalog;
import com.gradle.maven.extension.internal.dep.org.apache.http.StatusLine;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.AbstractHttpMessage;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.BasicStatusLine;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import java.util.Locale;

public class BasicHttpResponse
extends AbstractHttpMessage
implements HttpResponse {
    private StatusLine statusline;
    private ProtocolVersion ver;
    private int code;
    private String reasonPhrase;
    private HttpEntity entity;
    private final ReasonPhraseCatalog reasonCatalog;
    private Locale locale;

    public BasicHttpResponse(StatusLine statusLine, ReasonPhraseCatalog reasonPhraseCatalog, Locale locale) {
        this.statusline = Args.notNull(statusLine, "Status line");
        this.ver = statusLine.getProtocolVersion();
        this.code = statusLine.getStatusCode();
        this.reasonPhrase = statusLine.getReasonPhrase();
        this.reasonCatalog = reasonPhraseCatalog;
        this.locale = locale;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.ver;
    }

    @Override
    public StatusLine getStatusLine() {
        if (this.statusline == null) {
            this.statusline = new BasicStatusLine(this.ver != null ? this.ver : HttpVersion.HTTP_1_1, this.code, this.reasonPhrase != null ? this.reasonPhrase : this.getReason(this.code));
        }
        return this.statusline;
    }

    @Override
    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(HttpEntity httpEntity) {
        this.entity = httpEntity;
    }

    protected String getReason(int n2) {
        return this.reasonCatalog != null ? this.reasonCatalog.getReason(n2, this.locale != null ? this.locale : Locale.getDefault()) : null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getStatusLine());
        stringBuilder.append(' ');
        stringBuilder.append(this.headergroup);
        if (this.entity != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.entity);
        }
        return stringBuilder.toString();
    }
}

