/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class InstantSerializerBase<T extends Temporal>
extends JSR310FormattedSerializerBase<T> {
    private final DateTimeFormatter defaultFormat;
    private final ToLongFunction<T> getEpochMillis;
    private final ToLongFunction<T> getEpochSeconds;
    private final ToIntFunction<T> getNanoseconds;

    protected InstantSerializerBase(Class<T> clazz, ToLongFunction<T> toLongFunction, ToLongFunction<T> toLongFunction2, ToIntFunction<T> toIntFunction, DateTimeFormatter dateTimeFormatter) {
        super(clazz, null);
        this.defaultFormat = dateTimeFormatter;
        this.getEpochMillis = toLongFunction;
        this.getEpochSeconds = toLongFunction2;
        this.getNanoseconds = toIntFunction;
    }

    protected InstantSerializerBase(InstantSerializerBase<T> instantSerializerBase, Boolean bl2, Boolean bl3, DateTimeFormatter dateTimeFormatter) {
        this(instantSerializerBase, bl2, bl3, dateTimeFormatter, instantSerializerBase._shape);
    }

    protected InstantSerializerBase(InstantSerializerBase<T> instantSerializerBase, Boolean bl2, Boolean bl3, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        super(instantSerializerBase, bl2, bl3, dateTimeFormatter, shape);
        this.defaultFormat = instantSerializerBase.defaultFormat;
        this.getEpochMillis = instantSerializerBase.getEpochMillis;
        this.getEpochSeconds = instantSerializerBase.getEpochSeconds;
        this.getNanoseconds = instantSerializerBase.getNanoseconds;
    }

    @Override
    protected abstract JSR310FormattedSerializerBase<?> withFormat(Boolean var1, DateTimeFormatter var2, JsonFormat.Shape var3);

    @Override
    public void serialize(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            if (this.useNanoseconds(serializerProvider)) {
                jsonGenerator.writeNumber(DecimalUtils.toBigDecimal(this.getEpochSeconds.applyAsLong(t2), this.getNanoseconds.applyAsInt(t2)));
                return;
            }
            jsonGenerator.writeNumber(this.getEpochMillis.applyAsLong(t2));
            return;
        }
        jsonGenerator.writeString(this.formatValue(t2, serializerProvider));
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        if (this.useNanoseconds(jsonFormatVisitorWrapper.getProvider())) {
            JsonNumberFormatVisitor jsonNumberFormatVisitor = jsonFormatVisitorWrapper.expectNumberFormat(javaType);
            if (jsonNumberFormatVisitor != null) {
                jsonNumberFormatVisitor.numberType(JsonParser.NumberType.BIG_DECIMAL);
            }
        } else {
            JsonIntegerFormatVisitor jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType);
            if (jsonIntegerFormatVisitor != null) {
                jsonIntegerFormatVisitor.numberType(JsonParser.NumberType.LONG);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        if (this.useTimestamp(serializerProvider)) {
            if (this.useNanoseconds(serializerProvider)) {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            return JsonToken.VALUE_NUMBER_INT;
        }
        return JsonToken.VALUE_STRING;
    }

    protected String formatValue(T t2, SerializerProvider serializerProvider) {
        DateTimeFormatter dateTimeFormatter;
        DateTimeFormatter dateTimeFormatter2 = dateTimeFormatter = this._formatter != null ? this._formatter : this.defaultFormat;
        if (dateTimeFormatter != null) {
            if (dateTimeFormatter.getZone() == null && serializerProvider.getConfig().hasExplicitTimeZone() && serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_WITH_CONTEXT_TIME_ZONE)) {
                dateTimeFormatter = dateTimeFormatter.withZone(serializerProvider.getTimeZone().toZoneId());
            }
            return dateTimeFormatter.format((TemporalAccessor)t2);
        }
        return t2.toString();
    }
}

