package com.gradle.maven.extension.api.scan;

import java.net.URI;

/**
 * A reference to a published build scan.
 *
 * @since 1.2
 */
public interface PublishedBuildScan {

    /**
     * The ID of the build scan.
     * <p>
     * Example: "bzoxfqz2pcmk4".
     *
     * @return the ID of the build scan
     */
    String getBuildScanId();

    /**
     * The complete address of the build scan.
     * <p>
     * Example: "https://my-server/s/bzoxfqz2pcmk4".
     *
     * @return the complete address of the build scan.
     */
    URI getBuildScanUri();

}
