/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.hash;

import com.gradle.maven.extension.internal.dep.com.google.common.hash.AbstractHashFunction;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.AbstractStreamingHasher;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.HashCode;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.HashFunction;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.Hasher;
import com.gradle.maven.extension.internal.dep.com.google.common.hash.Hashing;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class Murmur3_128HashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction MURMUR3_128 = new Murmur3_128HashFunction(0);
    static final HashFunction GOOD_FAST_HASH_128 = new Murmur3_128HashFunction(Hashing.GOOD_FAST_HASH_SEED);
    private final int seed;

    Murmur3_128HashFunction(int n2) {
        this.seed = n2;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_128Hasher(this.seed);
    }

    public String toString() {
        return "Hashing.murmur3_128(" + this.seed + ")";
    }

    public boolean equals(Object object) {
        if (object instanceof Murmur3_128HashFunction) {
            Murmur3_128HashFunction murmur3_128HashFunction = (Murmur3_128HashFunction)object;
            return this.seed == murmur3_128HashFunction.seed;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    private static final class Murmur3_128Hasher
    extends AbstractStreamingHasher {
        private long h1;
        private long h2;
        private int length;

        Murmur3_128Hasher(int n2) {
            super(16);
            this.h1 = n2;
            this.h2 = n2;
            this.length = 0;
        }

        @Override
        protected void process(ByteBuffer byteBuffer) {
            long l2 = byteBuffer.getLong();
            long l3 = byteBuffer.getLong();
            this.bmix64(l2, l3);
            this.length += 16;
        }

        private void bmix64(long l2, long l3) {
            this.h1 ^= Murmur3_128Hasher.mixK1(l2);
            this.h1 = Long.rotateLeft(this.h1, 27);
            this.h1 += this.h2;
            this.h1 = this.h1 * 5L + 1390208809L;
            this.h2 ^= Murmur3_128Hasher.mixK2(l3);
            this.h2 = Long.rotateLeft(this.h2, 31);
            this.h2 += this.h1;
            this.h2 = this.h2 * 5L + 944331445L;
        }

        @Override
        protected void processRemaining(ByteBuffer byteBuffer) {
            long l2 = 0L;
            long l3 = 0L;
            this.length += byteBuffer.remaining();
            switch (byteBuffer.remaining()) {
                case 15: {
                    l3 ^= (long)UnsignedBytes.toInt(byteBuffer.get(14)) << 48;
                }
                case 14: {
                    l3 ^= (long)UnsignedBytes.toInt(byteBuffer.get(13)) << 40;
                }
                case 13: {
                    l3 ^= (long)UnsignedBytes.toInt(byteBuffer.get(12)) << 32;
                }
                case 12: {
                    l3 ^= (long)UnsignedBytes.toInt(byteBuffer.get(11)) << 24;
                }
                case 11: {
                    l3 ^= (long)UnsignedBytes.toInt(byteBuffer.get(10)) << 16;
                }
                case 10: {
                    l3 ^= (long)UnsignedBytes.toInt(byteBuffer.get(9)) << 8;
                }
                case 9: {
                    l3 ^= (long)UnsignedBytes.toInt(byteBuffer.get(8));
                }
                case 8: {
                    l2 ^= byteBuffer.getLong();
                    break;
                }
                case 7: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(6)) << 48;
                }
                case 6: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(5)) << 40;
                }
                case 5: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(4)) << 32;
                }
                case 4: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(3)) << 24;
                }
                case 3: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(2)) << 16;
                }
                case 2: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(1)) << 8;
                }
                case 1: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(0));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
            this.h1 ^= Murmur3_128Hasher.mixK1(l2);
            this.h2 ^= Murmur3_128Hasher.mixK2(l3);
        }

        @Override
        protected HashCode makeHash() {
            this.h1 ^= (long)this.length;
            this.h2 ^= (long)this.length;
            this.h1 += this.h2;
            this.h2 += this.h1;
            this.h1 = Murmur3_128Hasher.fmix64(this.h1);
            this.h2 = Murmur3_128Hasher.fmix64(this.h2);
            this.h1 += this.h2;
            this.h2 += this.h1;
            return HashCode.fromBytesNoCopy(ByteBuffer.wrap(new byte[16]).order(ByteOrder.LITTLE_ENDIAN).putLong(this.h1).putLong(this.h2).array());
        }

        private static long fmix64(long l2) {
            l2 ^= l2 >>> 33;
            l2 *= -49064778989728563L;
            l2 ^= l2 >>> 33;
            l2 *= -4265267296055464877L;
            l2 ^= l2 >>> 33;
            return l2;
        }

        private static long mixK1(long l2) {
            l2 *= -8663945395140668459L;
            l2 = Long.rotateLeft(l2, 31);
            return l2 *= 5545529020109919103L;
        }

        private static long mixK2(long l2) {
            l2 *= 5545529020109919103L;
            l2 = Long.rotateLeft(l2, 33);
            return l2 *= -8663945395140668459L;
        }
    }
}

