/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpChannel;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpResponse;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpResponseException;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpConnectionUpgrader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.http.HttpSenderOverHTTP;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeaderValue;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpStatus;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpVersion;
import java.util.Locale;
import java.util.concurrent.atomic.LongAdder;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;
    private final LongAdder outMessages = new LongAdder();

    public HttpChannelOverHTTP(HttpConnectionOverHTTP httpConnectionOverHTTP) {
        super(httpConnectionOverHTTP.getHttpDestination());
        this.connection = httpConnectionOverHTTP;
        this.sender = this.newHttpSender();
        this.receiver = this.newHttpReceiver();
    }

    protected HttpSenderOverHTTP newHttpSender() {
        return new HttpSenderOverHTTP(this);
    }

    protected HttpReceiverOverHTTP newHttpReceiver() {
        return new HttpReceiverOverHTTP(this);
    }

    @Override
    protected HttpSenderOverHTTP getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiverOverHTTP getHttpReceiver() {
        return this.receiver;
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send(HttpExchange httpExchange) {
        this.outMessages.increment();
        this.sender.send(httpExchange);
    }

    @Override
    public void release() {
        this.connection.release();
    }

    @Override
    public Result exchangeTerminating(HttpExchange httpExchange, Result result) {
        if (result.isFailed()) {
            return result;
        }
        HttpResponse httpResponse = httpExchange.getResponse();
        if (httpResponse.getVersion() == HttpVersion.HTTP_1_1 && httpResponse.getStatus() == 101) {
            String string = httpResponse.getHeaders().get(HttpHeader.CONNECTION);
            if (string == null || !string.toLowerCase(Locale.US).contains("upgrade")) {
                return new Result(result, new HttpResponseException("101 Switching Protocols without Connection: Upgrade not supported", httpResponse));
            }
            HttpRequest httpRequest = httpExchange.getRequest();
            HttpConnectionUpgrader httpConnectionUpgrader = (HttpConnectionUpgrader)httpRequest.getConversation().getAttribute(HttpConnectionUpgrader.class.getName());
            if (httpConnectionUpgrader != null) {
                try {
                    httpConnectionUpgrader.upgrade(httpResponse, this.getHttpConnection());
                }
                catch (Throwable throwable) {
                    return new Result(result, throwable);
                }
            }
        }
        return result;
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(HttpExchange httpExchange, Result result) {
        int n2;
        super.exchangeTerminated(httpExchange, result);
        String string = httpExchange.getRequest().getMethod();
        Response response = result.getResponse();
        HttpFields httpFields = response.getHeaders();
        String string2 = null;
        if (result.isFailed()) {
            string2 = "failure";
        } else if (this.receiver.isShutdown()) {
            string2 = "server close";
        } else if (this.sender.isShutdown()) {
            string2 = "client close";
        }
        if (string2 == null) {
            if (response.getVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
                n2 = httpFields.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString()) ? 1 : 0;
                boolean bl2 = HttpMethod.CONNECT.is(string);
                if (n2 == 0 && !bl2) {
                    string2 = "http/1.0";
                }
            } else if (httpFields.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
                string2 = "http/1.1";
            }
        }
        if (string2 != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing, reason: {} - {}", string2, this.connection);
            }
            this.connection.close();
        } else {
            n2 = response.getStatus();
            if (n2 == 101 || this.isTunnel(string, n2)) {
                this.connection.remove();
            } else {
                this.release();
            }
        }
    }

    boolean isTunnel(String string, int n2) {
        return HttpMethod.CONNECT.is(string) && HttpStatus.isSuccess(n2);
    }

    @Override
    public String toString() {
        return String.format("%s[send=%s,recv=%s]", super.toString(), this.sender, this.receiver);
    }
}

