/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.Locale;

public abstract class BufferingResponseListener
extends Response.Listener.Adapter {
    private final int maxLength;
    private ByteBuffer buffer;
    private String mediaType;
    private String encoding;

    public BufferingResponseListener() {
        this(0x200000);
    }

    public BufferingResponseListener(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid max length " + n2);
        }
        this.maxLength = n2;
    }

    @Override
    public void onHeaders(Response response) {
        super.onHeaders(response);
        Request request = response.getRequest();
        HttpFields httpFields = response.getHeaders();
        long l2 = httpFields.getLongField(HttpHeader.CONTENT_LENGTH.asString());
        if (HttpMethod.HEAD.is(request.getMethod())) {
            l2 = 0L;
        }
        if (l2 > (long)this.maxLength) {
            response.abort(new IllegalArgumentException("Buffering capacity " + this.maxLength + " exceeded"));
            return;
        }
        String string = httpFields.get(HttpHeader.CONTENT_TYPE);
        if (string != null) {
            int n2;
            String string2 = string;
            String string3 = "charset=";
            int n3 = string.toLowerCase(Locale.ENGLISH).indexOf(string3);
            if (n3 > 0) {
                string2 = string.substring(0, n3);
                String string4 = string.substring(n3 + string3.length());
                int n4 = string4.indexOf(59);
                if (n4 > 0) {
                    string4 = string4.substring(0, n4).trim();
                }
                int n5 = string4.length() - 1;
                if (string4.charAt(0) == '\"' && string4.charAt(n5) == '\"') {
                    string4 = string4.substring(1, n5).trim();
                }
                this.encoding = string4;
            }
            if ((n2 = string2.indexOf(59)) > 0) {
                string2 = string2.substring(0, n2).trim();
            }
            this.mediaType = string2;
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        if (n2 > BufferUtil.space(this.buffer)) {
            int n3;
            int n4 = n3 = this.buffer == null ? 0 : this.buffer.remaining();
            if (n3 + n2 > this.maxLength) {
                response.abort(new IllegalArgumentException("Buffering capacity " + this.maxLength + " exceeded"));
            }
            int n5 = this.buffer == null ? n2 : this.buffer.capacity() + n2;
            int n6 = Math.min(Integer.highestOneBit(n5) << 1, this.maxLength);
            this.buffer = BufferUtil.ensureCapacity(this.buffer, n6);
        }
        BufferUtil.append(this.buffer, byteBuffer);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getContent() {
        if (this.buffer == null) {
            return new byte[0];
        }
        return BufferUtil.toArray(this.buffer);
    }
}

