/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.objectweb.asm;

import com.gradle.maven.extension.internal.dep.org.objectweb.asm.AnnotationVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ByteVector;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.Symbol;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.SymbolTable;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.Type;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.TypePath;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.TypeReference;

final class AnnotationWriter
extends AnnotationVisitor {
    private final SymbolTable symbolTable;
    private final boolean useNamedValues;
    private final ByteVector annotation;
    private final int numElementValuePairsOffset;
    private int numElementValuePairs;
    private final AnnotationWriter previousAnnotation;
    private AnnotationWriter nextAnnotation;

    AnnotationWriter(SymbolTable symbolTable, boolean bl2, ByteVector byteVector, AnnotationWriter annotationWriter) {
        super(589824);
        this.symbolTable = symbolTable;
        this.useNamedValues = bl2;
        this.annotation = byteVector;
        this.numElementValuePairsOffset = byteVector.length == 0 ? -1 : byteVector.length - 2;
        this.previousAnnotation = annotationWriter;
        if (annotationWriter != null) {
            annotationWriter.nextAnnotation = this;
        }
    }

    static AnnotationWriter create(SymbolTable symbolTable, String string, AnnotationWriter annotationWriter) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(symbolTable.addConstantUtf8(string)).putShort(0);
        return new AnnotationWriter(symbolTable, true, byteVector, annotationWriter);
    }

    static AnnotationWriter create(SymbolTable symbolTable, int n2, TypePath typePath, String string, AnnotationWriter annotationWriter) {
        ByteVector byteVector = new ByteVector();
        TypeReference.putTarget(n2, byteVector);
        TypePath.put(typePath, byteVector);
        byteVector.putShort(symbolTable.addConstantUtf8(string)).putShort(0);
        return new AnnotationWriter(symbolTable, true, byteVector, annotationWriter);
    }

    public void visit(String string, Object object) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        if (object instanceof String) {
            this.annotation.put12(115, this.symbolTable.addConstantUtf8((String)object));
        } else if (object instanceof Byte) {
            this.annotation.put12(66, this.symbolTable.addConstantInteger((int)((Byte)object).byteValue()).index);
        } else if (object instanceof Boolean) {
            int n2 = (Boolean)object != false ? 1 : 0;
            this.annotation.put12(90, this.symbolTable.addConstantInteger((int)n2).index);
        } else if (object instanceof Character) {
            this.annotation.put12(67, this.symbolTable.addConstantInteger((int)((Character)object).charValue()).index);
        } else if (object instanceof Short) {
            this.annotation.put12(83, this.symbolTable.addConstantInteger((int)((Short)object).shortValue()).index);
        } else if (object instanceof Type) {
            this.annotation.put12(99, this.symbolTable.addConstantUtf8(((Type)object).getDescriptor()));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.annotation.put12(91, byArray.length);
            for (byte by2 : byArray) {
                this.annotation.put12(66, this.symbolTable.addConstantInteger((int)by2).index);
            }
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            this.annotation.put12(91, blArray.length);
            for (boolean bl2 : blArray) {
                this.annotation.put12(90, this.symbolTable.addConstantInteger((int)(bl2 ? 1 : 0)).index);
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            this.annotation.put12(91, sArray.length);
            for (short s2 : sArray) {
                this.annotation.put12(83, this.symbolTable.addConstantInteger((int)s2).index);
            }
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            this.annotation.put12(91, cArray.length);
            for (char c2 : cArray) {
                this.annotation.put12(67, this.symbolTable.addConstantInteger((int)c2).index);
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            this.annotation.put12(91, nArray.length);
            for (int n3 : nArray) {
                this.annotation.put12(73, this.symbolTable.addConstantInteger((int)n3).index);
            }
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            this.annotation.put12(91, lArray.length);
            for (long l2 : lArray) {
                this.annotation.put12(74, this.symbolTable.addConstantLong((long)l2).index);
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            this.annotation.put12(91, fArray.length);
            for (float f2 : fArray) {
                this.annotation.put12(70, this.symbolTable.addConstantFloat((float)f2).index);
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            this.annotation.put12(91, dArray.length);
            for (double d2 : dArray) {
                this.annotation.put12(68, this.symbolTable.addConstantDouble((double)d2).index);
            }
        } else {
            Symbol symbol = this.symbolTable.addConstant(object);
            this.annotation.put12(".s.IFJDCS".charAt(symbol.tag), symbol.index);
        }
    }

    public void visitEnum(String string, String string2, String string3) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        this.annotation.put12(101, this.symbolTable.addConstantUtf8(string2)).putShort(this.symbolTable.addConstantUtf8(string3));
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        this.annotation.put12(64, this.symbolTable.addConstantUtf8(string2)).putShort(0);
        return new AnnotationWriter(this.symbolTable, true, this.annotation, null);
    }

    public AnnotationVisitor visitArray(String string) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(string));
        }
        this.annotation.put12(91, 0);
        return new AnnotationWriter(this.symbolTable, false, this.annotation, null);
    }

    public void visitEnd() {
        if (this.numElementValuePairsOffset != -1) {
            byte[] byArray = this.annotation.data;
            byArray[this.numElementValuePairsOffset] = (byte)(this.numElementValuePairs >>> 8);
            byArray[this.numElementValuePairsOffset + 1] = (byte)this.numElementValuePairs;
        }
    }

    int computeAnnotationsSize(String string) {
        if (string != null) {
            this.symbolTable.addConstantUtf8(string);
        }
        int n2 = 8;
        AnnotationWriter annotationWriter = this;
        while (annotationWriter != null) {
            n2 += annotationWriter.annotation.length;
            annotationWriter = annotationWriter.previousAnnotation;
        }
        return n2;
    }

    static int computeAnnotationsSize(AnnotationWriter annotationWriter, AnnotationWriter annotationWriter2, AnnotationWriter annotationWriter3, AnnotationWriter annotationWriter4) {
        int n2 = 0;
        if (annotationWriter != null) {
            n2 += annotationWriter.computeAnnotationsSize("RuntimeVisibleAnnotations");
        }
        if (annotationWriter2 != null) {
            n2 += annotationWriter2.computeAnnotationsSize("RuntimeInvisibleAnnotations");
        }
        if (annotationWriter3 != null) {
            n2 += annotationWriter3.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
        }
        if (annotationWriter4 != null) {
            n2 += annotationWriter4.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
        }
        return n2;
    }

    void putAnnotations(int n2, ByteVector byteVector) {
        int n3 = 2;
        int n4 = 0;
        AnnotationWriter annotationWriter = this;
        AnnotationWriter annotationWriter2 = null;
        while (annotationWriter != null) {
            annotationWriter.visitEnd();
            n3 += annotationWriter.annotation.length;
            ++n4;
            annotationWriter2 = annotationWriter;
            annotationWriter = annotationWriter.previousAnnotation;
        }
        byteVector.putShort(n2);
        byteVector.putInt(n3);
        byteVector.putShort(n4);
        annotationWriter = annotationWriter2;
        while (annotationWriter != null) {
            byteVector.putByteArray(annotationWriter.annotation.data, 0, annotationWriter.annotation.length);
            annotationWriter = annotationWriter.nextAnnotation;
        }
    }

    static void putAnnotations(SymbolTable symbolTable, AnnotationWriter annotationWriter, AnnotationWriter annotationWriter2, AnnotationWriter annotationWriter3, AnnotationWriter annotationWriter4, ByteVector byteVector) {
        if (annotationWriter != null) {
            annotationWriter.putAnnotations(symbolTable.addConstantUtf8("RuntimeVisibleAnnotations"), byteVector);
        }
        if (annotationWriter2 != null) {
            annotationWriter2.putAnnotations(symbolTable.addConstantUtf8("RuntimeInvisibleAnnotations"), byteVector);
        }
        if (annotationWriter3 != null) {
            annotationWriter3.putAnnotations(symbolTable.addConstantUtf8("RuntimeVisibleTypeAnnotations"), byteVector);
        }
        if (annotationWriter4 != null) {
            annotationWriter4.putAnnotations(symbolTable.addConstantUtf8("RuntimeInvisibleTypeAnnotations"), byteVector);
        }
    }

    static int computeParameterAnnotationsSize(String string, AnnotationWriter[] annotationWriterArray, int n2) {
        int n3 = 7 + 2 * n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            AnnotationWriter annotationWriter = annotationWriterArray[i2];
            n3 += annotationWriter == null ? 0 : annotationWriter.computeAnnotationsSize(string) - 8;
        }
        return n3;
    }

    static void putParameterAnnotations(int n2, AnnotationWriter[] annotationWriterArray, int n3, ByteVector byteVector) {
        AnnotationWriter annotationWriter;
        int n4;
        int n5 = 1 + 2 * n3;
        for (n4 = 0; n4 < n3; ++n4) {
            annotationWriter = annotationWriterArray[n4];
            n5 += annotationWriter == null ? 0 : annotationWriter.computeAnnotationsSize(null) - 8;
        }
        byteVector.putShort(n2);
        byteVector.putInt(n5);
        byteVector.putByte(n3);
        for (n4 = 0; n4 < n3; ++n4) {
            annotationWriter = annotationWriterArray[n4];
            AnnotationWriter annotationWriter2 = null;
            int n6 = 0;
            while (annotationWriter != null) {
                annotationWriter.visitEnd();
                ++n6;
                annotationWriter2 = annotationWriter;
                annotationWriter = annotationWriter.previousAnnotation;
            }
            byteVector.putShort(n6);
            annotationWriter = annotationWriter2;
            while (annotationWriter != null) {
                byteVector.putByteArray(annotationWriter.annotation.data, 0, annotationWriter.annotation.length);
                annotationWriter = annotationWriter.nextAnnotation;
            }
        }
    }
}

