/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.remote.internal.inet.InetAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetAddressFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object lock = new Object();
    private List<InetAddress> communicationAddresses;
    private InetAddress localBindingAddress;
    private InetAddresses inetAddresses;
    private boolean initialized;
    private String hostName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostname() {
        Object object = this.lock;
        synchronized (object) {
            if (this.hostName == null) {
                try {
                    this.hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    this.hostName = this.getCommunicationAddresses().get(0).toString();
                }
            }
            return this.hostName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InetAddress> getCommunicationAddresses() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                return this.communicationAddresses;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not determine the local IP addresses for this machine.", exception);
        }
    }

    private void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.inetAddresses == null) {
            this.inetAddresses = new InetAddresses();
        }
        this.localBindingAddress = new InetSocketAddress(0).getAddress();
        this.findCommunicationAddresses();
    }

    private void findCommunicationAddresses() throws UnknownHostException {
        this.communicationAddresses = new ArrayList<InetAddress>();
        if (this.inetAddresses.getLoopback().isEmpty()) {
            if (this.inetAddresses.getRemote().isEmpty()) {
                InetAddress inetAddress = InetAddress.getByName(null);
                this.logger.debug("No loopback addresses, using fallback {}", (Object)inetAddress);
                this.communicationAddresses.add(inetAddress);
            } else {
                this.logger.debug("No loopback addresses, using remote addresses instead.");
                this.communicationAddresses.addAll(this.inetAddresses.getRemote());
            }
        } else {
            this.communicationAddresses.addAll(this.inetAddresses.getLoopback());
        }
    }
}

