/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Claim;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

class JsonNodeClaim
implements Claim {
    private final ObjectReader objectReader;
    private final JsonNode data;

    private JsonNodeClaim(JsonNode jsonNode, ObjectReader objectReader) {
        this.data = jsonNode;
        this.objectReader = objectReader;
    }

    @Override
    public String asString() {
        return this.isMissing() || this.isNull() || !this.data.isTextual() ? null : this.data.asText();
    }

    @Override
    public Date asDate() {
        if (this.isMissing() || this.isNull() || !this.data.canConvertToLong()) {
            return null;
        }
        long l2 = this.data.asLong();
        return new Date(l2 * 1000L);
    }

    @Override
    public Instant asInstant() {
        if (this.isMissing() || this.isNull() || !this.data.canConvertToLong()) {
            return null;
        }
        long l2 = this.data.asLong();
        return Instant.ofEpochSecond(l2);
    }

    @Override
    public <T> List<T> asList(Class<T> clazz) throws JWTDecodeException {
        if (this.isMissing() || this.isNull() || !this.data.isArray()) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            try {
                arrayList.add(this.objectReader.treeToValue(this.data.get(i2), clazz));
                continue;
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to " + clazz.getSimpleName(), jsonProcessingException);
            }
        }
        return arrayList;
    }

    @Override
    public boolean isNull() {
        return !this.isMissing() && this.data.isNull();
    }

    @Override
    public boolean isMissing() {
        return this.data == null || this.data.isMissingNode();
    }

    public String toString() {
        if (this.isMissing()) {
            return "Missing claim";
        }
        if (this.isNull()) {
            return "Null claim";
        }
        return this.data.toString();
    }

    static Claim extractClaim(String string, Map<String, JsonNode> map, ObjectReader objectReader) {
        JsonNode jsonNode = map.get(string);
        return JsonNodeClaim.claimFromNode(jsonNode, objectReader);
    }

    static Claim claimFromNode(JsonNode jsonNode, ObjectReader objectReader) {
        return new JsonNodeClaim(jsonNode, objectReader);
    }
}

