/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Loader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Uptime;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.StdErrLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Log {
    public static String __logClass;
    public static boolean __ignored;
    protected static final Properties __props;
    private static final ConcurrentMap<String, Logger> __loggers;
    private static boolean __initialized;
    private static Logger LOG;

    private static void loadProperties(String string, Properties properties) {
        URL uRL = Loader.getResource(string);
        if (uRL != null) {
            try (InputStream inputStream = uRL.openStream();){
                Properties properties2 = new Properties();
                properties2.load(inputStream);
                for (Object object : properties2.keySet()) {
                    Object object2 = properties2.get(object);
                    if (object2 == null) continue;
                    properties.put(object, object2);
                }
            }
            catch (IOException iOException) {
                System.err.println("[WARN] Error loading logging config: " + uRL);
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialized() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (__initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            __initialized = true;
            boolean bl2 = Boolean.parseBoolean(__props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.announce", "true"));
            try {
                Class clazz2 = Loader.loadClass(Log.class, __logClass);
                if (LOG == null || !LOG.getClass().equals(clazz2)) {
                    LOG = (Logger)clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (bl2) {
                        LOG.debug("Logging to {} via {}", LOG, clazz2.getName());
                    }
                }
            }
            catch (Throwable throwable) {
                Log.initStandardLogging(throwable);
            }
            if (bl2 && LOG != null) {
                LOG.info(String.format("Logging initialized @%dms to %s", Uptime.getUptime(), LOG.getClass().getName()), new Object[0]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Objects.requireNonNull(LOG, "Root Logger may not be null");
            return;
        }
    }

    private static void initStandardLogging(Throwable throwable) {
        if (__ignored) {
            throwable.printStackTrace();
        }
        if (LOG == null) {
            LOG = new StdErrLog();
        }
    }

    public static Logger getRootLogger() {
        Log.initialized();
        return LOG;
    }

    static boolean isIgnored() {
        return __ignored;
    }

    public static Logger getLogger(Class<?> clazz) {
        return Log.getLogger(clazz.getName());
    }

    public static Logger getLogger(String string) {
        Log.initialized();
        Logger logger = null;
        if (string == null) {
            logger = LOG;
        }
        if (logger == null) {
            logger = (Logger)__loggers.get(string);
        }
        if (logger == null && LOG != null) {
            logger = LOG.getLogger(string);
        }
        Objects.requireNonNull(logger, "Logger with name [" + string + "]");
        return logger;
    }

    static ConcurrentMap<String, Logger> getMutableLoggers() {
        return __loggers;
    }

    public static Map<String, Logger> getLoggers() {
        return Collections.unmodifiableMap(__loggers);
    }

    static {
        __props = new Properties();
        __loggers = new ConcurrentHashMap<String, Logger>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Log.loadProperties("jetty-logging.properties", __props);
                String string = System.getProperty("os.name");
                if (string != null && string.length() > 0) {
                    string = string.toLowerCase(Locale.ENGLISH).replace(' ', '-');
                    Log.loadProperties("jetty-logging-" + string + ".properties", __props);
                }
                Enumeration<?> enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = System.getProperty(string2);
                    if (string3 == null) continue;
                    __props.setProperty(string2, string3);
                }
                __logClass = __props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.class", "com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Slf4jLog");
                __ignored = Boolean.parseBoolean(__props.getProperty("com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.IGNORED", "false"));
                return null;
            }
        });
    }
}

