/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core;

import com.gradle.maven.extension.internal.dep.org.springframework.core.KotlinDetector;
import com.gradle.maven.extension.internal.dep.org.springframework.core.ParameterNameDiscoverer;
import com.gradle.maven.extension.internal.dep.org.springframework.core.ResolvableType;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import kotlin.Unit;
import kotlin.reflect.KFunction;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;

public class MethodParameter {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Executable executable;
    private final int parameterIndex;
    private volatile Parameter parameter;
    private int nestingLevel;
    Map<Integer, Integer> typeIndexesPerLevel;
    private volatile Class<?> containingClass;
    private volatile Class<?> parameterType;
    private volatile Type genericParameterType;
    private volatile Annotation[] parameterAnnotations;
    private volatile ParameterNameDiscoverer parameterNameDiscoverer;
    private volatile String parameterName;

    public MethodParameter(Method method, int n2) {
        this(method, n2, 1);
    }

    public MethodParameter(Method method, int n2, int n3) {
        Assert.notNull((Object)method, "Method must not be null");
        this.executable = method;
        this.parameterIndex = MethodParameter.validateIndex(method, n2);
        this.nestingLevel = n3;
    }

    public MethodParameter(Constructor<?> constructor, int n2) {
        this(constructor, n2, 1);
    }

    public MethodParameter(Constructor<?> constructor, int n2, int n3) {
        Assert.notNull(constructor, "Constructor must not be null");
        this.executable = constructor;
        this.parameterIndex = MethodParameter.validateIndex(constructor, n2);
        this.nestingLevel = n3;
    }

    MethodParameter(Executable executable, int n2, Class<?> clazz) {
        Assert.notNull((Object)executable, "Executable must not be null");
        this.executable = executable;
        this.parameterIndex = MethodParameter.validateIndex(executable, n2);
        this.nestingLevel = 1;
        this.containingClass = clazz;
    }

    public MethodParameter(MethodParameter methodParameter) {
        Assert.notNull((Object)methodParameter, "Original must not be null");
        this.executable = methodParameter.executable;
        this.parameterIndex = methodParameter.parameterIndex;
        this.parameter = methodParameter.parameter;
        this.nestingLevel = methodParameter.nestingLevel;
        this.typeIndexesPerLevel = methodParameter.typeIndexesPerLevel;
        this.containingClass = methodParameter.containingClass;
        this.parameterType = methodParameter.parameterType;
        this.genericParameterType = methodParameter.genericParameterType;
        this.parameterAnnotations = methodParameter.parameterAnnotations;
        this.parameterNameDiscoverer = methodParameter.parameterNameDiscoverer;
        this.parameterName = methodParameter.parameterName;
    }

    public Method getMethod() {
        return this.executable instanceof Method ? (Method)this.executable : null;
    }

    public Class<?> getDeclaringClass() {
        return this.executable.getDeclaringClass();
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.executable;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public Integer getTypeIndexForLevel(int n2) {
        return this.getTypeIndexesPerLevel().get(n2);
    }

    private Map<Integer, Integer> getTypeIndexesPerLevel() {
        if (this.typeIndexesPerLevel == null) {
            this.typeIndexesPerLevel = new HashMap<Integer, Integer>(4);
        }
        return this.typeIndexesPerLevel;
    }

    public MethodParameter withContainingClass(Class<?> clazz) {
        MethodParameter methodParameter = this.clone();
        methodParameter.containingClass = clazz;
        methodParameter.parameterType = null;
        return methodParameter;
    }

    public Class<?> getContainingClass() {
        Class<?> clazz = this.containingClass;
        return clazz != null ? clazz : this.getDeclaringClass();
    }

    public Class<?> getParameterType() {
        Class<?> clazz = this.parameterType;
        if (clazz != null) {
            return clazz;
        }
        if (this.getContainingClass() != this.getDeclaringClass()) {
            clazz = ResolvableType.forMethodParameter(this, null, 1).resolve();
        }
        if (clazz == null) {
            clazz = this.computeParameterType();
        }
        this.parameterType = clazz;
        return clazz;
    }

    public Type getGenericParameterType() {
        Class<Void> clazz = this.genericParameterType;
        if (clazz == null) {
            if (this.parameterIndex < 0) {
                Method method = this.getMethod();
                clazz = method != null ? (KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(this.getContainingClass()) ? KotlinDelegate.getGenericReturnType(method) : method.getGenericReturnType()) : Void.TYPE;
            } else {
                Type[] typeArray = this.executable.getGenericParameterTypes();
                int n2 = this.parameterIndex;
                if (this.executable instanceof Constructor && ClassUtils.isInnerClass(this.executable.getDeclaringClass()) && typeArray.length == this.executable.getParameterCount() - 1) {
                    n2 = this.parameterIndex - 1;
                }
                clazz = n2 >= 0 && n2 < typeArray.length ? typeArray[n2] : this.computeParameterType();
            }
            this.genericParameterType = clazz;
        }
        return clazz;
    }

    private Class<?> computeParameterType() {
        if (this.parameterIndex < 0) {
            Method method = this.getMethod();
            if (method == null) {
                return Void.TYPE;
            }
            if (KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(this.getContainingClass())) {
                return KotlinDelegate.getReturnType(method);
            }
            return method.getReturnType();
        }
        return this.executable.getParameterTypes()[this.parameterIndex];
    }

    public Class<?> getNestedParameterType() {
        if (this.nestingLevel > 1) {
            Type type;
            Type type2 = this.getGenericParameterType();
            for (int i2 = 2; i2 <= this.nestingLevel; ++i2) {
                if (!(type2 instanceof ParameterizedType)) continue;
                Type[] typeArray = ((ParameterizedType)type2).getActualTypeArguments();
                Integer n2 = this.getTypeIndexForLevel(i2);
                type2 = typeArray[n2 != null ? n2 : typeArray.length - 1];
            }
            if (type2 instanceof Class) {
                return (Class)type2;
            }
            if (type2 instanceof ParameterizedType && (type = ((ParameterizedType)type2).getRawType()) instanceof Class) {
                return (Class)type;
            }
            return Object.class;
        }
        return this.getParameterType();
    }

    public Annotation[] getMethodAnnotations() {
        return this.adaptAnnotationArray(this.getAnnotatedElement().getAnnotations());
    }

    public Annotation[] getParameterAnnotations() {
        Annotation[] annotationArray = this.parameterAnnotations;
        if (annotationArray == null) {
            Annotation[][] annotationArray2 = this.executable.getParameterAnnotations();
            int n2 = this.parameterIndex;
            if (this.executable instanceof Constructor && ClassUtils.isInnerClass(this.executable.getDeclaringClass()) && annotationArray2.length == this.executable.getParameterCount() - 1) {
                n2 = this.parameterIndex - 1;
            }
            annotationArray = n2 >= 0 && n2 < annotationArray2.length ? this.adaptAnnotationArray(annotationArray2[n2]) : EMPTY_ANNOTATION_ARRAY;
            this.parameterAnnotations = annotationArray;
        }
        return annotationArray;
    }

    protected Annotation[] adaptAnnotationArray(Annotation[] annotationArray) {
        return annotationArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodParameter)) {
            return false;
        }
        MethodParameter methodParameter = (MethodParameter)object;
        return this.getContainingClass() == methodParameter.getContainingClass() && ObjectUtils.nullSafeEquals(this.typeIndexesPerLevel, methodParameter.typeIndexesPerLevel) && this.nestingLevel == methodParameter.nestingLevel && this.parameterIndex == methodParameter.parameterIndex && this.executable.equals(methodParameter.executable);
    }

    public int hashCode() {
        return 31 * this.executable.hashCode() + this.parameterIndex;
    }

    public String toString() {
        Method method = this.getMethod();
        return (method != null ? "method '" + method.getName() + "'" : "constructor") + " parameter " + this.parameterIndex;
    }

    public MethodParameter clone() {
        return new MethodParameter(this);
    }

    public static MethodParameter forExecutable(Executable executable, int n2) {
        if (executable instanceof Method) {
            return new MethodParameter((Method)executable, n2);
        }
        if (executable instanceof Constructor) {
            return new MethodParameter((Constructor)executable, n2);
        }
        throw new IllegalArgumentException("Not a Method/Constructor: " + executable);
    }

    private static int validateIndex(Executable executable, int n2) {
        int n3 = executable.getParameterCount();
        Assert.isTrue(n2 >= -1 && n2 < n3, () -> "Parameter index needs to be between -1 and " + (n3 - 1));
        return n2;
    }

    private static class KotlinDelegate {
        private static Type getGenericReturnType(Method method) {
            try {
                KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
                if (kFunction != null && kFunction.isSuspend()) {
                    return ReflectJvmMapping.getJavaType((KType)kFunction.getReturnType());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return method.getGenericReturnType();
        }

        private static Class<?> getReturnType(Method method) {
            try {
                KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
                if (kFunction != null && kFunction.isSuspend()) {
                    Class<Void> clazz = ReflectJvmMapping.getJavaType((KType)kFunction.getReturnType());
                    if (clazz == Unit.class) {
                        clazz = Void.TYPE;
                    }
                    return ResolvableType.forType(clazz).resolve(method.getReturnType());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return method.getReturnType();
        }
    }
}

