/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.file;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.Counters;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.PathFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.SimplePathVisitor;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.SymbolicLinkFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.TrueFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOBiFunction;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;

public class CountingPathVisitor
extends SimplePathVisitor {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Counters.PathCounters pathCounters;
    private final PathFilter fileFilter;
    private final PathFilter dirFilter;

    static IOFileFilter defaultDirFilter() {
        return TrueFileFilter.INSTANCE;
    }

    static IOFileFilter defaultFileFilter() {
        return new SymbolicLinkFileFilter(FileVisitResult.TERMINATE, FileVisitResult.CONTINUE);
    }

    public CountingPathVisitor(Counters.PathCounters pathCounters) {
        this(pathCounters, CountingPathVisitor.defaultFileFilter(), CountingPathVisitor.defaultDirFilter());
    }

    public CountingPathVisitor(Counters.PathCounters pathCounters, PathFilter pathFilter, PathFilter pathFilter2) {
        this.pathCounters = Objects.requireNonNull(pathCounters, "pathCounter");
        this.fileFilter = Objects.requireNonNull(pathFilter, "fileFilter");
        this.dirFilter = Objects.requireNonNull(pathFilter2, "dirFilter");
    }

    public CountingPathVisitor(Counters.PathCounters pathCounters, PathFilter pathFilter, PathFilter pathFilter2, IOBiFunction<Path, IOException, FileVisitResult> iOBiFunction) {
        super(iOBiFunction);
        this.pathCounters = Objects.requireNonNull(pathCounters, "pathCounter");
        this.fileFilter = Objects.requireNonNull(pathFilter, "fileFilter");
        this.dirFilter = Objects.requireNonNull(pathFilter2, "dirFilter");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CountingPathVisitor)) {
            return false;
        }
        CountingPathVisitor countingPathVisitor = (CountingPathVisitor)object;
        return Objects.equals(this.pathCounters, countingPathVisitor.pathCounters);
    }

    public Counters.PathCounters getPathCounters() {
        return this.pathCounters;
    }

    public int hashCode() {
        return Objects.hash(this.pathCounters);
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        this.updateDirCounter(path, iOException);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        FileVisitResult fileVisitResult = this.dirFilter.accept(path, basicFileAttributes);
        return fileVisitResult != FileVisitResult.CONTINUE ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    public String toString() {
        return this.pathCounters.toString();
    }

    protected void updateDirCounter(Path path, IOException iOException) {
        this.pathCounters.getDirectoryCounter().increment();
    }

    protected void updateFileCounters(Path path, BasicFileAttributes basicFileAttributes) {
        this.pathCounters.getFileCounter().increment();
        this.pathCounters.getByteCounter().add(basicFileAttributes.size());
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && this.fileFilter.accept(path, basicFileAttributes) == FileVisitResult.CONTINUE) {
            this.updateFileCounters(path, basicFileAttributes);
        }
        return FileVisitResult.CONTINUE;
    }
}

