/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectCollectors;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectSpliterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableBiMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableEnumMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMapEntry;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMapEntrySet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMapKeySet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMapValues;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.RegularImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;

public abstract class ImmutableMap<K, V>
implements Serializable,
Map<K, V> {
    static final Map.Entry<?, ?>[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> function, Function<? super T, ? extends V> function2) {
        return CollectCollectors.toImmutableMap(function, function2);
    }

    public static <K, V> ImmutableMap<K, V> of() {
        return RegularImmutableMap.EMPTY;
    }

    public static <K, V> ImmutableMap<K, V> of(K k2, V v2) {
        return ImmutableBiMap.of(k2, v2);
    }

    public static <K, V> ImmutableMap<K, V> of(K k2, V v2, K k3, V v3) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3));
    }

    public static <K, V> ImmutableMap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4));
    }

    public static <K, V> ImmutableMap<K, V> of(K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5));
    }

    static <K, V> Map.Entry<K, V> entryOf(K k2, V v2) {
        return new ImmutableMapEntry<K, V>(k2, v2);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> Builder<K, V> builderWithExpectedSize(int n2) {
        CollectPreconditions.checkNonnegative(n2, "expectedSize");
        return new Builder(n2);
    }

    static void checkNoConflict(boolean bl2, String string, Object object, Object object2) {
        if (!bl2) {
            throw ImmutableMap.conflictException(string, object, object2);
        }
    }

    static IllegalArgumentException conflictException(String string, Object object, Object object2) {
        return new IllegalArgumentException("Multiple entries with same " + string + ": " + object + " and " + object2);
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        if (map instanceof ImmutableMap && !(map instanceof SortedMap)) {
            ImmutableMap immutableMap = (ImmutableMap)map;
            if (!immutableMap.isPartialView()) {
                return immutableMap;
            }
        } else if (map instanceof EnumMap) {
            ImmutableMap<K, V> immutableMap = ImmutableMap.copyOfEnumMap((EnumMap)map);
            return immutableMap;
        }
        return ImmutableMap.copyOf(map.entrySet());
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        Map.Entry<?, ?>[] entryArray = Iterables.toArray(iterable, EMPTY_ENTRY_ARRAY);
        switch (entryArray.length) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                Map.Entry<?, ?> entry = Objects.requireNonNull(entryArray[0]);
                return ImmutableMap.of(entry.getKey(), entry.getValue());
            }
        }
        return RegularImmutableMap.fromEntries(entryArray);
    }

    private static <K extends Enum<K>, V> ImmutableMap<K, ? extends V> copyOfEnumMap(EnumMap<?, ? extends V> enumMap) {
        EnumMap enumMap2 = new EnumMap(enumMap);
        for (Map.Entry<?, V> entry : enumMap2.entrySet()) {
            CollectPreconditions.checkEntryNotNull(entry.getKey(), entry.getValue());
        }
        return ImmutableEnumMap.asImmutable(enumMap2);
    }

    ImmutableMap() {
    }

    @Override
    @Deprecated
    public final V put(K k2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V putIfAbsent(K k2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean replace(K k2, V v2, V v3) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V replace(K k2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V computeIfAbsent(K k2, Function<? super K, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V computeIfPresent(K k2, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V compute(K k2, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V merge(K k2, V v2, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        return ((ImmutableCollection)this.values()).contains(object);
    }

    @Override
    public abstract V get(Object var1);

    @Override
    public final V getOrDefault(Object object, V v2) {
        V v3 = this.get(object);
        if (v3 != null) {
            return v3;
        }
        return v2;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = this.createEntrySet()) : immutableSet;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> immutableSet = this.keySet;
        return immutableSet == null ? (this.keySet = this.createKeySet()) : immutableSet;
    }

    abstract ImmutableSet<K> createKeySet();

    UnmodifiableIterator<K> keyIterator() {
        Iterator iterator = ((ImmutableSet)this.entrySet()).iterator();
        return new UnmodifiableIterator<K>(this, (UnmodifiableIterator)iterator){
            final /* synthetic */ UnmodifiableIterator val$entryIterator;
            {
                this.val$entryIterator = unmodifiableIterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$entryIterator.hasNext();
            }

            @Override
            public K next() {
                return ((Map.Entry)this.val$entryIterator.next()).getKey();
            }
        };
    }

    Spliterator<K> keySpliterator() {
        return CollectSpliterators.map(((ImmutableCollection)((Object)this.entrySet())).spliterator(), Map.Entry::getKey);
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> immutableCollection = this.values;
        return immutableCollection == null ? (this.values = this.createValues()) : immutableCollection;
    }

    abstract ImmutableCollection<V> createValues();

    @Override
    public boolean equals(Object object) {
        return Maps.equalsImpl(this, object);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    boolean isHashCodeFast() {
        return false;
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    static abstract class IteratorBasedImmutableMap<K, V>
    extends ImmutableMap<K, V> {
        IteratorBasedImmutableMap() {
        }

        abstract UnmodifiableIterator<Map.Entry<K, V>> entryIterator();

        @Override
        ImmutableSet<K> createKeySet() {
            return new ImmutableMapKeySet(this);
        }

        @Override
        ImmutableSet<Map.Entry<K, V>> createEntrySet() {
            class EntrySetImpl
            extends ImmutableMapEntrySet<K, V> {
                EntrySetImpl() {
                }

                @Override
                ImmutableMap<K, V> map() {
                    return IteratorBasedImmutableMap.this;
                }

                @Override
                public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                    return IteratorBasedImmutableMap.this.entryIterator();
                }
            }
            return new EntrySetImpl();
        }

        @Override
        ImmutableCollection<V> createValues() {
            return new ImmutableMapValues(this);
        }
    }

    public static class Builder<K, V> {
        Comparator<? super V> valueComparator;
        Map.Entry<K, V>[] entries;
        int size;
        boolean entriesUsed;

        public Builder() {
            this(4);
        }

        Builder(int n2) {
            this.entries = new Map.Entry[n2];
            this.size = 0;
            this.entriesUsed = false;
        }

        private void ensureCapacity(int n2) {
            if (n2 > this.entries.length) {
                this.entries = Arrays.copyOf(this.entries, ImmutableCollection.Builder.expandedCapacity(this.entries.length, n2));
                this.entriesUsed = false;
            }
        }

        public Builder<K, V> put(K k2, V v2) {
            this.ensureCapacity(this.size + 1);
            Map.Entry<K, V> entry = ImmutableMap.entryOf(k2, v2);
            this.entries[this.size++] = entry;
            return this;
        }

        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            return this.putAll(map.entrySet());
        }

        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            if (iterable instanceof Collection) {
                this.ensureCapacity(this.size + ((Collection)iterable).size());
            }
            for (Map.Entry<K, V> entry : iterable) {
                this.put(entry);
            }
            return this;
        }

        Builder<K, V> combine(Builder<K, V> builder) {
            Preconditions.checkNotNull(builder);
            this.ensureCapacity(this.size + builder.size);
            System.arraycopy(builder.entries, 0, this.entries, this.size, builder.size);
            this.size += builder.size;
            return this;
        }

        private ImmutableMap<K, V> build(boolean bl2) {
            Map.Entry<K, V>[] entryArray;
            switch (this.size) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    Map.Entry<K, V> entry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableMap.of(entry.getKey(), entry.getValue());
                }
            }
            int n2 = this.size;
            if (this.valueComparator == null) {
                entryArray = this.entries;
            } else {
                if (this.entriesUsed) {
                    this.entries = Arrays.copyOf(this.entries, this.size);
                }
                Map.Entry<K, V>[] entryArray2 = this.entries;
                if (!bl2) {
                    entryArray2 = Builder.lastEntryForEachKey(entryArray2, this.size);
                    n2 = entryArray2.length;
                }
                Arrays.sort(entryArray2, 0, n2, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
                entryArray = entryArray2;
            }
            this.entriesUsed = true;
            return RegularImmutableMap.fromEntryArray(n2, entryArray, bl2);
        }

        public ImmutableMap<K, V> build() {
            return this.buildOrThrow();
        }

        public ImmutableMap<K, V> buildOrThrow() {
            return this.build(true);
        }

        public ImmutableMap<K, V> buildKeepingLast() {
            return this.build(false);
        }

        private static <K, V> Map.Entry<K, V>[] lastEntryForEachKey(Map.Entry<K, V>[] entryArray, int n2) {
            HashSet<K> hashSet = new HashSet<K>();
            BitSet bitSet = new BitSet();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (hashSet.add(entryArray[i2].getKey())) continue;
                bitSet.set(i2);
            }
            if (bitSet.isEmpty()) {
                return entryArray;
            }
            Map.Entry[] entryArray2 = new Map.Entry[n2 - bitSet.cardinality()];
            int n3 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (bitSet.get(i3)) continue;
                entryArray2[n3++] = entryArray[i3];
            }
            return entryArray2;
        }
    }
}

