/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core;

import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.LinkedMultiValueMap;
import com.gradle.maven.extension.internal.dep.org.springframework.util.MultiValueMap;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class CollectionFactory {
    private static final Set<Class<?>> approximableCollectionTypes = new HashSet();
    private static final Set<Class<?>> approximableMapTypes = new HashSet();

    public static <E> Collection<E> createCollection(Class<?> clazz, Class<?> clazz2, int n2) {
        Assert.notNull(clazz, "Collection type must not be null");
        if (LinkedHashSet.class == clazz || HashSet.class == clazz || Set.class == clazz || Collection.class == clazz) {
            return new LinkedHashSet(n2);
        }
        if (ArrayList.class == clazz || List.class == clazz) {
            return new ArrayList(n2);
        }
        if (LinkedList.class == clazz) {
            return new LinkedList();
        }
        if (TreeSet.class == clazz || NavigableSet.class == clazz || SortedSet.class == clazz) {
            return new TreeSet();
        }
        if (EnumSet.class.isAssignableFrom(clazz)) {
            Assert.notNull(clazz2, "Cannot create EnumSet for unknown element type");
            return EnumSet.noneOf(CollectionFactory.asEnumType(clazz2));
        }
        if (clazz.isInterface() || !Collection.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Unsupported Collection type: " + clazz.getName());
        }
        try {
            return (Collection)ReflectionUtils.accessibleConstructor(clazz, new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Could not instantiate Collection type: " + clazz.getName(), throwable);
        }
    }

    public static <K, V> Map<K, V> createMap(Class<?> clazz, Class<?> clazz2, int n2) {
        Assert.notNull(clazz, "Map type must not be null");
        if (clazz.isInterface()) {
            if (Map.class == clazz) {
                return new LinkedHashMap(n2);
            }
            if (SortedMap.class == clazz || NavigableMap.class == clazz) {
                return new TreeMap();
            }
            if (MultiValueMap.class == clazz) {
                return new LinkedMultiValueMap();
            }
            throw new IllegalArgumentException("Unsupported Map interface: " + clazz.getName());
        }
        if (EnumMap.class == clazz) {
            Assert.notNull(clazz2, "Cannot create EnumMap for unknown key type");
            return new EnumMap(CollectionFactory.asEnumType(clazz2));
        }
        if (!Map.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Unsupported Map type: " + clazz.getName());
        }
        try {
            return (Map)ReflectionUtils.accessibleConstructor(clazz, new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Could not instantiate Map type: " + clazz.getName(), throwable);
        }
    }

    private static Class<? extends Enum> asEnumType(Class<?> clazz) {
        Assert.notNull(clazz, "Enum type must not be null");
        if (!Enum.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Supplied type is not an enum: " + clazz.getName());
        }
        return clazz.asSubclass(Enum.class);
    }

    static {
        approximableCollectionTypes.add(Collection.class);
        approximableCollectionTypes.add(List.class);
        approximableCollectionTypes.add(Set.class);
        approximableCollectionTypes.add(SortedSet.class);
        approximableCollectionTypes.add(NavigableSet.class);
        approximableMapTypes.add(Map.class);
        approximableMapTypes.add(SortedMap.class);
        approximableMapTypes.add(NavigableMap.class);
        approximableCollectionTypes.add(ArrayList.class);
        approximableCollectionTypes.add(LinkedList.class);
        approximableCollectionTypes.add(HashSet.class);
        approximableCollectionTypes.add(LinkedHashSet.class);
        approximableCollectionTypes.add(TreeSet.class);
        approximableCollectionTypes.add(EnumSet.class);
        approximableMapTypes.add(HashMap.class);
        approximableMapTypes.add(LinkedHashMap.class);
        approximableMapTypes.add(TreeMap.class);
        approximableMapTypes.add(EnumMap.class);
    }
}

