/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.Label;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.BooleanTypedValue;

public class OpOr
extends Operator {
    public OpOr(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super("or", n2, n3, spelNodeImplArray);
        this.exitTypeDescriptor = "Z";
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.getBooleanValue(expressionState, this.getLeftOperand())) {
            return BooleanTypedValue.TRUE;
        }
        return BooleanTypedValue.forValue(this.getBooleanValue(expressionState, this.getRightOperand()));
    }

    private boolean getBooleanValue(ExpressionState expressionState, SpelNodeImpl spelNodeImpl) {
        try {
            Boolean bl2 = spelNodeImpl.getValue(expressionState, Boolean.class);
            this.assertValueNotNull(bl2);
            return bl2;
        }
        catch (SpelEvaluationException spelEvaluationException) {
            spelEvaluationException.setPosition(spelNodeImpl.getStartPosition());
            throw spelEvaluationException;
        }
    }

    private void assertValueNotNull(Boolean bl2) {
        if (bl2 == null) {
            throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
        }
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl spelNodeImpl = this.getLeftOperand();
        SpelNodeImpl spelNodeImpl2 = this.getRightOperand();
        return spelNodeImpl.isCompilable() && spelNodeImpl2.isCompilable() && CodeFlow.isBooleanCompatible(spelNodeImpl.exitTypeDescriptor) && CodeFlow.isBooleanCompatible(spelNodeImpl2.exitTypeDescriptor);
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        Label label = new Label();
        Label label2 = new Label();
        codeFlow.enterCompilationScope();
        this.getLeftOperand().generateCode(methodVisitor, codeFlow);
        codeFlow.unboxBooleanIfNecessary(methodVisitor);
        codeFlow.exitCompilationScope();
        methodVisitor.visitJumpInsn(153, label);
        methodVisitor.visitLdcInsn(1);
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label);
        codeFlow.enterCompilationScope();
        this.getRightOperand().generateCode(methodVisitor, codeFlow);
        codeFlow.unboxBooleanIfNecessary(methodVisitor);
        codeFlow.exitCompilationScope();
        methodVisitor.visitLabel(label2);
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

