/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class CompositeFileSystemSnapshot
implements FileSystemSnapshot {
    private final ImmutableList<FileSystemSnapshot> snapshots;

    private CompositeFileSystemSnapshot(Collection<? extends FileSystemSnapshot> collection) {
        this.snapshots = ImmutableList.copyOf(collection);
    }

    public static FileSystemSnapshot of(List<? extends FileSystemSnapshot> list) {
        switch (list.size()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return list.get(0);
            }
        }
        return new CompositeFileSystemSnapshot(list);
    }

    @Override
    public SnapshotVisitResult accept(FileSystemSnapshotHierarchyVisitor fileSystemSnapshotHierarchyVisitor) {
        for (FileSystemSnapshot fileSystemSnapshot : this.snapshots) {
            SnapshotVisitResult snapshotVisitResult = fileSystemSnapshot.accept(fileSystemSnapshotHierarchyVisitor);
            if (snapshotVisitResult != SnapshotVisitResult.TERMINATE) continue;
            return SnapshotVisitResult.TERMINATE;
        }
        return SnapshotVisitResult.CONTINUE;
    }

    @Override
    public SnapshotVisitResult accept(RelativePathTracker relativePathTracker, RelativePathTrackingFileSystemSnapshotHierarchyVisitor relativePathTrackingFileSystemSnapshotHierarchyVisitor) {
        for (FileSystemSnapshot fileSystemSnapshot : this.snapshots) {
            SnapshotVisitResult snapshotVisitResult = fileSystemSnapshot.accept(relativePathTracker, relativePathTrackingFileSystemSnapshotHierarchyVisitor);
            if (snapshotVisitResult != SnapshotVisitResult.TERMINATE) continue;
            return SnapshotVisitResult.TERMINATE;
        }
        return SnapshotVisitResult.CONTINUE;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CompositeFileSystemSnapshot compositeFileSystemSnapshot = (CompositeFileSystemSnapshot)object;
        return this.snapshots.equals(compositeFileSystemSnapshot.snapshots);
    }

    public int hashCode() {
        return this.snapshots.hashCode();
    }

    public String toString() {
        return this.snapshots.toString();
    }
}

