/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DataTypeWithLexicalConstraintFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.TypeIncubator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatypeImpl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.regex.RegExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.regex.RegExpFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.Vector;

public final class PatternFacet
extends DataTypeWithLexicalConstraintFacet {
    private transient RegExp[] exps;
    public final String[] patterns;
    private static final long serialVersionUID = 1L;

    public RegExp[] getRegExps() {
        return this.exps;
    }

    public PatternFacet(String string, String string2, XSDatatypeImpl xSDatatypeImpl, TypeIncubator typeIncubator) throws DatatypeException {
        super(string, string2, xSDatatypeImpl, "pattern", typeIncubator.isFixed("pattern"));
        Vector vector = typeIncubator.getVector("pattern");
        this.patterns = vector.toArray(new String[vector.size()]);
        try {
            this.compileRegExps();
        }
        catch (ParseException parseException) {
            throw new DatatypeException(PatternFacet.localize("PatternFacet.ParseError", parseException.getMessage()));
        }
    }

    private void compileRegExps() throws ParseException {
        this.exps = new RegExp[this.patterns.length];
        RegExpFactory regExpFactory = RegExpFactory.createFactory();
        for (int i2 = 0; i2 < this.exps.length; ++i2) {
            this.exps[i2] = regExpFactory.compile(this.patterns[i2]);
        }
    }

    protected void diagnoseByFacet(String string, ValidationContext validationContext) throws DatatypeException {
        if (this.checkLexicalConstraint(string)) {
            return;
        }
        if (this.exps.length == 1) {
            throw new DatatypeException(-1, PatternFacet.localize("DataTypeErrorDiagnosis.Pattern.1", this.patterns[0]));
        }
        throw new DatatypeException(-1, PatternFacet.localize("DataTypeErrorDiagnosis.Pattern.Many"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean checkLexicalConstraint(String string) {
        PatternFacet patternFacet = this;
        synchronized (patternFacet) {
            for (int i2 = 0; i2 < this.exps.length; ++i2) {
                if (!this.exps[i2].matches(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.compileRegExps();
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.getMessage());
        }
    }
}

