/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

public final class StringVector {
    private String[] mStrings;
    private int mSize;

    public StringVector(int n2) {
        this.mStrings = new String[n2];
    }

    public int size() {
        return this.mSize;
    }

    public boolean isEmpty() {
        return this.mSize == 0;
    }

    public String getString(int n2) {
        if (n2 < 0 || n2 >= this.mSize) {
            throw new IllegalArgumentException("Index " + n2 + " out of valid range; current size: " + this.mSize + ".");
        }
        return this.mStrings[n2];
    }

    public String getLastString() {
        if (this.mSize < 1) {
            throw new IllegalStateException("getLastString() called on empty StringVector.");
        }
        return this.mStrings[this.mSize - 1];
    }

    public String[] getInternalArray() {
        return this.mStrings;
    }

    public String[] asArray() {
        String[] stringArray = new String[this.mSize];
        System.arraycopy(this.mStrings, 0, stringArray, 0, this.mSize);
        return stringArray;
    }

    public boolean containsInterned(String string) {
        String[] stringArray = this.mStrings;
        int n2 = this.mSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string) continue;
            return true;
        }
        return false;
    }

    public void addString(String string) {
        if (this.mSize == this.mStrings.length) {
            String[] stringArray = this.mStrings;
            int n2 = stringArray.length;
            this.mStrings = new String[n2 + (n2 << 1)];
            System.arraycopy(stringArray, 0, this.mStrings, 0, n2);
        }
        this.mStrings[this.mSize++] = string;
    }

    public void addStrings(String string, String string2) {
        if (this.mSize + 2 > this.mStrings.length) {
            String[] stringArray = this.mStrings;
            int n2 = stringArray.length;
            this.mStrings = new String[n2 + (n2 << 1)];
            System.arraycopy(stringArray, 0, this.mStrings, 0, n2);
        }
        this.mStrings[this.mSize] = string;
        this.mStrings[this.mSize + 1] = string2;
        this.mSize += 2;
    }

    public void setString(int n2, String string) {
        this.mStrings[n2] = string;
    }

    public void clear(boolean bl2) {
        if (bl2) {
            int n2 = this.mSize;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mStrings[i2] = null;
            }
        }
        this.mSize = 0;
    }

    public String removeLast() {
        String string = this.mStrings[--this.mSize];
        this.mStrings[this.mSize] = null;
        return string;
    }

    public void removeLast(int n2) {
        while (--n2 >= 0) {
            this.mStrings[--this.mSize] = null;
        }
    }

    public String findLastFromMap(String string) {
        int n2 = this.mSize;
        while ((n2 -= 2) >= 0) {
            if (this.mStrings[n2] != string) continue;
            return this.mStrings[n2 + 1];
        }
        return null;
    }

    public String findLastNonInterned(String string) {
        int n2 = this.mSize;
        while ((n2 -= 2) >= 0) {
            String string2 = this.mStrings[n2];
            if (string2 != string && (string2 == null || !string2.equals(string))) continue;
            return this.mStrings[n2 + 1];
        }
        return null;
    }

    public int findLastIndexNonInterned(String string) {
        int n2 = this.mSize;
        while ((n2 -= 2) >= 0) {
            String string2 = this.mStrings[n2];
            if (string2 != string && (string2 == null || !string2.equals(string))) continue;
            return n2;
        }
        return -1;
    }

    public String findLastByValueNonInterned(String string) {
        for (int i2 = this.mSize - 1; i2 > 0; i2 -= 2) {
            String string2 = this.mStrings[i2];
            if (string2 != string && (string2 == null || !string2.equals(string))) continue;
            return this.mStrings[i2 - 1];
        }
        return null;
    }

    public int findLastIndexByValueNonInterned(String string) {
        for (int i2 = this.mSize - 1; i2 > 0; i2 -= 2) {
            String string2 = this.mStrings[i2];
            if (string2 != string && (string2 == null || !string2.equals(string))) continue;
            return i2 - 1;
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.mSize * 16);
        stringBuilder.append("[(size = ");
        stringBuilder.append(this.mSize);
        stringBuilder.append(" ) ");
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('\"');
            stringBuilder.append(this.mStrings[i2]);
            stringBuilder.append('\"');
            stringBuilder.append(" == ");
            stringBuilder.append(Integer.toHexString(System.identityHashCode(this.mStrings[i2])));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

