/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Strings;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.com.google.common.io.CountingOutputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.CloseShieldInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.impl.FilePermissionAccess;
import org.gradle.caching.internal.packaging.impl.RelativePathParser;
import org.gradle.caching.internal.packaging.impl.TarPackerFileSystemSupport;
import org.gradle.internal.RelativePathSupplier;
import org.gradle.internal.file.BufferProvider;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.util.internal.PathTraversalChecker;

public class TarBuildCacheEntryPacker
implements BuildCacheEntryPacker {
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final Pattern TREE_PATH = Pattern.compile("(missing-)?tree-([^/]+)(?:/(.*))?");
    private final TarPackerFileSystemSupport fileSystemSupport;
    private final FilePermissionAccess filePermissionAccess;
    private final StreamHasher streamHasher;
    private final Interner<String> stringInterner;
    private final BufferProvider bufferProvider;

    public TarBuildCacheEntryPacker(TarPackerFileSystemSupport tarPackerFileSystemSupport, FilePermissionAccess filePermissionAccess, StreamHasher streamHasher, Interner<String> interner, BufferProvider bufferProvider) {
        this.fileSystemSupport = tarPackerFileSystemSupport;
        this.filePermissionAccess = filePermissionAccess;
        this.streamHasher = streamHasher;
        this.stringInterner = interner;
        this.bufferProvider = bufferProvider;
    }

    @Override
    public BuildCacheEntryPacker.PackResult pack(CacheableEntity cacheableEntity, Map<String, ? extends FileSystemSnapshot> map, OutputStream outputStream, OriginWriter originWriter) throws IOException {
        BufferedOutputStream bufferedOutputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
        try (TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)bufferedOutputStream, ENCODING.name());){
            tarArchiveOutputStream.setLongFileMode(3);
            tarArchiveOutputStream.setBigNumberMode(2);
            tarArchiveOutputStream.setAddPaxHeadersForNonAsciiNames(true);
            TarBuildCacheEntryPacker.packMetadata(originWriter, tarArchiveOutputStream);
            long l2 = this.pack(cacheableEntity, map, tarArchiveOutputStream);
            BuildCacheEntryPacker.PackResult packResult = new BuildCacheEntryPacker.PackResult(l2 + 1L);
            return packResult;
        }
    }

    private static void packMetadata(OriginWriter originWriter, TarArchiveOutputStream tarArchiveOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        originWriter.execute(byteArrayOutputStream);
        TarBuildCacheEntryPacker.createTarEntry("METADATA", byteArrayOutputStream.size(), 33188, tarArchiveOutputStream);
        tarArchiveOutputStream.write(byteArrayOutputStream.toByteArray());
        tarArchiveOutputStream.closeArchiveEntry();
    }

    private long pack(CacheableEntity cacheableEntity, Map<String, ? extends FileSystemSnapshot> map, TarArchiveOutputStream tarArchiveOutputStream) {
        AtomicLong atomicLong = new AtomicLong();
        cacheableEntity.visitOutputTrees((string, treeType, file) -> {
            FileSystemSnapshot fileSystemSnapshot = (FileSystemSnapshot)map.get(string);
            try {
                long l2 = this.packTree(string, treeType, fileSystemSnapshot, tarArchiveOutputStream);
                atomicLong.addAndGet(l2);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Could not pack tree '%s': %s", string, exception.getMessage()), exception);
            }
        });
        return atomicLong.get();
    }

    private long packTree(String string, TreeType treeType, FileSystemSnapshot fileSystemSnapshot, TarArchiveOutputStream tarArchiveOutputStream) {
        PackingVisitor packingVisitor = new PackingVisitor(tarArchiveOutputStream, string, treeType);
        fileSystemSnapshot.accept(new RelativePathTracker(), packingVisitor);
        return packingVisitor.getPackedEntryCount();
    }

    private static void createTarEntry(String string, long l2, int n2, TarArchiveOutputStream tarArchiveOutputStream) throws IOException {
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(string, true);
        tarArchiveEntry.setSize(l2);
        tarArchiveEntry.setMode(n2);
        tarArchiveOutputStream.putArchiveEntry(tarArchiveEntry);
    }

    @Override
    public BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity cacheableEntity, InputStream inputStream, OriginReader originReader) throws IOException {
        try (TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream(inputStream, ENCODING.name());){
            BuildCacheEntryPacker.UnpackResult unpackResult = this.unpack(cacheableEntity, tarArchiveInputStream, originReader);
            return unpackResult;
        }
    }

    private BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity cacheableEntity, TarArchiveInputStream tarArchiveInputStream, OriginReader originReader) throws IOException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        cacheableEntity.visitOutputTrees((string, treeType, file) -> builder.put(string, new CacheableTree(treeType, file)));
        ImmutableMap immutableMap = builder.build();
        OriginMetadata originMetadata = null;
        HashMap<String, FileSystemLocationSnapshot> hashMap = new HashMap<String, FileSystemLocationSnapshot>();
        TarArchiveEntry tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
        AtomicLong atomicLong = new AtomicLong();
        while (tarArchiveEntry != null) {
            atomicLong.incrementAndGet();
            String string2 = TarBuildCacheEntryPacker.safeEntryName(tarArchiveEntry);
            if (string2.equals("METADATA")) {
                originMetadata = originReader.execute(CloseShieldInputStream.wrap(tarArchiveInputStream));
                tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
                continue;
            }
            Matcher matcher = TREE_PATH.matcher(string2);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached entry format error, invalid contents: " + string2);
            }
            String string3 = TarBuildCacheEntryPacker.unescape(matcher.group(2));
            CacheableTree cacheableTree = (CacheableTree)immutableMap.get(string3);
            if (cacheableTree == null) {
                throw new IllegalStateException(String.format("No tree '%s' registered", string3));
            }
            boolean bl2 = matcher.group(1) != null;
            String string4 = matcher.group(3);
            tarArchiveEntry = this.unpackTree(string3, cacheableTree.getType(), cacheableTree.getRoot(), tarArchiveInputStream, tarArchiveEntry, string4, bl2, hashMap, atomicLong);
        }
        if (originMetadata == null) {
            throw new IllegalStateException("Cached result format error, no origin metadata was found.");
        }
        return new BuildCacheEntryPacker.UnpackResult(originMetadata, atomicLong.get(), hashMap);
    }

    private TarArchiveEntry unpackTree(String string, TreeType treeType, File file, TarArchiveInputStream tarArchiveInputStream, TarArchiveEntry tarArchiveEntry, String string2, boolean bl2, Map<String, FileSystemLocationSnapshot> map, AtomicLong atomicLong) throws IOException {
        boolean bl3 = tarArchiveEntry.isDirectory();
        boolean bl4 = Strings.isNullOrEmpty(string2);
        if (!bl4) {
            throw new IllegalStateException("Root needs to be the first entry in a tree");
        }
        if (bl2) {
            this.fileSystemSupport.ensureFileIsMissing(file);
            return tarArchiveInputStream.getNextTarEntry();
        }
        this.fileSystemSupport.ensureDirectoryForTree(treeType, file);
        if (treeType == TreeType.FILE) {
            if (bl3) {
                throw new IllegalStateException("Should be a file: " + string);
            }
            RegularFileSnapshot regularFileSnapshot = this.unpackFile(tarArchiveInputStream, tarArchiveEntry, file, file.getName());
            map.put(string, regularFileSnapshot);
            return tarArchiveInputStream.getNextTarEntry();
        }
        if (!bl3) {
            throw new IllegalStateException("Should be a directory: " + string);
        }
        this.chmodUnpackedFile(tarArchiveEntry, file);
        return this.unpackDirectoryTree(tarArchiveInputStream, tarArchiveEntry, map, atomicLong, file, string);
    }

    private RegularFileSnapshot unpackFile(TarArchiveInputStream tarArchiveInputStream, TarArchiveEntry tarArchiveEntry, File file, String string) throws IOException {
        try (CountingOutputStream countingOutputStream = new CountingOutputStream(new FileOutputStream(file));){
            HashCode hashCode = this.streamHasher.hashCopy(tarArchiveInputStream, countingOutputStream);
            this.chmodUnpackedFile(tarArchiveEntry, file);
            String string2 = this.stringInterner.intern(file.getAbsolutePath());
            String string3 = this.stringInterner.intern(string);
            RegularFileSnapshot regularFileSnapshot = new RegularFileSnapshot(string2, string3, hashCode, DefaultFileMetadata.file(countingOutputStream.getCount(), file.lastModified(), FileMetadata.AccessType.DIRECT));
            return regularFileSnapshot;
        }
    }

    private TarArchiveEntry unpackDirectoryTree(TarArchiveInputStream tarArchiveInputStream, TarArchiveEntry tarArchiveEntry, Map<String, FileSystemLocationSnapshot> map, AtomicLong atomicLong, File file, String string) throws IOException {
        TarArchiveEntry tarArchiveEntry2;
        RelativePathParser relativePathParser = new RelativePathParser(TarBuildCacheEntryPacker.safeEntryName(tarArchiveEntry));
        DirectorySnapshotBuilder directorySnapshotBuilder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        directorySnapshotBuilder.enterDirectory(FileMetadata.AccessType.DIRECT, this.stringInterner.intern(file.getAbsolutePath()), this.stringInterner.intern(file.getName()), DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
        while ((tarArchiveEntry2 = tarArchiveInputStream.getNextTarEntry()) != null) {
            Object object;
            boolean bl2 = tarArchiveEntry2.isDirectory();
            boolean bl3 = relativePathParser.nextPath(TarBuildCacheEntryPacker.safeEntryName(tarArchiveEntry2), bl2, directorySnapshotBuilder::leaveDirectory);
            if (bl3) break;
            atomicLong.incrementAndGet();
            File file2 = new File(file, relativePathParser.getRelativePath());
            if (bl2) {
                FileUtils.forceMkdir(file2);
                this.chmodUnpackedFile(tarArchiveEntry2, file2);
                object = this.stringInterner.intern(file2.getAbsolutePath());
                String string2 = this.stringInterner.intern(relativePathParser.getName());
                directorySnapshotBuilder.enterDirectory(FileMetadata.AccessType.DIRECT, (String)object, string2, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
                continue;
            }
            object = this.unpackFile(tarArchiveInputStream, tarArchiveEntry2, file2, relativePathParser.getName());
            directorySnapshotBuilder.visitLeafElement((FileSystemLeafSnapshot)object);
        }
        relativePathParser.exitToRoot(directorySnapshotBuilder::leaveDirectory);
        directorySnapshotBuilder.leaveDirectory();
        map.put(string, directorySnapshotBuilder.getResult());
        return tarArchiveEntry2;
    }

    private static String safeEntryName(TarArchiveEntry tarArchiveEntry) {
        return PathTraversalChecker.safePathName(tarArchiveEntry.getName());
    }

    private void chmodUnpackedFile(TarArchiveEntry tarArchiveEntry, File file) {
        this.filePermissionAccess.chmod(file, tarArchiveEntry.getMode() & 0xFFF);
    }

    private static String escape(String string) {
        try {
            return URLEncoder.encode(string, ENCODING.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError();
        }
    }

    private static String unescape(String string) {
        try {
            return URLDecoder.decode(string, ENCODING.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    private class PackingVisitor
    implements RelativePathTrackingFileSystemSnapshotHierarchyVisitor {
        private final TarArchiveOutputStream tarOutput;
        private final String treePath;
        private final String treeRoot;
        private final TreeType type;
        private long packedEntryCount;

        public PackingVisitor(TarArchiveOutputStream tarArchiveOutputStream, String string, TreeType treeType) {
            this.tarOutput = tarArchiveOutputStream;
            this.treePath = "tree-" + TarBuildCacheEntryPacker.escape(string);
            this.treeRoot = this.treePath + "/";
            this.type = treeType;
        }

        @Override
        public SnapshotVisitResult visitEntry(final FileSystemLocationSnapshot fileSystemLocationSnapshot, RelativePathSupplier relativePathSupplier) {
            final boolean bl2 = relativePathSupplier.isRoot();
            final String string = this.getTargetPath(relativePathSupplier);
            fileSystemLocationSnapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                @Override
                public void visitDirectory(DirectorySnapshot directorySnapshot) {
                    PackingVisitor.this.assertCorrectType(bl2, fileSystemLocationSnapshot);
                    File file = new File(fileSystemLocationSnapshot.getAbsolutePath());
                    int n2 = bl2 ? 493 : TarBuildCacheEntryPacker.this.filePermissionAccess.getUnixMode(file);
                    PackingVisitor.this.storeDirectoryEntry(string, n2, PackingVisitor.this.tarOutput);
                }

                @Override
                public void visitRegularFile(RegularFileSnapshot regularFileSnapshot) {
                    PackingVisitor.this.assertCorrectType(bl2, fileSystemLocationSnapshot);
                    File file = new File(fileSystemLocationSnapshot.getAbsolutePath());
                    int n2 = TarBuildCacheEntryPacker.this.filePermissionAccess.getUnixMode(file);
                    PackingVisitor.this.storeFileEntry(file, string, file.length(), n2, PackingVisitor.this.tarOutput);
                }

                @Override
                public void visitMissing(MissingFileSnapshot missingFileSnapshot) {
                    if (!bl2) {
                        throw new RuntimeException(String.format("Couldn't read content of file '%s'", fileSystemLocationSnapshot.getAbsolutePath()));
                    }
                    PackingVisitor.this.storeMissingTree(string, PackingVisitor.this.tarOutput);
                }
            });
            ++this.packedEntryCount;
            return SnapshotVisitResult.CONTINUE;
        }

        public long getPackedEntryCount() {
            return this.packedEntryCount;
        }

        private void assertCorrectType(boolean bl2, FileSystemLocationSnapshot fileSystemLocationSnapshot) {
            if (bl2) {
                switch (this.type) {
                    case DIRECTORY: {
                        if (fileSystemLocationSnapshot.getType() == FileType.Directory) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", fileSystemLocationSnapshot.getAbsolutePath()));
                    }
                    case FILE: {
                        if (fileSystemLocationSnapshot.getType() == FileType.RegularFile) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a file", fileSystemLocationSnapshot.getAbsolutePath()));
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        private String getTargetPath(RelativePathSupplier relativePathSupplier) {
            return relativePathSupplier.isRoot() ? this.treePath : this.treeRoot + relativePathSupplier.toRelativePath();
        }

        private void storeMissingTree(String string, TarArchiveOutputStream tarArchiveOutputStream) {
            try {
                TarBuildCacheEntryPacker.createTarEntry("missing-" + string, 0L, 33188, tarArchiveOutputStream);
                tarArchiveOutputStream.closeArchiveEntry();
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }

        private void storeDirectoryEntry(String string, int n2, TarArchiveOutputStream tarArchiveOutputStream) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(string + "/", 0L, 0x4000 | n2, tarArchiveOutputStream);
                tarArchiveOutputStream.closeArchiveEntry();
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }

        private void storeFileEntry(File file, String string, long l2, int n2, TarArchiveOutputStream tarArchiveOutputStream) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(string, l2, 0x8000 | n2, tarArchiveOutputStream);
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    IOUtils.copyLarge(fileInputStream, tarArchiveOutputStream, TarBuildCacheEntryPacker.this.bufferProvider.getBuffer());
                }
                tarArchiveOutputStream.closeArchiveEntry();
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
    }

    private static class CacheableTree {
        private final TreeType type;
        private final File root;

        public CacheableTree(TreeType treeType, File file) {
            this.type = treeType;
            this.root = file;
        }

        public TreeType getType() {
            return this.type;
        }

        public File getRoot() {
            return this.root;
        }
    }
}

