/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testselection.common.model.api.base;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

abstract class ByteArrayWrapper {
    private final byte[] bytes;

    ByteArrayWrapper(byte[] byArray) {
        this.bytes = byArray;
    }

    public byte[] getBytes() {
        return Objects.requireNonNull(this.bytes);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ByteArrayWrapper byteArrayWrapper = (ByteArrayWrapper)object;
        return Arrays.equals(this.bytes, byteArrayWrapper.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{bytes=" + Arrays.toString(this.bytes) + '}';
    }

    static abstract class Deserializer<T extends ByteArrayWrapper>
    extends StdDeserializer<T> {
        private final Function<byte[], T> creator;

        Deserializer(Class<T> clazz, Function<byte[], T> function) {
            super(clazz);
            this.creator = function;
        }

        @Override
        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16);
            jsonParser.readBinaryValue(byteArrayOutputStream);
            return (T)((ByteArrayWrapper)this.creator.apply(byteArrayOutputStream.toByteArray()));
        }
    }

    static abstract class Serializer<T extends ByteArrayWrapper>
    extends StdSerializer<T> {
        Serializer(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public void serialize(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeBinary(((ByteArrayWrapper)t2).getBytes());
        }
    }
}

