/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Operation;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.NumberUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class OpMultiply
extends Operator {
    public OpMultiply(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super("*", n2, n3, spelNodeImplArray);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        Object object = this.getLeftOperand().getValueInternal(expressionState).getValue();
        Object object2 = this.getRightOperand().getValueInternal(expressionState).getValue();
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
                BigDecimal bigDecimal = NumberUtils.convertNumberToTargetClass(number, BigDecimal.class);
                BigDecimal bigDecimal2 = NumberUtils.convertNumberToTargetClass(number2, BigDecimal.class);
                return new TypedValue(bigDecimal.multiply(bigDecimal2));
            }
            if (number instanceof Double || number2 instanceof Double) {
                this.exitTypeDescriptor = "D";
                return new TypedValue(number.doubleValue() * number2.doubleValue());
            }
            if (number instanceof Float || number2 instanceof Float) {
                this.exitTypeDescriptor = "F";
                return new TypedValue(Float.valueOf(number.floatValue() * number2.floatValue()));
            }
            if (number instanceof BigInteger || number2 instanceof BigInteger) {
                BigInteger bigInteger = NumberUtils.convertNumberToTargetClass(number, BigInteger.class);
                BigInteger bigInteger2 = NumberUtils.convertNumberToTargetClass(number2, BigInteger.class);
                return new TypedValue(bigInteger.multiply(bigInteger2));
            }
            if (number instanceof Long || number2 instanceof Long) {
                this.exitTypeDescriptor = "J";
                return new TypedValue(number.longValue() * number2.longValue());
            }
            if (CodeFlow.isIntegerForNumericOp(number) || CodeFlow.isIntegerForNumericOp(number2)) {
                this.exitTypeDescriptor = "I";
                return new TypedValue(number.intValue() * number2.intValue());
            }
            return new TypedValue(number.doubleValue() * number2.doubleValue());
        }
        if (object instanceof String && object2 instanceof Integer) {
            String string = (String)object;
            int n2 = (Integer)object2;
            int n3 = string.length() * n2;
            this.checkRepeatedTextSize(n3);
            StringBuilder stringBuilder = new StringBuilder(n3);
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(string);
            }
            return new TypedValue(stringBuilder.toString());
        }
        return expressionState.operate(Operation.MULTIPLY, object, object2);
    }

    private void checkRepeatedTextSize(int n2) {
        if (n2 > 256) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MAX_REPEATED_TEXT_SIZE_EXCEEDED, 256);
        }
    }

    @Override
    public boolean isCompilable() {
        if (!this.getLeftOperand().isCompilable()) {
            return false;
        }
        if (this.children.length > 1 && !this.getRightOperand().isCompilable()) {
            return false;
        }
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        this.getLeftOperand().generateCode(methodVisitor, codeFlow);
        String string = this.getLeftOperand().exitTypeDescriptor;
        String string2 = this.exitTypeDescriptor;
        Assert.state(string2 != null, "No exit type descriptor");
        char c2 = string2.charAt(0);
        CodeFlow.insertNumericUnboxOrPrimitiveTypeCoercion(methodVisitor, string, c2);
        if (this.children.length > 1) {
            codeFlow.enterCompilationScope();
            this.getRightOperand().generateCode(methodVisitor, codeFlow);
            String string3 = this.getRightOperand().exitTypeDescriptor;
            codeFlow.exitCompilationScope();
            CodeFlow.insertNumericUnboxOrPrimitiveTypeCoercion(methodVisitor, string3, c2);
            switch (c2) {
                case 'I': {
                    methodVisitor.visitInsn(104);
                    break;
                }
                case 'J': {
                    methodVisitor.visitInsn(105);
                    break;
                }
                case 'F': {
                    methodVisitor.visitInsn(106);
                    break;
                }
                case 'D': {
                    methodVisitor.visitInsn(107);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized exit type descriptor: '" + this.exitTypeDescriptor + "'");
                }
            }
        }
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

