/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.BaseStreamWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed.ValueEncoderFactory;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variant;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.typed.Base64Variants;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public abstract class TypedStreamWriter
extends BaseStreamWriter {
    protected ValueEncoderFactory mValueEncoderFactory;

    protected TypedStreamWriter(XmlWriter xmlWriter, String string, WriterConfig writerConfig) {
        super(xmlWriter, string, writerConfig);
    }

    protected final ValueEncoderFactory valueEncoderFactory() {
        if (this.mValueEncoderFactory == null) {
            this.mValueEncoderFactory = new ValueEncoderFactory();
        }
        return this.mValueEncoderFactory;
    }

    @Override
    public void writeBoolean(boolean bl2) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(bl2));
    }

    @Override
    public void writeInt(int n2) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(n2));
    }

    @Override
    public void writeLong(long l2) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(l2));
    }

    @Override
    public void writeFloat(float f2) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(f2));
    }

    @Override
    public void writeDouble(double d2) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(d2));
    }

    @Override
    public void writeInteger(BigInteger bigInteger) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getScalarEncoder(bigInteger.toString()));
    }

    @Override
    public void writeDecimal(BigDecimal bigDecimal) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getScalarEncoder(bigDecimal.toString()));
    }

    @Override
    public void writeQName(QName qName) throws XMLStreamException {
        this.writeCharacters(this.serializeQName(qName));
    }

    @Override
    public final void writeIntArray(int[] nArray, int n2, int n3) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(nArray, n2, n3));
    }

    @Override
    public void writeLongArray(long[] lArray, int n2, int n3) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(lArray, n2, n3));
    }

    @Override
    public void writeFloatArray(float[] fArray, int n2, int n3) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(fArray, n2, n3));
    }

    @Override
    public void writeDoubleArray(double[] dArray, int n2, int n3) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(dArray, n2, n3));
    }

    @Override
    public void writeBinary(byte[] byArray, int n2, int n3) throws XMLStreamException {
        Base64Variant base64Variant = Base64Variants.getDefaultVariant();
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(base64Variant, byArray, n2, n3));
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws XMLStreamException {
        this.writeTypedElement(this.valueEncoderFactory().getEncoder(base64Variant, byArray, n2, n3));
    }

    protected final void writeTypedElement(AsciiValueEncoder asciiValueEncoder) throws XMLStreamException {
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog()) {
            TypedStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_NONWS_TEXT);
        }
        if (this.mVldContent <= 1) {
            this.reportInvalidContent(4);
        }
        try {
            XMLValidator xMLValidator;
            XMLValidator xMLValidator2 = xMLValidator = this.mVldContent == 3 ? this.mValidator : null;
            if (xMLValidator == null) {
                this.mWriter.writeTypedElement(asciiValueEncoder);
            } else {
                this.mWriter.writeTypedElement(asciiValueEncoder, xMLValidator, this.getCopyBuffer());
            }
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public void writeBooleanAttribute(String string, String string2, String string3, boolean bl2) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(bl2));
    }

    @Override
    public void writeIntAttribute(String string, String string2, String string3, int n2) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(n2));
    }

    @Override
    public void writeLongAttribute(String string, String string2, String string3, long l2) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(l2));
    }

    @Override
    public void writeFloatAttribute(String string, String string2, String string3, float f2) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(f2));
    }

    @Override
    public void writeDoubleAttribute(String string, String string2, String string3, double d2) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(d2));
    }

    @Override
    public void writeIntegerAttribute(String string, String string2, String string3, BigInteger bigInteger) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getScalarEncoder(bigInteger.toString()));
    }

    @Override
    public void writeDecimalAttribute(String string, String string2, String string3, BigDecimal bigDecimal) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getScalarEncoder(bigDecimal.toString()));
    }

    @Override
    public void writeQNameAttribute(String string, String string2, String string3, QName qName) throws XMLStreamException {
        this.writeAttribute(string, string2, string3, this.serializeQName(qName));
    }

    @Override
    public void writeIntArrayAttribute(String string, String string2, String string3, int[] nArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(nArray, 0, nArray.length));
    }

    @Override
    public void writeLongArrayAttribute(String string, String string2, String string3, long[] lArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(lArray, 0, lArray.length));
    }

    @Override
    public void writeFloatArrayAttribute(String string, String string2, String string3, float[] fArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(fArray, 0, fArray.length));
    }

    @Override
    public void writeDoubleArrayAttribute(String string, String string2, String string3, double[] dArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(dArray, 0, dArray.length));
    }

    @Override
    public void writeBinaryAttribute(String string, String string2, String string3, byte[] byArray) throws XMLStreamException {
        Base64Variant base64Variant = Base64Variants.getDefaultVariant();
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(base64Variant, byArray, 0, byArray.length));
    }

    @Override
    public void writeBinaryAttribute(Base64Variant base64Variant, String string, String string2, String string3, byte[] byArray) throws XMLStreamException {
        this.writeTypedAttribute(string, string2, string3, this.valueEncoderFactory().getEncoder(base64Variant, byArray, 0, byArray.length));
    }

    protected abstract void writeTypedAttribute(String var1, String var2, String var3, AsciiValueEncoder var4) throws XMLStreamException;

    private String serializeQName(QName qName) throws XMLStreamException {
        String string = this.validateQNamePrefix(qName);
        String string2 = qName.getLocalPart();
        if (string == null || string.length() == 0) {
            return string2;
        }
        return string + ":" + string2;
    }
}

