/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxEOFException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.AsciiReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BaseReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.CharsetNames;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.EBCDICCodec;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.ISOLatinReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.InputBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.MergedStream;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.UTF32Reader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.UTF8Reader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputLocation;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class StreamBootstrapper
extends InputBootstrapper {
    static final int MIN_BUF_SIZE = 128;
    final InputStream mIn;
    private byte[] mByteBuffer;
    private final boolean mRecycleBuffer;
    private int mInputPtr;
    private int mInputEnd;
    boolean mBigEndian = true;
    boolean mHadBOM = false;
    boolean mByteSizeFound = false;
    int mBytesPerChar;
    boolean mEBCDIC = false;
    String mInputEncoding = null;
    int[] mSingleByteTranslation = null;

    private StreamBootstrapper(String string, SystemId systemId, InputStream inputStream) {
        super(string, systemId);
        this.mIn = inputStream;
        this.mInputEnd = 0;
        this.mInputPtr = 0;
        this.mRecycleBuffer = true;
    }

    private StreamBootstrapper(String string, SystemId systemId, byte[] byArray, int n2, int n3) {
        super(string, systemId);
        this.mIn = null;
        this.mRecycleBuffer = false;
        this.mByteBuffer = byArray;
        this.mInputPtr = n2;
        this.mInputEnd = n3;
    }

    public static StreamBootstrapper getInstance(String string, SystemId systemId, InputStream inputStream) {
        return new StreamBootstrapper(string, systemId, inputStream);
    }

    public static StreamBootstrapper getInstance(String string, SystemId systemId, byte[] byArray, int n2, int n3) {
        return new StreamBootstrapper(string, systemId, byArray, n2, n3);
    }

    @Override
    public Reader bootstrapInput(ReaderConfig readerConfig, boolean bl2, int n2) throws IOException, XMLStreamException {
        BaseReader baseReader;
        String string = null;
        int n3 = readerConfig.getInputBufferLength();
        if (n3 < 128) {
            n3 = 128;
        }
        if (this.mByteBuffer == null) {
            this.mByteBuffer = readerConfig.allocFullBBuffer(n3);
        }
        this.resolveStreamEncoding();
        if (this.hasXmlDecl()) {
            this.readXmlDecl(bl2, n2);
            if (this.mFoundEncoding != null) {
                string = this.verifyXmlEncoding(this.mFoundEncoding);
            }
        } else {
            boolean bl3 = this.mXml11Handling = 272 == n2;
        }
        if (string == null) {
            if (this.mEBCDIC) {
                if (this.mFoundEncoding == null || this.mFoundEncoding.length() == 0) {
                    this.reportXmlProblem("Missing encoding declaration: underlying encoding looks like an EBCDIC variant, but no xml encoding declaration found");
                }
                string = this.mFoundEncoding;
            } else {
                string = this.mBytesPerChar == 2 ? (this.mBigEndian ? "UTF-16BE" : "UTF-16LE") : (this.mBytesPerChar == 4 ? (this.mBigEndian ? "UTF-32BE" : "UTF-32LE") : "UTF-8");
            }
        }
        this.mInputEncoding = string;
        if (string == "UTF-8") {
            baseReader = new UTF8Reader(readerConfig, this.mIn, this.mByteBuffer, this.mInputPtr, this.mInputEnd, this.mRecycleBuffer);
        } else if (string == "ISO-8859-1") {
            baseReader = new ISOLatinReader(readerConfig, this.mIn, this.mByteBuffer, this.mInputPtr, this.mInputEnd, this.mRecycleBuffer);
        } else if (string == "US-ASCII") {
            baseReader = new AsciiReader(readerConfig, this.mIn, this.mByteBuffer, this.mInputPtr, this.mInputEnd, this.mRecycleBuffer);
        } else if (string.startsWith("UTF-32")) {
            if (string == "UTF-32") {
                this.mInputEncoding = this.mBigEndian ? "UTF-32BE" : "UTF-32LE";
            }
            baseReader = new UTF32Reader(readerConfig, this.mIn, this.mByteBuffer, this.mInputPtr, this.mInputEnd, this.mRecycleBuffer, this.mBigEndian);
        } else {
            InputStream inputStream = this.mIn;
            if (this.mInputPtr < this.mInputEnd) {
                inputStream = inputStream == null ? new ByteArrayInputStream(this.mByteBuffer, this.mInputPtr, this.mInputEnd - this.mInputPtr) : new MergedStream(readerConfig, inputStream, this.mByteBuffer, this.mInputPtr, this.mInputEnd);
            } else if (inputStream == null) {
                inputStream = new ByteArrayInputStream(this.mByteBuffer, 0, 0);
            }
            if (string == "UTF-16") {
                string = this.mBigEndian ? "UTF-16BE" : "UTF-16LE";
                this.mInputEncoding = string;
            }
            try {
                return new InputStreamReader(inputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new WstxIOException("Unsupported encoding: " + unsupportedEncodingException.getMessage());
            }
        }
        if (this.mXml11Handling) {
            ((BaseReader)baseReader).setXmlCompliancy(272);
        }
        return baseReader;
    }

    @Override
    public String getInputEncoding() {
        return this.mInputEncoding;
    }

    @Override
    public int getInputTotal() {
        int n2 = this.mInputProcessed + this.mInputPtr;
        if (this.mBytesPerChar > 1) {
            n2 /= this.mBytesPerChar;
        }
        return n2;
    }

    @Override
    public int getInputColumn() {
        int n2 = this.mInputPtr - this.mInputRowStart;
        if (this.mBytesPerChar > 1) {
            n2 /= this.mBytesPerChar;
        }
        return n2;
    }

    protected void resolveStreamEncoding() throws IOException, WstxException {
        this.mBytesPerChar = 0;
        this.mBigEndian = true;
        if (this.ensureLoaded(4)) {
            int n2 = this.mByteBuffer[0] << 24 | (this.mByteBuffer[1] & 0xFF) << 16 | (this.mByteBuffer[2] & 0xFF) << 8 | this.mByteBuffer[3] & 0xFF;
            block0 : switch (n2) {
                case 65279: {
                    this.mBigEndian = true;
                    this.mBytesPerChar = 4;
                    this.mInputPtr = 4;
                    break;
                }
                case -131072: {
                    this.mBytesPerChar = 4;
                    this.mInputPtr = 4;
                    this.mBigEndian = false;
                    break;
                }
                case 65534: {
                    this.reportWeirdUCS4("2143");
                    break;
                }
                case -16842752: {
                    this.reportWeirdUCS4("3412");
                    break;
                }
                default: {
                    int n3 = n2 >>> 16;
                    if (n3 == 65279) {
                        this.mBytesPerChar = 2;
                        this.mInputPtr = 2;
                        this.mBigEndian = true;
                        break;
                    }
                    if (n3 == 65534) {
                        this.mBytesPerChar = 2;
                        this.mInputPtr = 2;
                        this.mBigEndian = false;
                        break;
                    }
                    if (n2 >>> 8 == 0xEFBBBF) {
                        this.mInputPtr = 3;
                        this.mBytesPerChar = 1;
                        this.mBigEndian = true;
                        break;
                    }
                    switch (n2) {
                        case 60: {
                            this.mBigEndian = true;
                            this.mBytesPerChar = 4;
                            break block0;
                        }
                        case 0x3C000000: {
                            this.mBytesPerChar = 4;
                            this.mBigEndian = false;
                            break block0;
                        }
                        case 15360: {
                            this.reportWeirdUCS4("2143");
                            break block0;
                        }
                        case 0x3C0000: {
                            this.reportWeirdUCS4("3412");
                            break block0;
                        }
                        case 3932223: {
                            this.mBytesPerChar = 2;
                            this.mBigEndian = true;
                            break block0;
                        }
                        case 1006649088: {
                            this.mBytesPerChar = 2;
                            this.mBigEndian = false;
                            break block0;
                        }
                        case 1010792557: {
                            this.mBytesPerChar = 1;
                            this.mBigEndian = true;
                            break block0;
                        }
                        case 1282385812: {
                            this.mBytesPerChar = -1;
                            this.mEBCDIC = true;
                            this.mSingleByteTranslation = EBCDICCodec.getCp037Mapping();
                            break block0;
                        }
                    }
                }
            }
            this.mHadBOM = this.mInputPtr > 0;
            this.mInputProcessed = -this.mInputPtr;
            this.mInputRowStart = this.mInputPtr;
        }
        boolean bl2 = this.mByteSizeFound = this.mBytesPerChar != 0;
        if (!this.mByteSizeFound) {
            this.mBytesPerChar = 1;
            this.mBigEndian = true;
        }
    }

    protected String verifyXmlEncoding(String string) throws WstxException {
        if ((string = CharsetNames.normalize(string)) == "UTF-8") {
            this.verifyEncoding(string, 1);
        } else if (string == "ISO-8859-1") {
            this.verifyEncoding(string, 1);
        } else if (string == "US-ASCII") {
            this.verifyEncoding(string, 1);
        } else if (string == "UTF-16") {
            this.verifyEncoding(string, 2);
        } else if (string == "UTF-16LE") {
            this.verifyEncoding(string, 2, false);
        } else if (string == "UTF-16BE") {
            this.verifyEncoding(string, 2, true);
        } else if (string == "UTF-32") {
            this.verifyEncoding(string, 4);
        } else if (string == "UTF-32LE") {
            this.verifyEncoding(string, 4, false);
        } else if (string == "UTF-32BE") {
            this.verifyEncoding(string, 4, true);
        }
        return string;
    }

    protected boolean ensureLoaded(int n2) throws IOException {
        int n3;
        for (int i2 = this.mInputEnd - this.mInputPtr; i2 < n2; i2 += n3) {
            int n4 = n3 = this.mIn == null ? -1 : this.mIn.read(this.mByteBuffer, this.mInputEnd, this.mByteBuffer.length - this.mInputEnd);
            if (n3 < 1) {
                return false;
            }
            this.mInputEnd += n3;
        }
        return true;
    }

    protected void loadMore() throws IOException, WstxException {
        this.mInputProcessed += this.mInputEnd;
        this.mInputRowStart -= this.mInputEnd;
        this.mInputPtr = 0;
        int n2 = this.mInputEnd = this.mIn == null ? -1 : this.mIn.read(this.mByteBuffer, 0, this.mByteBuffer.length);
        if (this.mInputEnd < 1) {
            throw new WstxEOFException(" in xml declaration", this.getLocation());
        }
    }

    @Override
    protected void pushback() {
        this.mInputPtr = this.mBytesPerChar < 0 ? (this.mInputPtr += this.mBytesPerChar) : (this.mInputPtr -= this.mBytesPerChar);
    }

    @Override
    protected int getNext() throws IOException, WstxException {
        if (this.mBytesPerChar != 1) {
            if (this.mBytesPerChar == -1) {
                return this.nextTranslated();
            }
            return this.nextMultiByte();
        }
        byte by2 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
        return by2 & 0xFF;
    }

    @Override
    protected int getNextAfterWs(boolean bl2) throws IOException, WstxException {
        int n2 = this.mBytesPerChar == 1 ? this.skipSbWs() : (this.mBytesPerChar == -1 ? this.skipTranslatedWs() : this.skipMbWs());
        if (bl2 && n2 == 0) {
            this.reportUnexpectedChar(this.getNext(), "; expected a white space");
        }
        if (this.mBytesPerChar != 1) {
            if (this.mBytesPerChar == -1) {
                return this.nextTranslated();
            }
            return this.nextMultiByte();
        }
        byte by2 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
        return by2 & 0xFF;
    }

    @Override
    protected int checkKeyword(String string) throws IOException, WstxException {
        if (this.mBytesPerChar != 1) {
            if (this.mBytesPerChar == -1) {
                return this.checkTranslatedKeyword(string);
            }
            return this.checkMbKeyword(string);
        }
        return this.checkSbKeyword(string);
    }

    @Override
    protected int readQuotedValue(char[] cArray, int n2) throws IOException, WstxException {
        boolean bl2;
        int n3 = 0;
        int n4 = cArray.length;
        boolean bl3 = this.mBytesPerChar == 1;
        boolean bl4 = bl2 = !bl3 && this.mBytesPerChar > 1;
        while (n3 < n4) {
            int n5;
            if (bl3) {
                int n6;
                int n7 = n6 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
                if (n6 == 0) {
                    this.reportNull();
                }
                if (n6 == 13 || n6 == 10) {
                    this.skipSbLF((byte)n6);
                    n6 = 10;
                }
                n5 = n6 & 0xFF;
            } else if (bl2) {
                n5 = this.nextMultiByte();
                if (n5 == 13 || n5 == 10) {
                    this.skipMbLF(n5);
                    n5 = 10;
                }
            } else {
                n5 = this.nextTranslated();
                if (n5 == 13 || n5 == 10) {
                    this.skipTranslatedLF(n5);
                    n5 = 10;
                }
            }
            if (n5 == n2) {
                return n3;
            }
            cArray[n3++] = (char)n5;
        }
        return -1;
    }

    protected boolean hasXmlDecl() throws IOException, WstxException {
        if (this.mBytesPerChar == 1) {
            if (this.ensureLoaded(6) && this.mByteBuffer[this.mInputPtr] == 60 && this.mByteBuffer[this.mInputPtr + 1] == 63 && this.mByteBuffer[this.mInputPtr + 2] == 120 && this.mByteBuffer[this.mInputPtr + 3] == 109 && this.mByteBuffer[this.mInputPtr + 4] == 108 && (this.mByteBuffer[this.mInputPtr + 5] & 0xFF) <= 32) {
                this.mInputPtr += 6;
                return true;
            }
        } else if (this.mBytesPerChar == -1) {
            if (this.ensureLoaded(6)) {
                int n2 = this.mInputPtr;
                if (this.nextTranslated() == 60 && this.nextTranslated() == 63 && this.nextTranslated() == 120 && this.nextTranslated() == 109 && this.nextTranslated() == 108 && this.nextTranslated() <= 32) {
                    return true;
                }
                this.mInputPtr = n2;
            }
        } else if (this.ensureLoaded(6 * this.mBytesPerChar)) {
            int n3 = this.mInputPtr;
            if (this.nextMultiByte() == 60 && this.nextMultiByte() == 63 && this.nextMultiByte() == 120 && this.nextMultiByte() == 109 && this.nextMultiByte() == 108 && this.nextMultiByte() <= 32) {
                return true;
            }
            this.mInputPtr = n3;
        }
        return false;
    }

    @Override
    protected Location getLocation() {
        int n2 = this.mInputProcessed + this.mInputPtr;
        int n3 = this.mInputPtr - this.mInputRowStart;
        if (this.mBytesPerChar > 1) {
            n2 /= this.mBytesPerChar;
            n3 /= this.mBytesPerChar;
        }
        return new WstxInputLocation(null, this.mPublicId, this.mSystemId, (long)(n2 - 1), this.mInputRow, n3);
    }

    protected byte nextByte() throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputEnd) {
            this.loadMore();
        }
        return this.mByteBuffer[this.mInputPtr++];
    }

    protected int skipSbWs() throws IOException, WstxException {
        int n2 = 0;
        while (true) {
            byte by2;
            byte by3 = by2 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            if ((by2 & 0xFF) > 32) {
                --this.mInputPtr;
                break;
            }
            if (by2 == 13 || by2 == 10) {
                this.skipSbLF(by2);
            } else if (by2 == 0) {
                this.reportNull();
            }
            ++n2;
        }
        return n2;
    }

    protected void skipSbLF(byte by2) throws IOException, WstxException {
        if (by2 == 13) {
            byte by3;
            byte by4 = by3 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            if (by3 != 10) {
                --this.mInputPtr;
            }
        }
        ++this.mInputRow;
        this.mInputRowStart = this.mInputPtr;
    }

    protected int checkSbKeyword(String string) throws IOException, WstxException {
        int n2 = string.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            byte by2;
            byte by3 = by2 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            if (by2 == 0) {
                this.reportNull();
            }
            if ((by2 & 0xFF) == string.charAt(i2)) continue;
            return by2 & 0xFF;
        }
        return 0;
    }

    protected int nextMultiByte() throws IOException, WstxException {
        int n2;
        byte by2;
        byte by3 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
        byte by4 = by2 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
        if (this.mBytesPerChar == 2) {
            n2 = this.mBigEndian ? (by3 & 0xFF) << 8 | by2 & 0xFF : by3 & 0xFF | (by2 & 0xFF) << 8;
        } else {
            byte by5 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            byte by6 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
            n2 = this.mBigEndian ? by3 << 24 | (by2 & 0xFF) << 16 | (by5 & 0xFF) << 8 | by6 & 0xFF : by6 << 24 | (by5 & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
        }
        if (n2 == 0) {
            this.reportNull();
        }
        return n2;
    }

    protected int nextTranslated() throws IOException, WstxException {
        byte by2 = this.mInputPtr < this.mInputEnd ? this.mByteBuffer[this.mInputPtr++] : this.nextByte();
        int n2 = this.mSingleByteTranslation[by2 & 0xFF];
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2;
    }

    protected int skipMbWs() throws IOException, WstxException {
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.nextMultiByte()) > 32) {
                this.mInputPtr -= this.mBytesPerChar;
                break;
            }
            if (n3 == 13 || n3 == 10) {
                this.skipMbLF(n3);
            } else if (n3 == 0) {
                this.reportNull();
            }
            ++n2;
        }
        return n2;
    }

    protected int skipTranslatedWs() throws IOException, WstxException {
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.nextTranslated()) > 32 && n3 != 133) {
                --this.mInputPtr;
                break;
            }
            if (n3 == 13 || n3 == 10) {
                this.skipTranslatedLF(n3);
            } else if (n3 == 0) {
                this.reportNull();
            }
            ++n2;
        }
        return n2;
    }

    protected void skipMbLF(int n2) throws IOException, WstxException {
        int n3;
        if (n2 == 13 && (n3 = this.nextMultiByte()) != 10) {
            this.mInputPtr -= this.mBytesPerChar;
        }
        ++this.mInputRow;
        this.mInputRowStart = this.mInputPtr;
    }

    protected void skipTranslatedLF(int n2) throws IOException, WstxException {
        int n3;
        if (n2 == 13 && (n3 = this.nextTranslated()) != 10) {
            --this.mInputPtr;
        }
        ++this.mInputRow;
        this.mInputRowStart = this.mInputPtr;
    }

    protected int checkMbKeyword(String string) throws IOException, WstxException {
        int n2 = string.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = this.nextMultiByte();
            if (n3 == 0) {
                this.reportNull();
            }
            if (n3 == string.charAt(i2)) continue;
            return n3;
        }
        return 0;
    }

    protected int checkTranslatedKeyword(String string) throws IOException, WstxException {
        int n2 = string.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = this.nextTranslated();
            if (n3 == 0) {
                this.reportNull();
            }
            if (n3 == string.charAt(i2)) continue;
            return n3;
        }
        return 0;
    }

    private void verifyEncoding(String string, int n2) throws WstxException {
        if (this.mByteSizeFound && n2 != this.mBytesPerChar) {
            if (this.mEBCDIC) {
                this.reportXmlProblem("Declared encoding '" + string + "' incompatible with auto-detected physical encoding (EBCDIC variant), can not decode input since actual code page not known");
            }
            this.reportXmlProblem("Declared encoding '" + string + "' uses " + n2 + " bytes per character; but physical encoding appeared to use " + this.mBytesPerChar + "; cannot decode");
        }
    }

    private void verifyEncoding(String string, int n2, boolean bl2) throws WstxException {
        if (this.mByteSizeFound) {
            this.verifyEncoding(string, n2);
            if (bl2 != this.mBigEndian) {
                String string2 = bl2 ? "big" : "little";
                this.reportXmlProblem("Declared encoding '" + string + "' has different endianness (" + string2 + " endian) than what physical ordering appeared to be; cannot decode");
            }
        }
    }

    private void reportWeirdUCS4(String string) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + string + ") detected");
    }
}

