/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.BaseNodeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ArrayNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class JsonNodeDeserializer
extends BaseNodeDeserializer<JsonNode> {
    private static final JsonNodeDeserializer instance = new JsonNodeDeserializer();

    protected JsonNodeDeserializer() {
        super(JsonNode.class, null);
    }

    protected JsonNodeDeserializer(JsonNodeDeserializer jsonNodeDeserializer, boolean bl2, boolean bl3) {
        super(jsonNodeDeserializer, bl2, bl3);
    }

    @Override
    protected JsonDeserializer<?> _createWithMerge(boolean bl2, boolean bl3) {
        return new JsonNodeDeserializer(this, bl2, bl3);
    }

    public static JsonDeserializer<? extends JsonNode> getDeserializer(Class<?> clazz) {
        if (clazz == ObjectNode.class) {
            return ObjectDeserializer.getInstance();
        }
        if (clazz == ArrayNode.class) {
            return ArrayDeserializer.getInstance();
        }
        return instance;
    }

    @Override
    public JsonNode getNullValue(DeserializationContext deserializationContext) {
        return deserializationContext.getNodeFactory().nullNode();
    }

    @Override
    public Object getAbsentValue(DeserializationContext deserializationContext) {
        return null;
    }

    @Override
    public JsonNode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        BaseNodeDeserializer.ContainerStack containerStack = new BaseNodeDeserializer.ContainerStack();
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        switch (jsonParser.currentTokenId()) {
            case 1: {
                return this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, containerStack, jsonNodeFactory.objectNode());
            }
            case 2: {
                return jsonNodeFactory.objectNode();
            }
            case 3: {
                return this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, containerStack, jsonNodeFactory.arrayNode());
            }
            case 5: {
                return this._deserializeObjectAtName(jsonParser, deserializationContext, jsonNodeFactory, containerStack);
            }
        }
        return this._deserializeAnyScalar(jsonParser, deserializationContext);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._supportsUpdates;
    }

    static final class ArrayDeserializer
    extends BaseNodeDeserializer<ArrayNode> {
        protected static final ArrayDeserializer _instance = new ArrayDeserializer();

        protected ArrayDeserializer() {
            super(ArrayNode.class, true);
        }

        public static ArrayDeserializer getInstance() {
            return _instance;
        }

        protected ArrayDeserializer(ArrayDeserializer arrayDeserializer, boolean bl2, boolean bl3) {
            super(arrayDeserializer, bl2, bl3);
        }

        @Override
        protected JsonDeserializer<?> _createWithMerge(boolean bl2, boolean bl3) {
            return new ArrayDeserializer(this, bl2, bl3);
        }

        @Override
        public ArrayNode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.isExpectedStartArrayToken()) {
                JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
                ArrayNode arrayNode = jsonNodeFactory.arrayNode();
                this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, new BaseNodeDeserializer.ContainerStack(), arrayNode);
                return arrayNode;
            }
            return (ArrayNode)deserializationContext.handleUnexpectedToken(ArrayNode.class, jsonParser);
        }

        @Override
        public ArrayNode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, ArrayNode arrayNode) throws IOException {
            if (jsonParser.isExpectedStartArrayToken()) {
                this._deserializeContainerNoRecursion(jsonParser, deserializationContext, deserializationContext.getNodeFactory(), new BaseNodeDeserializer.ContainerStack(), arrayNode);
                return arrayNode;
            }
            return (ArrayNode)deserializationContext.handleUnexpectedToken(ArrayNode.class, jsonParser);
        }
    }

    static final class ObjectDeserializer
    extends BaseNodeDeserializer<ObjectNode> {
        protected static final ObjectDeserializer _instance = new ObjectDeserializer();

        protected ObjectDeserializer() {
            super(ObjectNode.class, true);
        }

        public static ObjectDeserializer getInstance() {
            return _instance;
        }

        protected ObjectDeserializer(ObjectDeserializer objectDeserializer, boolean bl2, boolean bl3) {
            super(objectDeserializer, bl2, bl3);
        }

        @Override
        protected JsonDeserializer<?> _createWithMerge(boolean bl2, boolean bl3) {
            return new ObjectDeserializer(this, bl2, bl3);
        }

        @Override
        public ObjectNode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
            if (jsonParser.isExpectedStartObjectToken()) {
                ObjectNode objectNode = jsonNodeFactory.objectNode();
                this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, new BaseNodeDeserializer.ContainerStack(), objectNode);
                return objectNode;
            }
            if (jsonParser.hasToken(JsonToken.FIELD_NAME)) {
                return this._deserializeObjectAtName(jsonParser, deserializationContext, jsonNodeFactory, new BaseNodeDeserializer.ContainerStack());
            }
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return jsonNodeFactory.objectNode();
            }
            return (ObjectNode)deserializationContext.handleUnexpectedToken(ObjectNode.class, jsonParser);
        }

        @Override
        public ObjectNode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, ObjectNode objectNode) throws IOException {
            if (jsonParser.isExpectedStartObjectToken() || jsonParser.hasToken(JsonToken.FIELD_NAME)) {
                return (ObjectNode)this.updateObject(jsonParser, deserializationContext, objectNode, new BaseNodeDeserializer.ContainerStack());
            }
            return (ObjectNode)deserializationContext.handleUnexpectedToken(ObjectNode.class, jsonParser);
        }
    }
}

